/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.ProcessorAction;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.config.HandlerChainInfo;
import com.sun.xml.rpc.processor.config.HandlerInfo;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.processor.util.StringUtils;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.util.localization.Localizable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;

public class ServiceGenerator
implements ProcessorAction {
    private File sourceDir;
    private ProcessorEnvironment env;
    private Model model;

    public ServiceGenerator() {
        this.sourceDir = null;
        this.env = null;
        this.model = null;
    }

    public void perform(Model model, Configuration config, Properties properties) {
        ProcessorEnvironment env = config.getEnvironment();
        String key = "sourceDirectory";
        String dirPath = properties.getProperty(key);
        key = "encodeTypes";
        File sourceDir = new File(dirPath);
        ServiceGenerator generator = new ServiceGenerator(env, sourceDir, model);
        generator.doGeneration();
    }

    private ServiceGenerator(ProcessorEnvironment env, File sourceDir, Model model) {
        this.env = env;
        this.model = model;
        this.sourceDir = sourceDir;
    }

    private void doGeneration() {
        this.env.getNames().resetPrefixFactory();
        Service service = null;
        try {
            try {
                Iterator iter = this.model.getServices();
                while (iter.hasNext()) {
                    service = (Service)iter.next();
                    this.generateService(service);
                }
            }
            catch (IOException e) {
                this.fail("generator.cant.write", service.getName().getLocalPart());
                Object var4_5 = null;
                this.sourceDir = null;
                this.env = null;
            }
            Object var4_4 = null;
            this.sourceDir = null;
            this.env = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.sourceDir = null;
            this.env = null;
            throw throwable;
        }
    }

    private void generateService(Service service) throws IOException {
        try {
            JavaInterface intf = service.getJavaInterface();
            String className = this.env.getNames().interfaceImplClassName(intf);
            String serializerRegistryName = this.env.getNames().serializerRegistryClassName(intf);
            int location = serializerRegistryName.lastIndexOf(".");
            if (service.getName().getLocalPart().equals(serializerRegistryName.substring(0, location))) {
                serializerRegistryName = serializerRegistryName.substring(location + 1, serializerRegistryName.length());
            }
            this.log("creating service: " + className);
            String interfaceName = this.env.getNames().customJavaTypeClassName(intf);
            File classFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
            this.env.addGeneratedFile(classFile);
            IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
            GeneratorBase.writePackage(out, className);
            this.writeImports(out);
            out.pln();
            this.writeClassDecl(out, className, interfaceName);
            this.writeStaticMembers(out, service);
            out.pln();
            this.writeConstructor(out, className, service, serializerRegistryName);
            out.pln();
            this.writeGenericGetPortMethods(out, service);
            out.pln();
            this.writeIndividualGetPorts(out, service.getPorts());
            out.pOln("}");
            out.close();
        }
        catch (Exception e) {
            throw new GeneratorException("generator.nestedGeneratorError", new LocalizableExceptionAdapter(e));
        }
    }

    private void writeImports(IndentingWriter p) throws IOException {
        p.pln("import com.sun.xml.rpc.encoding.*;");
        p.pln("import com.sun.xml.rpc.client.ServiceExceptionImpl;");
        p.pln("import com.sun.xml.rpc.util.exception.*;");
        p.pln("import com.sun.xml.rpc.client.HandlerChainImpl;");
        p.pln("import javax.xml.rpc.*;");
        p.pln("import javax.xml.rpc.encoding.*;");
        p.pln("import javax.xml.rpc.handler.HandlerChain;");
        p.pln("import javax.xml.rpc.handler.HandlerInfo;");
        p.pln("import javax.xml.namespace.QName;");
    }

    private void writeClassDecl(IndentingWriter p, String className, String interfaceName) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public class ");
        this.env.getNames();
        StringBuffer stringBuffer2 = stringBuffer.append(Names.stripQualifier(className)).append(" extends com.sun.xml.rpc.client.BasicService").append(" implements ");
        this.env.getNames();
        p.plnI(stringBuffer2.append(Names.stripQualifier(interfaceName)).append(" {").toString());
    }

    private void writeStaticMembers(IndentingWriter p, Service service) throws IOException {
        p.p("private static final QName serviceName = ");
        GeneratorUtil.writeNewQName(p, service.getName());
        p.pln(";");
        Iterator ports = service.getPorts();
        while (ports.hasNext()) {
            Port port = (Port)ports.next();
            String portClass = port.getJavaInterface().getName();
            QName portName = port.getName();
            p.p("private static final QName " + this.env.getNames().getQNameName(portName) + " = ");
            GeneratorUtil.writeNewQName(p, portName);
            p.pln(";");
            QName portWsdlName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortName");
            if (!portWsdlName.equals(portName)) {
                p.p("private static final QName " + this.env.getNames().getQNameName(portWsdlName) + " = ");
                GeneratorUtil.writeNewQName(p, portWsdlName);
                p.pln(";");
            }
            StringBuffer stringBuffer = new StringBuffer().append("private static final Class ");
            this.env.getNames();
            p.pln(stringBuffer.append(StringUtils.decapitalize(Names.stripQualifier(portClass))).append("_PortClass = ").append(portClass).append(".class;").toString());
        }
    }

    private void writeConstructor(IndentingWriter p, String className, Service service, String serializerRegistryName) throws IOException {
        Port port;
        StringBuffer stringBuffer = new StringBuffer().append("public ");
        this.env.getNames();
        p.plnI(stringBuffer.append(Names.stripQualifier(className)).append("() {").toString());
        p.plnI("super(serviceName, new QName[] {");
        p.pI(3);
        Iterator eachPort = service.getPorts();
        int i = 0;
        while (eachPort.hasNext()) {
            port = (Port)eachPort.next();
            if (i > 0) {
                p.pln(",");
            }
            p.p(this.env.getNames().getQNameName(port.getName()));
            ++i;
        }
        p.pln();
        p.pOln("},");
        p.pO(2);
        p.pln("new " + serializerRegistryName + "().getRegistry());");
        p.pO();
        eachPort = service.getPorts();
        if (eachPort.hasNext()) {
            p.pln();
            while (eachPort.hasNext()) {
                port = (Port)eachPort.next();
                HandlerChainInfo portClientHandlers = port.getClientHandlerChainInfo();
                Iterator eachHandler = portClientHandlers.getHandlers();
                if (!eachHandler.hasNext()) continue;
                p.plnI("{");
                p.pln("java.util.List handlerInfos = new java.util.Vector();");
                while (eachHandler.hasNext()) {
                    Object[] headers;
                    HandlerInfo currentHandler = (HandlerInfo)eachHandler.next();
                    Map properties = currentHandler.getProperties();
                    String propertiesName = "null";
                    p.plnI("{");
                    if (properties.size() > 0) {
                        propertiesName = "props";
                        p.pln("java.util.Map " + propertiesName + " = new java.util.HashMap();");
                        Iterator entries = properties.entrySet().iterator();
                        while (entries.hasNext()) {
                            Map.Entry entry = entries.next();
                            p.pln(propertiesName + ".put(\"" + (String)entry.getKey() + "\", \"" + (String)entry.getValue() + "\");");
                        }
                    }
                    if ((headers = currentHandler.getHeaderNames().toArray()) != null && headers.length > 0) {
                        p.plnI("QName[] headers = {");
                        int i2 = 0;
                        while (i2 < headers.length) {
                            QName hdr2 = (QName)headers[i2];
                            p.pln("new QName(\"" + hdr2.getNamespaceURI() + "\"" + ", " + "\"" + hdr2.getLocalPart() + "\"" + ")" + (i2 != headers.length - 1 ? "," : ""));
                            ++i2;
                        }
                        p.pOln("};");
                    } else {
                        p.pln("QName[] headers = null;");
                    }
                    p.pln("HandlerInfo handlerInfo = new HandlerInfo(" + currentHandler.getHandlerClassName() + ".class" + ", " + propertiesName + ", headers);");
                    p.pln("handlerInfos.add(handlerInfo);");
                    p.pOln("}");
                }
                p.pln("getHandlerRegistry().setHandlerChain(" + this.env.getNames().getQNameName((QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortName")) + ", handlerInfos);");
                p.pOln("}");
            }
        }
        p.pOln("}");
    }

    private void writeGenericGetPortMethods(IndentingWriter p, Service service) throws IOException {
        String portName;
        String portClass;
        Port port;
        Iterator ports = service.getPorts();
        p.plnI("public java.rmi.Remote getPort(QName portName, Class serviceDefInterface) throws ServiceException {");
        p.plnI("try {");
        while (ports.hasNext()) {
            port = (Port)ports.next();
            portClass = port.getJavaInterface().getName();
            portName = this.env.getNames().getPortName(port);
            p.plnI("if (portName.equals(" + this.env.getNames().getQNameName(port.getName()) + ") &&");
            StringBuffer stringBuffer = new StringBuffer().append("serviceDefInterface.equals(");
            this.env.getNames();
            p.pln(stringBuffer.append(StringUtils.decapitalize(Names.stripQualifier(portClass))).append("_PortClass)) {").toString());
            portName = portName.substring(0, 1).toUpperCase() + portName.substring(1, portName.length());
            p.pln("return get" + portName + "();");
            p.pOln("}");
        }
        p.pOlnI("} catch (Exception e) {");
        p.pln("throw new ServiceExceptionImpl(new LocalizableExceptionAdapter(e));");
        p.pOln("}");
        p.pln("return super.getPort(portName, serviceDefInterface);");
        p.pOln("}");
        p.pln();
        ports = service.getPorts();
        p.plnI("public java.rmi.Remote getPort(Class serviceDefInterface) throws ServiceException {");
        p.plnI("try {");
        while (ports.hasNext()) {
            port = (Port)ports.next();
            portClass = port.getJavaInterface().getName();
            portName = this.env.getNames().getPortName(port);
            portName = portName.substring(0, 1).toUpperCase() + portName.substring(1, portName.length());
            StringBuffer stringBuffer = new StringBuffer().append("if (serviceDefInterface.equals(");
            this.env.getNames();
            p.plnI(stringBuffer.append(StringUtils.decapitalize(Names.stripQualifier(portClass))).append("_PortClass)) {").toString());
            p.pln("return get" + portName + "();");
            p.pOln("}");
        }
        p.pOlnI("} catch (Exception e) {");
        p.pln("throw new ServiceExceptionImpl(new LocalizableExceptionAdapter(e));");
        p.pOln("}");
        p.pln("return super.getPort(serviceDefInterface);");
        p.pOln("}");
    }

    private void writeIndividualGetPorts(IndentingWriter p, Iterator ports) throws IOException {
        while (ports.hasNext()) {
            Port port = (Port)ports.next();
            String portClass = port.getJavaInterface().getName();
            String portName = this.env.getNames().getPortName(port);
            QName portWsdlName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortName");
            portName = portName.substring(0, 1).toUpperCase() + portName.substring(1, portName.length());
            p.plnI("public " + portClass + " get" + portName + "() {");
            Set roles = port.getClientHandlerChainInfo().getRoles();
            p.p("String[] roles = new String[] {");
            boolean first = true;
            Iterator i = roles.iterator();
            while (i.hasNext()) {
                if (!first) {
                    p.p(", ");
                } else {
                    first = false;
                }
                p.p("\"" + i.next() + "\"");
            }
            p.pln("};");
            p.pln("HandlerChainImpl handlerChain = new HandlerChainImpl(getHandlerRegistry().getHandlerChain(" + this.env.getNames().getQNameName(portWsdlName) + "));");
            p.pln("handlerChain.setRoles(roles);");
            p.pln(this.env.getNames().stubFor(port.getJavaInterface()) + " stub = new " + this.env.getNames().stubFor(port.getJavaInterface()) + "(handlerChain);");
            p.plnI("try {");
            p.pln("stub._initialize(super.internalTypeRegistry);");
            p.pOlnI("} catch (JAXRPCException e) {");
            p.pln("throw e;");
            p.pOlnI("} catch (Exception e) {");
            p.pln("throw new JAXRPCException(e.getMessage(), e);");
            p.pOln("}");
            p.pln("return stub;");
            p.pOln("}");
        }
    }

    private void log(String msg) {
        if (this.env.verbose()) {
            StringBuffer stringBuffer = new StringBuffer().append("[");
            this.env.getNames();
            System.out.println(stringBuffer.append(Names.stripQualifier(this.getClass().getName())).append(": ").append(msg).append("]").toString());
        }
    }

    protected void fail(String key) {
        throw new GeneratorException(key);
    }

    protected void fail(String key, String arg) {
        throw new GeneratorException(key, arg);
    }

    protected void fail(String key, String arg1, String arg2) {
        throw new GeneratorException(key, new Object[]{arg1, arg2});
    }

    protected void fail(Localizable arg) {
        throw new GeneratorException("generator.nestedGeneratorError", arg);
    }

    protected void fail(Throwable arg) {
        throw new GeneratorException("generator.nestedGeneratorError", new LocalizableExceptionAdapter(arg));
    }
}

