/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.encoding.InternalEncodingConstants;
import com.sun.xml.rpc.processor.config.ImportedDocumentInfo;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.SOAPObjectSerializerGenerator;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Message;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaEnumerationEntry;
import com.sun.xml.rpc.processor.model.java.JavaEnumerationType;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.soap.RPCRequestOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCRequestUnorderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.model.soap.SOAPTypeVisitor;
import com.sun.xml.rpc.processor.model.soap.SOAPUnorderedStructureType;
import com.sun.xml.rpc.processor.modeler.rmi.SOAPSimpleTypeCreator;
import com.sun.xml.rpc.wsdl.document.Definitions;
import com.sun.xml.rpc.wsdl.document.Import;
import com.sun.xml.rpc.wsdl.document.Types;
import com.sun.xml.rpc.wsdl.document.WSDLConstants;
import com.sun.xml.rpc.wsdl.document.WSDLDocument;
import com.sun.xml.rpc.wsdl.document.schema.Schema;
import com.sun.xml.rpc.wsdl.document.schema.SchemaAttribute;
import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;
import com.sun.xml.rpc.wsdl.document.schema.SchemaElement;
import com.sun.xml.rpc.wsdl.document.schema.SchemaKinds;
import com.sun.xml.rpc.wsdl.document.soap.SOAPConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class WSDLTypeGenerator {
    private Model model;
    private WSDLDocument document;
    private Definitions definitions;
    private Set generatedTypes;
    private Map nsSchemaMap;
    private Set actuallyImportedDocuments;
    private SOAPSimpleTypeCreator soapTypes;

    public WSDLTypeGenerator(Model model, WSDLDocument document) {
        this.model = model;
        this.document = document;
        this.definitions = document.getDefinitions();
        this.generatedTypes = new HashSet();
        this.nsSchemaMap = new HashMap();
        this.actuallyImportedDocuments = new HashSet();
        this.soapTypes = new SOAPSimpleTypeCreator();
    }

    public void run() throws Exception {
        Types types = new Types();
        Iterator services = this.model.getServices();
        while (services.hasNext()) {
            Service service = (Service)services.next();
            Iterator ports = service.getPorts();
            while (ports.hasNext()) {
                Port port = (Port)ports.next();
                Iterator operations = port.getOperations();
                while (operations.hasNext()) {
                    Operation operation = (Operation)operations.next();
                    this.processTypesInMessage(operation.getRequest());
                    this.processTypesInMessage(operation.getResponse());
                    Iterator faults = operation.getAllFaults();
                    while (faults != null && faults.hasNext()) {
                        Fault fault = (Fault)faults.next();
                        this.processFault(fault);
                    }
                }
            }
        }
        Iterator iter = this.model.getExtraTypes();
        while (iter.hasNext()) {
            this.processType((AbstractType)iter.next());
        }
        ArrayList<ImportedDocumentInfo> importedDocumentsInReverseOrder = new ArrayList<ImportedDocumentInfo>();
        Iterator iter2 = this.actuallyImportedDocuments.iterator();
        while (iter2.hasNext()) {
            ImportedDocumentInfo docInfo = (ImportedDocumentInfo)iter2.next();
            Import anImport = new Import();
            anImport.setNamespace(docInfo.getNamespace());
            anImport.setLocation(docInfo.getLocation());
            this.definitions.add(anImport);
            importedDocumentsInReverseOrder.add(0, docInfo);
        }
        Iterator iter3 = this.nsSchemaMap.values().iterator();
        while (iter3.hasNext()) {
            SchemaElement importElement;
            Schema schema = (Schema)iter3.next();
            Iterator definedEntities = schema.definedEntities();
            if (!definedEntities.hasNext()) continue;
            SchemaElement schemaContent = schema.getContent();
            Iterator iter22 = importedDocumentsInReverseOrder.iterator();
            while (iter22.hasNext()) {
                ImportedDocumentInfo docInfo = (ImportedDocumentInfo)iter22.next();
                importElement = new SchemaElement(SchemaConstants.QNAME_IMPORT);
                importElement.addAttribute("namespace", docInfo.getNamespace());
                importElement.addAttribute("schemaLocation", docInfo.getLocation());
                schemaContent.insertChildAtTop(importElement);
            }
            Iterator iter32 = this.nsSchemaMap.keySet().iterator();
            while (iter32.hasNext()) {
                Schema anotherSchema;
                Iterator anotherSchemaDefinedEntities;
                String nsURI = (String)iter32.next();
                if (schema.getTargetNamespaceURI().equals(nsURI) || !(anotherSchemaDefinedEntities = (anotherSchema = (Schema)this.nsSchemaMap.get(nsURI)).definedEntities()).hasNext()) continue;
                SchemaElement importElement2 = new SchemaElement(SchemaConstants.QNAME_IMPORT);
                importElement2.addAttribute("namespace", nsURI);
                schemaContent.insertChildAtTop(importElement2);
            }
            importElement = new SchemaElement(SchemaConstants.QNAME_IMPORT);
            importElement.addAttribute("namespace", "http://schemas.xmlsoap.org/soap/encoding/");
            schemaContent.insertChildAtTop(importElement);
            types.addExtension(schema);
        }
        this.definitions.setTypes(types);
    }

    private void processTypesInMessage(Message message) throws Exception {
        if (message == null) {
            return;
        }
        Iterator iter = message.getBodyBlocks();
        while (iter.hasNext()) {
            Block block = (Block)iter.next();
            AbstractType type = block.getType();
            this.processType(type);
        }
        Iterator iter2 = message.getHeaderBlocks();
        while (iter2.hasNext()) {
            Block block = (Block)iter2.next();
            AbstractType type = block.getType();
            this.processType(type);
        }
    }

    private void processType(AbstractType type) throws Exception {
        if (!(type instanceof RPCRequestOrderedStructureType || type instanceof RPCRequestOrderedStructureType || type instanceof RPCResponseStructureType || type.getName() != null && !this.generatedTypes.contains(type.getName()))) {
            return;
        }
        if (type.getName().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") || type.getName().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            return;
        }
        ImportedDocumentInfo docInfo = this.model.getImportedDocument(type.getName().getNamespaceURI());
        if (docInfo != null && docInfo.getType() == 1) {
            this.actuallyImportedDocuments.add(docInfo);
            return;
        }
        Schema schema = (Schema)this.nsSchemaMap.get(type.getName().getNamespaceURI());
        if (schema == null) {
            schema = new Schema(this.document);
            schema.setTargetNamespaceURI(type.getName().getNamespaceURI());
            SchemaElement schemaElement = new SchemaElement(SchemaConstants.QNAME_SCHEMA);
            schemaElement.addAttribute("targetNamespace", schema.getTargetNamespaceURI());
            schemaElement.addPrefix("", "http://www.w3.org/2001/XMLSchema");
            schemaElement.addPrefix("wsdl", "http://schemas.xmlsoap.org/wsdl/");
            schemaElement.addPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            schemaElement.addPrefix("soap-enc", "http://schemas.xmlsoap.org/soap/encoding/");
            schemaElement.addPrefix("tns", schema.getTargetNamespaceURI());
            schema.setContent(schemaElement);
            this.nsSchemaMap.put(type.getName().getNamespaceURI(), schema);
        }
        if (type.isLiteralType()) {
            throw new GeneratorException("generator.literalTypesNotSupported", new Object[]{type.getName().getLocalPart(), type.getName().getNamespaceURI()});
        }
        this.generatedTypes.add(type.getName());
        this.processType((SOAPType)type, schema);
    }

    private void processType(SOAPType type, final Schema schema) throws Exception {
        type.accept(new SOAPTypeVisitor(){

            public void visit(SOAPArrayType type) throws Exception {
                SchemaElement complexType = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
                schema.getContent().addChild(complexType);
                complexType.addAttribute("name", type.getName().getLocalPart());
                SchemaElement complexContent = new SchemaElement(SchemaConstants.QNAME_COMPLEX_CONTENT);
                complexType.addChild(complexContent);
                SchemaElement restriction = new SchemaElement(SchemaConstants.QNAME_RESTRICTION);
                complexContent.addChild(restriction);
                restriction.addAttribute("base", "soap-enc:Array");
                SchemaElement attribute = new SchemaElement(SchemaConstants.QNAME_ATTRIBUTE);
                restriction.addChild(attribute);
                attribute.addAttribute("ref", SOAPConstants.QNAME_ATTR_ARRAY_TYPE);
                schema.defineEntity(complexType, SchemaKinds.XSD_TYPE, type.getName());
                SchemaAttribute wsdlArrayTypeAttribute = new SchemaAttribute(WSDLConstants.QNAME_ATTR_ARRAY_TYPE.getLocalPart());
                wsdlArrayTypeAttribute.setNamespaceURI(WSDLConstants.QNAME_ATTR_ARRAY_TYPE.getNamespaceURI());
                String arrayTypeString = attribute.asString(type.getElementType().getName()) + "[]";
                wsdlArrayTypeAttribute.setValue(arrayTypeString);
                attribute.addAttribute(wsdlArrayTypeAttribute);
                WSDLTypeGenerator.this.processType(type.getElementType());
            }

            public void visit(SOAPCustomType type) throws Exception {
                SchemaElement complexType = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
                schema.getContent().addChild(complexType);
                complexType.addAttribute("name", type.getName().getLocalPart());
                SchemaElement complexContent = new SchemaElement(SchemaConstants.QNAME_SEQUENCE);
                complexType.addChild(complexContent);
                SchemaElement restriction = new SchemaElement(SchemaConstants.QNAME_ANY);
                complexContent.addChild(restriction);
                schema.defineEntity(complexType, SchemaKinds.XSD_TYPE, type.getName());
            }

            public void visit(SOAPEnumerationType type) throws Exception {
                SchemaElement simpleType = new SchemaElement(SchemaConstants.QNAME_SIMPLE_TYPE);
                schema.getContent().addChild(simpleType);
                simpleType.addAttribute("name", type.getName().getLocalPart());
                SchemaElement restriction = new SchemaElement(SchemaConstants.QNAME_RESTRICTION);
                simpleType.addChild(restriction);
                restriction.addAttribute("base", type.getBaseType().getName());
                JavaEnumerationType javaType = (JavaEnumerationType)type.getJavaType();
                Iterator iter = javaType.getEntries();
                while (iter.hasNext()) {
                    JavaEnumerationEntry entry = (JavaEnumerationEntry)iter.next();
                    SchemaElement enumeration = new SchemaElement(SchemaConstants.QNAME_ENUMERATION);
                    enumeration.addAttribute("value", entry.getLiteralValue());
                    restriction.addChild(enumeration);
                }
                schema.defineEntity(simpleType, SchemaKinds.XSD_TYPE, type.getName());
            }

            public void visit(SOAPSimpleType type) throws Exception {
                if (type.getName().getNamespaceURI().equals("http://java.sun.com/jax-rpc-ri/internal")) {
                    if (type.getName().equals(InternalEncodingConstants.QNAME_TYPE_JAX_RPC_MAP_ENTRY)) {
                        this.writeJAXRpcMapEntryType();
                    } else if (type.getName().equals(InternalEncodingConstants.QNAME_TYPE_MAP)) {
                        this.writeMapType();
                        WSDLTypeGenerator.this.processType(((WSDLTypeGenerator)WSDLTypeGenerator.this).soapTypes.JAX_RPC_MAP_ENTRY_SOAPTYPE);
                    } else if (type.getName().equals(InternalEncodingConstants.QNAME_TYPE_HASH_MAP) || type.getName().equals(InternalEncodingConstants.QNAME_TYPE_TREE_MAP) || type.getName().equals(InternalEncodingConstants.QNAME_TYPE_HASHTABLE) || type.getName().equals(InternalEncodingConstants.QNAME_TYPE_PROPERTIES)) {
                        this.writeTypeSubtype(type, InternalEncodingConstants.QNAME_TYPE_MAP);
                        WSDLTypeGenerator.this.processType(((WSDLTypeGenerator)WSDLTypeGenerator.this).soapTypes.MAP_SOAPTYPE);
                    } else if (type.getName().equals(InternalEncodingConstants.QNAME_TYPE_COLLECTION)) {
                        this.writeCollectionType(type);
                    } else if (type.getName().equals(InternalEncodingConstants.QNAME_TYPE_LIST) || type.getName().equals(InternalEncodingConstants.QNAME_TYPE_SET)) {
                        this.writeTypeSubtype(type, InternalEncodingConstants.QNAME_TYPE_COLLECTION);
                        WSDLTypeGenerator.this.processType(((WSDLTypeGenerator)WSDLTypeGenerator.this).soapTypes.COLLECTION_SOAPTYPE);
                    } else if (type.getName().equals(InternalEncodingConstants.QNAME_TYPE_ARRAY_LIST) || type.getName().equals(InternalEncodingConstants.QNAME_TYPE_VECTOR) || type.getName().equals(InternalEncodingConstants.QNAME_TYPE_STACK) || type.getName().equals(InternalEncodingConstants.QNAME_TYPE_LINKED_LIST)) {
                        this.writeTypeSubtype(type, InternalEncodingConstants.QNAME_TYPE_LIST);
                        WSDLTypeGenerator.this.processType(((WSDLTypeGenerator)WSDLTypeGenerator.this).soapTypes.LIST_SOAPTYPE);
                    } else if (type.getName().equals(InternalEncodingConstants.QNAME_TYPE_HASH_SET) || type.getName().equals(InternalEncodingConstants.QNAME_TYPE_TREE_SET)) {
                        this.writeTypeSubtype(type, InternalEncodingConstants.QNAME_TYPE_SET);
                        WSDLTypeGenerator.this.processType(((WSDLTypeGenerator)WSDLTypeGenerator.this).soapTypes.SET_SOAPTYPE);
                    } else {
                        SchemaElement simpleType = new SchemaElement(SchemaConstants.QNAME_SIMPLE_TYPE);
                        schema.getContent().addChild(simpleType);
                        simpleType.addAttribute("name", type.getName().getLocalPart());
                        SchemaElement restriction = new SchemaElement(SchemaConstants.QNAME_RESTRICTION);
                        simpleType.addChild(restriction);
                        QName baseType = SchemaConstants.QNAME_TYPE_BASE64_BINARY;
                        if (type.getName().equals(InternalEncodingConstants.QNAME_TYPE_SOURCE)) {
                            baseType = SchemaConstants.QNAME_TYPE_STRING;
                        }
                        restriction.addAttribute("base", baseType);
                        schema.defineEntity(simpleType, SchemaKinds.XSD_TYPE, type.getName());
                    }
                }
            }

            private void writeJAXRpcMapEntryType() throws Exception {
                SchemaElement complexType = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
                schema.getContent().addChild(complexType);
                complexType.addAttribute("name", InternalEncodingConstants.QNAME_TYPE_JAX_RPC_MAP_ENTRY.getLocalPart());
                SchemaElement sequenceParent = complexType;
                SchemaElement sequence = new SchemaElement(SchemaConstants.QNAME_SEQUENCE);
                sequenceParent.addChild(sequence);
                SchemaElement element = new SchemaElement(SchemaConstants.QNAME_ELEMENT);
                sequence.addChild(element);
                element.addAttribute("name", InternalEncodingConstants.JAX_RPC_MAP_ENTRY_KEY_NAME.getLocalPart());
                element.addAttribute("type", SchemaConstants.QNAME_TYPE_URTYPE);
                element = new SchemaElement(SchemaConstants.QNAME_ELEMENT);
                sequence.addChild(element);
                element.addAttribute("name", InternalEncodingConstants.JAX_RPC_MAP_ENTRY_VALUE_NAME.getLocalPart());
                element.addAttribute("type", SchemaConstants.QNAME_TYPE_URTYPE);
                schema.defineEntity(complexType, SchemaKinds.XSD_TYPE, InternalEncodingConstants.QNAME_TYPE_JAX_RPC_MAP_ENTRY);
            }

            private void writeMapType() throws Exception {
                SchemaElement complexType = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
                schema.getContent().addChild(complexType);
                complexType.addAttribute("name", InternalEncodingConstants.QNAME_TYPE_MAP.getLocalPart());
                SchemaElement complexContent = new SchemaElement(SchemaConstants.QNAME_COMPLEX_CONTENT);
                complexType.addChild(complexContent);
                SchemaElement restriction = new SchemaElement(SchemaConstants.QNAME_RESTRICTION);
                complexContent.addChild(restriction);
                restriction.addAttribute("base", "soap-enc:Array");
                SchemaElement attribute = new SchemaElement(SchemaConstants.QNAME_ATTRIBUTE);
                restriction.addChild(attribute);
                attribute.addAttribute("ref", SOAPConstants.QNAME_ATTR_ARRAY_TYPE);
                schema.defineEntity(complexType, SchemaKinds.XSD_TYPE, InternalEncodingConstants.QNAME_TYPE_MAP);
                SchemaAttribute wsdlArrayTypeAttribute = new SchemaAttribute(WSDLConstants.QNAME_ATTR_ARRAY_TYPE.getLocalPart());
                wsdlArrayTypeAttribute.setNamespaceURI(WSDLConstants.QNAME_ATTR_ARRAY_TYPE.getNamespaceURI());
                String arrayTypeString = attribute.asString(InternalEncodingConstants.QNAME_TYPE_JAX_RPC_MAP_ENTRY) + "[]";
                wsdlArrayTypeAttribute.setValue(arrayTypeString);
                attribute.addAttribute(wsdlArrayTypeAttribute);
            }

            private void writeTypeSubtype(AbstractType type, QName superTypeName) throws Exception {
                SchemaElement complexType = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
                schema.getContent().addChild(complexType);
                complexType.addAttribute("name", type.getName().getLocalPart());
                SchemaElement complexContent = new SchemaElement(SchemaConstants.QNAME_COMPLEX_CONTENT);
                complexType.addChild(complexContent);
                SchemaElement extension = new SchemaElement(SchemaConstants.QNAME_EXTENSION);
                complexContent.addChild(extension);
                extension.addAttribute("base", superTypeName);
                SchemaElement sequenceParent = extension;
                SchemaElement sequence = new SchemaElement(SchemaConstants.QNAME_SEQUENCE);
                sequenceParent.addChild(sequence);
                schema.defineEntity(complexType, SchemaKinds.XSD_TYPE, type.getName());
            }

            private void writeCollectionType(AbstractType type) throws Exception {
                SchemaElement complexType = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
                schema.getContent().addChild(complexType);
                complexType.addAttribute("name", type.getName().getLocalPart());
                SchemaElement complexContent = new SchemaElement(SchemaConstants.QNAME_COMPLEX_CONTENT);
                complexType.addChild(complexContent);
                SchemaElement restriction = new SchemaElement(SchemaConstants.QNAME_RESTRICTION);
                complexContent.addChild(restriction);
                restriction.addAttribute("base", "soap-enc:Array");
                SchemaElement attribute = new SchemaElement(SchemaConstants.QNAME_ATTRIBUTE);
                restriction.addChild(attribute);
                attribute.addAttribute("ref", SOAPConstants.QNAME_ATTR_ARRAY_TYPE);
                schema.defineEntity(complexType, SchemaKinds.XSD_TYPE, type.getName());
                SchemaAttribute wsdlArrayTypeAttribute = new SchemaAttribute(WSDLConstants.QNAME_ATTR_ARRAY_TYPE.getLocalPart());
                wsdlArrayTypeAttribute.setNamespaceURI(WSDLConstants.QNAME_ATTR_ARRAY_TYPE.getNamespaceURI());
                String arrayTypeString = attribute.asString(SchemaConstants.QNAME_TYPE_URTYPE) + "[]";
                wsdlArrayTypeAttribute.setValue(arrayTypeString);
                attribute.addAttribute(wsdlArrayTypeAttribute);
            }

            public void visit(SOAPAnyType type) throws Exception {
            }

            public void visit(SOAPOrderedStructureType type) throws Exception {
                this.visit((SOAPStructureType)type);
            }

            public void visit(SOAPUnorderedStructureType type) throws Exception {
                this.visit((SOAPStructureType)type);
            }

            public void visit(RPCRequestOrderedStructureType type) throws Exception {
                Iterator iter = type.getMembers();
                while (iter.hasNext()) {
                    SOAPStructureMember member = (SOAPStructureMember)iter.next();
                    WSDLTypeGenerator.this.processType(member.getType());
                }
            }

            public void visit(RPCRequestUnorderedStructureType type) throws Exception {
                Iterator iter = type.getMembers();
                while (iter.hasNext()) {
                    SOAPStructureMember member = (SOAPStructureMember)iter.next();
                    WSDLTypeGenerator.this.processType(member.getType());
                }
            }

            public void visit(RPCResponseStructureType type) throws Exception {
                Iterator iter = type.getMembers();
                while (iter.hasNext()) {
                    SOAPStructureMember member = (SOAPStructureMember)iter.next();
                    WSDLTypeGenerator.this.processType(member.getType());
                }
            }

            protected void visit(SOAPStructureType type) throws Exception {
                SOAPStructureType parentType = type.getParentType();
                SchemaElement complexType = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
                schema.getContent().addChild(complexType);
                complexType.addAttribute("name", type.getName().getLocalPart());
                SchemaElement sequenceParent = complexType;
                if (parentType != null) {
                    SchemaElement complexContent = new SchemaElement(SchemaConstants.QNAME_COMPLEX_CONTENT);
                    complexType.addChild(complexContent);
                    SchemaElement extension = new SchemaElement(SchemaConstants.QNAME_EXTENSION);
                    complexContent.addChild(extension);
                    extension.addAttribute("base", parentType.getName());
                    sequenceParent = extension;
                }
                SchemaElement sequence = new SchemaElement(SchemaConstants.QNAME_SEQUENCE);
                sequenceParent.addChild(sequence);
                Iterator iter = type.getMembers();
                while (iter.hasNext()) {
                    SOAPStructureMember member = (SOAPStructureMember)iter.next();
                    if (member.isInherited() && type.getParentType() != null) continue;
                    SchemaElement element = new SchemaElement(SchemaConstants.QNAME_ELEMENT);
                    sequence.addChild(element);
                    element.addAttribute("name", member.getName().getLocalPart());
                    element.addAttribute("type", member.getType().getName());
                }
                schema.defineEntity(complexType, SchemaKinds.XSD_TYPE, type.getName());
                if (parentType != null) {
                    WSDLTypeGenerator.this.processType(type.getParentType());
                }
                Iterator iter2 = type.getMembers();
                while (iter2.hasNext()) {
                    SOAPStructureMember member = (SOAPStructureMember)iter2.next();
                    WSDLTypeGenerator.this.processType(member.getType());
                }
                Iterator subtypes = type.getSubtypes();
                if (subtypes != null) {
                    while (subtypes.hasNext()) {
                        WSDLTypeGenerator.this.processType((AbstractType)subtypes.next());
                    }
                }
            }
        });
    }

    private void processFault(Fault fault) throws Exception {
        AbstractType type = fault.getBlock().getType();
        AbstractType faultType = type instanceof SOAPStructureType ? type : (AbstractType)fault.getJavaException().getOwner();
        if (faultType.getName() == null || this.generatedTypes.contains(faultType.getName())) {
            return;
        }
        if ((type.getName().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") || type.getName().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/encoding/")) && fault.getAllFaults() == null) {
            return;
        }
        ImportedDocumentInfo docInfo = this.model.getImportedDocument(type.getName().getNamespaceURI());
        if (docInfo != null && docInfo.getType() == 1) {
            this.actuallyImportedDocuments.add(docInfo);
            return;
        }
        Schema schema = (Schema)this.nsSchemaMap.get(faultType.getName().getNamespaceURI());
        if (schema == null) {
            schema = new Schema(this.document);
            schema.setTargetNamespaceURI(type.getName().getNamespaceURI());
            SchemaElement schemaElement = new SchemaElement(SchemaConstants.QNAME_SCHEMA);
            schemaElement.addAttribute("targetNamespace", schema.getTargetNamespaceURI());
            schemaElement.addPrefix("", "http://www.w3.org/2001/XMLSchema");
            schemaElement.addPrefix("wsdl", "http://schemas.xmlsoap.org/wsdl/");
            schemaElement.addPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            schemaElement.addPrefix("soap-enc", "http://schemas.xmlsoap.org/soap/encoding/");
            schemaElement.addPrefix("tns", schema.getTargetNamespaceURI());
            schema.setContent(schemaElement);
            this.nsSchemaMap.put(type.getName().getNamespaceURI(), schema);
        }
        if (faultType.isLiteralType()) {
            throw new GeneratorException("generator.literalTypesNotSupported", new Object[]{type.getName().getLocalPart(), type.getName().getNamespaceURI()});
        }
        this.generatedTypes.add(faultType.getName());
        this.processFault(fault, schema);
    }

    private void processFault(Fault fault, Schema schema) throws Exception {
        SOAPStructureMember member;
        Iterator iter;
        Fault parentFault = fault.getParentFault();
        SOAPType type = (SOAPType)fault.getBlock().getType();
        SOAPType parentType = parentFault != null ? (SOAPType)parentFault.getBlock().getType() : null;
        SchemaElement complexType = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
        schema.getContent().addChild(complexType);
        boolean deserializeToDetail = false;
        if (type instanceof SOAPStructureType) {
            complexType.addAttribute("name", type.getName().getLocalPart());
            deserializeToDetail = SOAPObjectSerializerGenerator.deserializeToDetail((SOAPStructureType)type);
        } else {
            JavaException javaException = fault.getJavaException();
            complexType.addAttribute("name", ((SOAPType)javaException.getOwner()).getName().getLocalPart());
        }
        SchemaElement sequenceParent = complexType;
        if (parentType != null) {
            SchemaElement complexContent = new SchemaElement(SchemaConstants.QNAME_COMPLEX_CONTENT);
            complexType.addChild(complexContent);
            SchemaElement extension = new SchemaElement(SchemaConstants.QNAME_EXTENSION);
            complexContent.addChild(extension);
            if (parentType instanceof SOAPStructureType) {
                extension.addAttribute("base", parentType.getName());
            } else {
                JavaException javaException = parentFault.getJavaException();
                extension.addAttribute("base", ((SOAPType)javaException.getOwner()).getName());
            }
            sequenceParent = extension;
        }
        SchemaElement sequence = new SchemaElement(SchemaConstants.QNAME_SEQUENCE);
        sequenceParent.addChild(sequence);
        if (type instanceof SOAPStructureType) {
            iter = ((SOAPStructureType)type).getMembers();
            while (iter.hasNext()) {
                member = (SOAPStructureMember)iter.next();
                if (member.isInherited() && parentFault != null) continue;
                SchemaElement element = new SchemaElement(SchemaConstants.QNAME_ELEMENT);
                sequence.addChild(element);
                element.addAttribute("name", member.getName().getLocalPart());
                element.addAttribute("type", member.getType().getName());
            }
            schema.defineEntity(complexType, SchemaKinds.XSD_TYPE, type.getName());
        } else {
            JavaException javaException = fault.getJavaException();
            SOAPStructureType soapStruct = (SOAPStructureType)javaException.getOwner();
            Iterator iter2 = soapStruct.getMembers();
            SOAPStructureMember member2 = (SOAPStructureMember)iter2.next();
            if (!member2.isInherited() || fault.getParentFault() == null) {
                SchemaElement element = new SchemaElement(SchemaConstants.QNAME_ELEMENT);
                sequence.addChild(element);
                element.addAttribute("name", member2.getName().getLocalPart());
                element.addAttribute("type", member2.getType().getName());
            }
            schema.defineEntity(complexType, SchemaKinds.XSD_TYPE, ((SOAPType)javaException.getOwner()).getName());
        }
        if (parentType != null) {
            this.processFault(parentFault);
        }
        if (type instanceof SOAPStructureType) {
            iter = ((SOAPStructureType)type).getMembers();
            while (iter.hasNext()) {
                member = (SOAPStructureMember)iter.next();
                this.processType(member.getType());
            }
            Iterator subtypes = ((SOAPStructureType)type).getSubtypes();
            if (subtypes != null) {
                while (subtypes.hasNext()) {
                    this.processType((AbstractType)subtypes.next());
                }
            }
        }
    }
}

