/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.rmi;

import com.sun.xml.rpc.processor.config.ImportedDocumentInfo;
import com.sun.xml.rpc.processor.config.NamespaceMappingInfo;
import com.sun.xml.rpc.processor.config.NamespaceMappingRegistryInfo;
import com.sun.xml.rpc.processor.config.RmiInterfaceInfo;
import com.sun.xml.rpc.processor.config.RmiModelInfo;
import com.sun.xml.rpc.processor.config.TypeMappingRegistryInfo;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Request;
import com.sun.xml.rpc.processor.model.Response;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.processor.model.java.JavaParameter;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCRequestOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.modeler.Modeler;
import com.sun.xml.rpc.processor.modeler.ModelerException;
import com.sun.xml.rpc.processor.modeler.rmi.ExceptionModeler;
import com.sun.xml.rpc.processor.modeler.rmi.RmiConstants;
import com.sun.xml.rpc.processor.modeler.rmi.RmiType;
import com.sun.xml.rpc.processor.modeler.rmi.RmiTypeModeler;
import com.sun.xml.rpc.processor.modeler.rmi.RmiUtils;
import com.sun.xml.rpc.processor.modeler.rmi.SOAPSimpleTypeCreator;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.processor.util.StringUtils;
import com.sun.xml.rpc.util.ClassNameInfo;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class RmiModeler
implements RmiConstants,
Modeler {
    private final String modelName;
    private final String typeUri;
    private final String wsdlUri;
    private final RmiModelInfo modelInfo;
    private ProcessorEnvironment env;
    private Map structMap;
    private TypeMappingRegistryInfo typeMappingRegistry;
    private Map messageMap;
    private NamespaceMappingRegistryInfo namespaceMappingRegistry;
    private Model model;
    private static final Set excludedInterfaces = new HashSet();
    private static final Class remoteExceptionClass = class$java$rmi$RemoteException == null ? (class$java$rmi$RemoteException = RmiModeler.class$("java.rmi.RemoteException")) : class$java$rmi$RemoteException;
    private static final Class defHolder = class$javax$xml$rpc$holders$Holder == null ? (class$javax$xml$rpc$holders$Holder = RmiModeler.class$("javax.xml.rpc.holders.Holder")) : class$javax$xml$rpc$holders$Holder;
    private static final Class defRemote = class$java$rmi$Remote == null ? (class$java$rmi$Remote = RmiModeler.class$("java.rmi.Remote")) : class$java$rmi$Remote;
    private RmiTypeModeler rmiTypeModeler;
    private ExceptionModeler exceptionModeler;
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$javax$xml$rpc$holders$Holder;
    static /* synthetic */ Class class$java$rmi$Remote;

    public RmiModeler(RmiModelInfo rmiModelInfo) {
        this.modelInfo = rmiModelInfo;
        this.modelName = rmiModelInfo.getName();
        this.typeUri = rmiModelInfo.getTypeNamespaceURI();
        this.wsdlUri = rmiModelInfo.getTargetNamespaceURI();
        this.env = rmiModelInfo.getConfiguration().getEnvironment();
        this.typeMappingRegistry = rmiModelInfo.getTypeMappingRegistry();
        this.namespaceMappingRegistry = rmiModelInfo.getNamespaceMappingRegistry();
        this.rmiTypeModeler = new RmiTypeModeler(this, this.env);
        this.exceptionModeler = new ExceptionModeler(this);
    }

    public ProcessorEnvironment getProcessorEnvironment() {
        return this.env;
    }

    public TypeMappingRegistryInfo getTypeMappingRegistryInfo() {
        return this.typeMappingRegistry;
    }

    public NamespaceMappingRegistryInfo getNamespaceMappingRegistryInfo() {
        return this.namespaceMappingRegistry;
    }

    public Class getDefHolder() {
        return defHolder;
    }

    public Model getModel() {
        return this.model;
    }

    public SOAPType modelTypeSOAP(String typeUri, RmiType type) {
        return this.rmiTypeModeler.modelTypeSOAP(typeUri, type);
    }

    public SOAPSimpleTypeCreator getSOAPTypes() {
        return this.rmiTypeModeler.getSOAPTypes();
    }

    protected void addFaultParent(Fault fault) {
        try {
            Class javaClass = RmiUtils.getClassForName(fault.getJavaException().getRealName(), this.env.getClassLoader());
            javaClass = javaClass.getSuperclass();
            if (javaClass != null && !javaClass.getName().equals(RmiConstants.EXCEPTION_CLASSNAME)) {
                Fault parentFault = this.exceptionModeler.modelException(this.typeUri, this.wsdlUri, javaClass);
                parentFault.addSubfault(fault);
                parentFault.getJavaException().addSubclass(fault.getJavaException());
                Block block = parentFault.getBlock();
                block.setType((AbstractType)parentFault.getJavaException().getOwner());
                this.addFaultParent(parentFault);
                RmiModeler.markInheritedMembers((SOAPStructureType)fault.getJavaException().getOwner(), (SOAPStructureType)parentFault.getJavaException().getOwner());
            }
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("rmimodeler.nestedRmiModelerError", new LocalizableExceptionAdapter(e));
        }
    }

    public static void markInheritedMembers(SOAPStructureType type1, SOAPStructureType type2) {
        Iterator members1 = type1.getMembers();
        block0: while (members1.hasNext()) {
            Iterator members2 = type2.getMembers();
            SOAPStructureMember member1 = (SOAPStructureMember)members1.next();
            while (members2.hasNext()) {
                SOAPStructureMember member2 = (SOAPStructureMember)members2.next();
                if (!RmiModeler.membersMatch(member1, member2)) continue;
                member1.setInherited(true);
                member1.getJavaStructureMember().setInherited(true);
                continue block0;
            }
        }
    }

    public static boolean membersMatch(SOAPStructureMember member1, SOAPStructureMember member2) {
        return member1.getName().equals(member2.getName()) && member1.getType().equals(member2.getType());
    }

    public Model buildModel() {
        this.log("creating model: " + this.modelName);
        this.model = new Model(new QName(null, this.modelName));
        this.model.setProperty("com.sun.xml.rpc.processor.model.ModelerName", this.getClass().getName());
        this.model.setTargetNamespaceURI(this.wsdlUri);
        try {
            if (this.typeMappingRegistry != null) {
                Iterator iter = this.typeMappingRegistry.getImportedDocuments();
                while (iter.hasNext()) {
                    this.model.addImportedDocument((ImportedDocumentInfo)iter.next());
                }
                Iterator iter2 = this.typeMappingRegistry.getExtraTypeNames();
                while (iter2.hasNext()) {
                    RmiType type = RmiType.getRmiType(RmiUtils.getClassForName((String)iter2.next(), this.env.getClassLoader()));
                    if (RmiModeler.isException(this.env, type)) {
                        Fault fault = this.exceptionModeler.modelException(this.typeUri, this.wsdlUri, type.getTypeClass(this.env.getClassLoader()));
                        this.addFaultParent(fault);
                        continue;
                    }
                    SOAPType extraType = this.rmiTypeModeler.modelTypeSOAP(this.typeUri, type);
                    this.model.addExtraType(extraType);
                }
            }
            this.structMap = new HashMap();
            String javaServiceName = StringUtils.capitalize(this.modelInfo.getName());
            this.log("creating service: " + javaServiceName);
            String serviceInterface = this.modelInfo.getJavaPackageName() != null && !this.modelInfo.getJavaPackageName().equals("") ? this.modelInfo.getJavaPackageName() + "." + javaServiceName : javaServiceName;
            Service service = new Service(new QName(this.wsdlUri, javaServiceName), new JavaInterface(serviceInterface, serviceInterface + "Impl"));
            this.model.addService(service);
            Iterator interfaces = this.modelInfo.getInterfaces();
            while (interfaces.hasNext()) {
                RmiInterfaceInfo interfaceInfo = (RmiInterfaceInfo)interfaces.next();
                service.addPort(this.modelPort(interfaceInfo));
            }
            this.rmiTypeModeler.modelSubclasses(this.typeUri);
            this.messageMap = null;
        }
        catch (ModelerException e) {
            throw e;
        }
        catch (JAXRPCExceptionBase e) {
            throw new ModelerException(e);
        }
        catch (Exception e) {
            throw new ModelerException(new LocalizableExceptionAdapter(e));
        }
        this.structMap = null;
        return this.model;
    }

    public static boolean isException(ProcessorEnvironment env, RmiType type) {
        try {
            if (type.getTypeCode() != 10) {
                return false;
            }
            Class typeClass = type.getTypeClass(env.getClassLoader());
            while (typeClass != null) {
                if (typeClass.getName().equals(RmiConstants.EXCEPTION_CLASSNAME)) {
                    return true;
                }
                typeClass = typeClass.getSuperclass();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private Port modelPort(RmiInterfaceInfo interfaceInfo) {
        Port port = null;
        try {
            String implClassName = RmiUtils.getRealName(interfaceInfo.getName(), this.env.getClassLoader());
            Class def = RmiUtils.getClassForName(implClassName, this.env.getClassLoader());
            this.validateEndpointClass(def);
            port = this.processInterface(def, implClassName, interfaceInfo);
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("rmimodeler.nestedRmiModelerError", new LocalizableExceptionAdapter(e));
        }
        return port;
    }

    private void validateEndpointClass(Class endpointClass) throws ModelerException {
        if (!endpointClass.isInterface()) {
            throw new ModelerException("rmimodeler.service.endpoint.must.be.interface", endpointClass.getName());
        }
        if (!defRemote.isAssignableFrom(endpointClass)) {
            throw new ModelerException("rmimodeler.must.implement.remote", endpointClass.getName());
        }
    }

    private Port processInterface(Class endpointClass, String intfName, RmiInterfaceInfo interfaceInfo) {
        this.messageMap = new HashMap();
        String servant = interfaceInfo.getServantName();
        this.log("creating port: " + ClassNameInfo.replaceInnerClassSym(endpointClass.getName()));
        String portName = ClassNameInfo.getName(endpointClass.getName().replace('$', '_'));
        String packageName = endpointClass.getPackage().getName();
        String namespace = this.wsdlUri;
        Port port = new Port(new QName(namespace, portName));
        JavaInterface javaInterface = new JavaInterface(intfName, servant);
        port.setJavaInterface(javaInterface);
        Class<?>[] remoteInterfaces = endpointClass.getInterfaces();
        int i = 0;
        while (i < remoteInterfaces.length) {
            String interfaceName = this.env.getNames().removeCharacter(32, remoteInterfaces[i].getName());
            if (!interfaceName.equals(javaInterface.getName())) {
                javaInterface.addInterface(interfaceName);
            }
            ++i;
        }
        Method[] methods = endpointClass.getMethods();
        int i2 = 0;
        while (i2 < methods.length) {
            if (!this.verifyRemoteMethod(methods[i2])) {
                throw new ModelerException("rmimodeler.must.throw.remoteexception", new Object[]{endpointClass.getName(), methods[i2].getName()});
            }
            port.addOperation(this.processMethod(interfaceInfo, endpointClass, methods[i2], namespace));
            ++i2;
        }
        port.setClientHandlerChainInfo(interfaceInfo.getClientHandlerChainInfo());
        port.setServerHandlerChainInfo(interfaceInfo.getServerHandlerChainInfo());
        port.setProperty("com.sun.xml.rpc.processor.model.WSDLPortName", this.getWSDLPortName(portName));
        port.setProperty("com.sun.xml.rpc.processor.model.WSDLPortTypeName", this.getWSDLPortTypeName(portName));
        port.setProperty("com.sun.xml.rpc.processor.model.WSDLBindingName", this.getWSDLBindingName(portName));
        this.messageMap = null;
        return port;
    }

    private boolean verifyRemoteMethod(Method method) {
        Class<?>[] exceptions = method.getExceptionTypes();
        boolean hasRemoteException = false;
        int i = 0;
        while (i < exceptions.length) {
            if ((class$java$rmi$RemoteException == null ? RmiModeler.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException).isAssignableFrom(exceptions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Operation processMethod(RmiInterfaceInfo interfaceInfo, Class endpointClass, Method method, String namespaceURI) {
        JavaStructureMember javaMember;
        SOAPStructureMember member;
        String portName = ClassNameInfo.getName(endpointClass.getName());
        portName = portName.replace('$', '_');
        RmiType returnType = RmiType.getRmiType(method.getReturnType());
        RmiType[] paramTypes = this.getParameterTypes(method);
        String[] paramNames = this.nameParameters(paramTypes);
        Class<?>[] exceptions = method.getExceptionTypes();
        String messageName = method.getName();
        String operationName = this.getOperationName(messageName);
        String methodName = method.getName().toString();
        this.log("creating operation: " + methodName);
        Operation operation = new Operation(new QName(namespaceURI, operationName));
        operation.setSOAPAction(this.getSOAPAction(interfaceInfo, operationName));
        JavaMethod javaMethod = new JavaMethod(methodName);
        operation.setJavaMethod(javaMethod);
        String packageName = endpointClass.getPackage().getName();
        String typeNamespace = this.getNamespaceURI(packageName);
        if (typeNamespace == null) {
            typeNamespace = this.typeUri;
        }
        if (packageName.length() > 0) {
            packageName = packageName + ".";
        }
        RPCResponseStructureType responseStruct = new RPCResponseStructureType(new QName(typeNamespace, StringUtils.capitalize(this.env.getNames().getResponseName(operationName))));
        JavaStructureType javaStruct = new JavaStructureType(this.getStructName(packageName + portName + "_" + StringUtils.capitalize(methodName) + "_ResponseStruct"), false, responseStruct);
        responseStruct.setJavaType(javaStruct);
        Response response = new Response();
        JavaStructureType javaRespStructure = (JavaStructureType)responseStruct.getJavaType();
        Block responseBlock = new Block(new QName(namespaceURI, this.env.getNames().getResponseName(operationName)));
        SOAPType resultType = this.rmiTypeModeler.modelTypeSOAP(this.typeUri, returnType);
        if (returnType.getTypeCode() != 11) {
            member = new SOAPStructureMember(new QName(null, "result"), resultType);
            javaMember = new JavaStructureMember(member.getName().getLocalPart(), member.getType().getJavaType(), member, false);
            javaMember.setReadMethod(this.env.getNames().getJavaMemberReadMethod(javaMember));
            javaMember.setWriteMethod(this.env.getNames().getJavaMemberWriteMethod(javaMember));
            member.setJavaStructureMember(javaMember);
            javaRespStructure.add(javaMember);
            responseStruct.add(member);
        }
        response.addBodyBlock(responseBlock);
        Parameter resultParam = new Parameter("result");
        resultParam.setEmbedded(true);
        resultParam.setType(resultType);
        resultParam.setBlock(responseBlock);
        responseBlock.setType(responseStruct);
        JavaParameter javaParameter = new JavaParameter(null, resultType.getJavaType(), resultParam);
        javaMethod.setReturnType(resultType.getJavaType());
        resultParam.setJavaParameter(javaParameter);
        response.addParameter(resultParam);
        response.setProperty("com.sun.xml.rpc.processor.model.WSDLMessageName", this.getWSDLOutputMessageName(portName + "_" + operationName));
        operation.setResponse(response);
        RPCRequestOrderedStructureType paramStruct = new RPCRequestOrderedStructureType(new QName(typeNamespace, StringUtils.capitalize(operationName)));
        javaStruct = new JavaStructureType(this.getStructName(packageName + portName + "_" + paramStruct.getName().getLocalPart() + "_RequestStruct"), false, paramStruct);
        paramStruct.setJavaType(javaStruct);
        Request request = new Request();
        JavaStructureType javaStructure = (JavaStructureType)paramStruct.getJavaType();
        Block block = new Block(new QName(namespaceURI, operationName));
        int i = 0;
        while (i < paramTypes.length) {
            QName typeName = new QName(null, paramNames[i]);
            SOAPType memberType = this.rmiTypeModeler.modelTypeSOAP(this.typeUri, paramTypes[i]);
            boolean isHolder = memberType.getJavaType().isHolder();
            member = new SOAPStructureMember(typeName, memberType);
            javaMember = new JavaStructureMember(member.getName().getLocalPart(), member.getType().getJavaType(), member, false);
            javaMember.setReadMethod(this.env.getNames().getJavaMemberReadMethod(javaMember));
            javaMember.setWriteMethod(this.env.getNames().getJavaMemberWriteMethod(javaMember));
            member.setJavaStructureMember(javaMember);
            javaStructure.add(javaMember);
            paramStruct.add(member);
            Parameter parameter = new Parameter(paramNames[i]);
            if (isHolder) {
                javaRespStructure.add(javaMember);
                responseStruct.add(member);
                Parameter responseParam = new Parameter(paramNames[i]);
                responseParam.setEmbedded(true);
                javaParameter = new JavaParameter(paramNames[i], member.getType().getJavaType(), responseParam, true);
                responseParam.setJavaParameter(javaParameter);
                responseParam.setType(member.getType());
                responseParam.setBlock(responseBlock);
                parameter.setLinkedParameter(responseParam);
                responseParam.setLinkedParameter(parameter);
                response.addParameter(responseParam);
            }
            parameter.setEmbedded(true);
            javaParameter = new JavaParameter(paramNames[i], member.getType().getJavaType(), parameter, isHolder);
            parameter.setJavaParameter(javaParameter);
            parameter.setType(member.getType());
            parameter.setBlock(block);
            javaMethod.addParameter(javaParameter);
            request.addParameter(parameter);
            ++i;
        }
        block.setType(paramStruct);
        request.addBodyBlock(block);
        request.setProperty("com.sun.xml.rpc.processor.model.WSDLMessageName", this.getWSDLInputMessageName(portName + "_" + operationName));
        operation.setRequest(request);
        if (exceptions.length > 0) {
            int i2 = 0;
            while (i2 < exceptions.length) {
                if (!RmiModeler.isRemoteException(this.env, exceptions[i2].getName().toString())) {
                    javaMethod.addException(exceptions[i2].getName().toString());
                    if (!exceptions[i2].getName().toString().equals(RmiConstants.EXCEPTION_CLASSNAME)) {
                        Fault fault = this.exceptionModeler.modelException(this.typeUri, this.wsdlUri, exceptions[i2]);
                        response.addFaultBlock(fault.getBlock());
                        fault.setProperty("com.sun.xml.rpc.processor.model.WSDLMessageName", this.getWSDLFaultMessageName(fault.getName()));
                        operation.addFault(fault);
                        this.addFaultParent(fault);
                    }
                }
                ++i2;
            }
        }
        return operation;
    }

    private RmiType[] getParameterTypes(Method method) {
        Class<?>[] args = method.getParameterTypes();
        RmiType[] types = new RmiType[args.length];
        int i = 0;
        while (i < args.length) {
            types[i] = RmiType.getRmiType(args[i]);
            ++i;
        }
        return types;
    }

    private String getStructName(String name) {
        String tmp = name.toLowerCase();
        Integer count = (Integer)this.structMap.get(tmp);
        if (count != null) {
            count = new Integer(count + 1);
            name = name + count;
        } else {
            count = new Integer(0);
        }
        this.structMap.put(tmp, count);
        return name;
    }

    public static boolean isRemoteException(ProcessorEnvironment env, String exceptionName) {
        try {
            Class exceptionClass = RmiUtils.getClassForName(exceptionName, env.getClassLoader());
            return remoteExceptionClass.isAssignableFrom(exceptionClass);
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("rmimodeler.class.not.found", exceptionName);
        }
    }

    private String[] nameParameters(RmiType[] types) {
        String[] names = new String[types.length];
        int i = 0;
        while (i < names.length) {
            names[i] = this.generateNameFromType(types[i]) + "_" + (i + 1);
            ++i;
        }
        return names;
    }

    private String generateNameFromType(RmiType type) {
        int typeCode = type.getTypeCode();
        switch (typeCode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return type.toString();
            }
            case 9: {
                return "arrayOf" + this.generateNameFromType(type.getElementType());
            }
            case 10: {
                RmiType holderValueType = RmiTypeModeler.getHolderValueType(this.env, defHolder, type);
                if (holderValueType != null) {
                    return this.generateNameFromType(holderValueType);
                }
                String tmp2 = ClassNameInfo.getName(type.getClassName());
                String tmp = ClassNameInfo.getName(type.getClassName());
                return ClassNameInfo.replaceInnerClassSym(tmp);
            }
        }
        throw new Error("unexpected type code: " + typeCode);
    }

    public String getSOAPAction(RmiInterfaceInfo interfaceInfo, String operationName) {
        if (interfaceInfo.getSOAPAction() != null) {
            return interfaceInfo.getSOAPAction();
        }
        if (interfaceInfo.getSOAPActionBase() != null) {
            return interfaceInfo.getSOAPActionBase() + operationName;
        }
        return "";
    }

    public String getOperationName(String messageName) {
        String operationName = null;
        Integer cnt = (Integer)this.messageMap.get(messageName);
        if (cnt == null) {
            cnt = new Integer(0);
            operationName = messageName;
        }
        this.messageMap.put(messageName, new Integer(cnt + 1));
        if (operationName == null) {
            operationName = messageName + (cnt + 1);
        }
        return operationName;
    }

    public String getNamespaceURI(String javaPackageName) {
        NamespaceMappingInfo i;
        if (this.namespaceMappingRegistry != null && (i = this.namespaceMappingRegistry.getNamespaceMappingInfo(javaPackageName)) != null) {
            return i.getNamespaceURI();
        }
        return null;
    }

    private void log(String msg) {
        if (this.env.verbose()) {
            System.out.println("[" + msg + "]");
        }
    }

    private QName getWSDLPortName(String portName) {
        return new QName(this.wsdlUri, portName + "Port");
    }

    private QName getWSDLBindingName(String portName) {
        return new QName(this.wsdlUri, portName + "Binding");
    }

    private QName getWSDLPortTypeName(String portName) {
        return new QName(this.wsdlUri, portName);
    }

    private QName getWSDLInputMessageName(String operationName) {
        return new QName(this.wsdlUri, operationName);
    }

    private QName getWSDLOutputMessageName(String operationName) {
        return new QName(this.wsdlUri, operationName + "Response");
    }

    private QName getWSDLFaultMessageName(String faultName) {
        return new QName(this.wsdlUri, faultName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        excludedInterfaces.add(RmiConstants.SERIALIZABLE_CLASSNAME);
        excludedInterfaces.add(RmiConstants.HOLDER_CLASSNAME);
        excludedInterfaces.add(RmiConstants.REMOTE_CLASSNAME);
    }
}

