/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.wsdl;

import com.sun.xml.rpc.encoding.InternalEncodingConstants;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.sun.xml.rpc.encoding.simpletype.XSDByteEncoder;
import com.sun.xml.rpc.encoding.simpletype.XSDDecimalEncoder;
import com.sun.xml.rpc.encoding.simpletype.XSDDoubleEncoder;
import com.sun.xml.rpc.encoding.simpletype.XSDFloatEncoder;
import com.sun.xml.rpc.encoding.simpletype.XSDIntEncoder;
import com.sun.xml.rpc.encoding.simpletype.XSDIntegerEncoder;
import com.sun.xml.rpc.encoding.simpletype.XSDLongEncoder;
import com.sun.xml.rpc.encoding.simpletype.XSDShortEncoder;
import com.sun.xml.rpc.encoding.simpletype.XSDStringEncoder;
import com.sun.xml.rpc.processor.config.NamespaceMappingInfo;
import com.sun.xml.rpc.processor.config.TypeMappingInfo;
import com.sun.xml.rpc.processor.config.WSDLModelInfo;
import com.sun.xml.rpc.processor.generator.writer.SimpleTypeSerializerWriter;
import com.sun.xml.rpc.processor.model.ModelException;
import com.sun.xml.rpc.processor.model.java.JavaArrayType;
import com.sun.xml.rpc.processor.model.java.JavaCustomType;
import com.sun.xml.rpc.processor.model.java.JavaEnumerationEntry;
import com.sun.xml.rpc.processor.model.java.JavaEnumerationType;
import com.sun.xml.rpc.processor.model.java.JavaSimpleType;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralAttributeMember;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.sun.xml.rpc.processor.model.literal.LiteralStructuredType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.model.soap.SOAPUnorderedStructureType;
import com.sun.xml.rpc.processor.modeler.JavaSimpleTypeCreator;
import com.sun.xml.rpc.processor.schema.AttributeDeclarationComponent;
import com.sun.xml.rpc.processor.schema.AttributeUseComponent;
import com.sun.xml.rpc.processor.schema.ComplexTypeDefinitionComponent;
import com.sun.xml.rpc.processor.schema.ElementDeclarationComponent;
import com.sun.xml.rpc.processor.schema.EnumerationFacet;
import com.sun.xml.rpc.processor.schema.Facet;
import com.sun.xml.rpc.processor.schema.InternalSchema;
import com.sun.xml.rpc.processor.schema.InternalSchemaBuilder;
import com.sun.xml.rpc.processor.schema.ModelGroupComponent;
import com.sun.xml.rpc.processor.schema.ParticleComponent;
import com.sun.xml.rpc.processor.schema.SimpleTypeDefinitionComponent;
import com.sun.xml.rpc.processor.schema.Symbol;
import com.sun.xml.rpc.processor.schema.TypeDefinitionComponent;
import com.sun.xml.rpc.processor.schema.UnimplementedFeatureException;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.wsdl.document.WSDLConstants;
import com.sun.xml.rpc.wsdl.document.schema.BuiltInTypes;
import com.sun.xml.rpc.wsdl.document.schema.SchemaAttribute;
import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;
import com.sun.xml.rpc.wsdl.document.schema.SchemaElement;
import com.sun.xml.rpc.wsdl.document.soap.SOAPConstants;
import com.sun.xml.rpc.wsdl.framework.AbstractDocument;
import com.sun.xml.rpc.wsdl.framework.ValidationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;

public class SchemaAnalyzer {
    private InternalSchema _schema;
    private WSDLModelInfo _modelInfo;
    private ProcessorEnvironment _env;
    private Set _typesBeingResolved;
    private Set _namePool;
    private Set _conflictingClassNames;
    private Map _componentToSOAPTypeMap;
    private Map _componentToLiteralTypeMap;
    private Map _typeNameToCustomSOAPTypeMap;
    private Map _nillableSimpleTypeComponentToSOAPTypeMap;
    private Map _nillableSimpleTypeComponentToLiteralTypeMap;
    private boolean _noDataBinding;
    private boolean _useDataHandlerOnly;
    private int _nextUniqueID;
    private JavaSimpleTypeCreator javaTypes;
    private Map _builtinSchemaTypeToJavaTypeMap;
    private Map _builtinSchemaTypeToJavaWrapperTypeMap;
    private Map _simpleTypeEncoderMap;

    public SchemaAnalyzer(AbstractDocument document, WSDLModelInfo modelInfo, Properties options, Set conflictingClassNames, JavaSimpleTypeCreator javaTypes) {
        this._schema = new InternalSchemaBuilder(document, options).getSchema();
        this._modelInfo = modelInfo;
        this._env = modelInfo.getParent().getEnvironment();
        this._conflictingClassNames = conflictingClassNames;
        this._typesBeingResolved = new HashSet();
        this._namePool = new HashSet();
        this._componentToSOAPTypeMap = new HashMap();
        this._componentToLiteralTypeMap = new HashMap();
        this._typeNameToCustomSOAPTypeMap = new HashMap();
        this._nillableSimpleTypeComponentToSOAPTypeMap = new HashMap();
        this._nillableSimpleTypeComponentToLiteralTypeMap = new HashMap();
        this._nextUniqueID = 1;
        this._noDataBinding = Boolean.valueOf(options.getProperty("noDataBinding"));
        this._useDataHandlerOnly = Boolean.valueOf(options.getProperty("useDataHandlerOnly"));
        this.javaTypes = javaTypes;
        this.initializeMaps();
    }

    public SOAPType schemaTypeToSOAPType(QName typeName) {
        try {
            TypeDefinitionComponent component = this._schema.findTypeDefinition(typeName);
            return this.schemaTypeToSOAPType(component);
        }
        catch (UnimplementedFeatureException e) {
            this.failUnsupported("U001", typeName);
            return null;
        }
    }

    public LiteralType schemaTypeToLiteralType(QName typeName) {
        try {
            TypeDefinitionComponent component = this._schema.findTypeDefinition(typeName);
            return this.schemaTypeToLiteralType(component, typeName);
        }
        catch (UnimplementedFeatureException e) {
            LiteralFragmentType literalType = new LiteralFragmentType();
            literalType.setName(typeName);
            literalType.setSchemaTypeRef(typeName);
            literalType.setJavaType(this.javaTypes.SOAPELEMENT_JAVATYPE);
            return literalType;
        }
    }

    public LiteralType schemaElementTypeToLiteralType(QName elementName) {
        try {
            ElementDeclarationComponent component = this._schema.findElementDeclaration(elementName);
            LiteralType literalType = this.schemaTypeToLiteralType(component.getTypeDefinition(), elementName);
            if (literalType.getName() == null) {
                literalType.setName(this.getUniqueTypeNameForElement(elementName));
            }
            return literalType;
        }
        catch (UnimplementedFeatureException e) {
            LiteralFragmentType literalType = new LiteralFragmentType();
            literalType.setName(elementName);
            literalType.setJavaType(this.javaTypes.SOAPELEMENT_JAVATYPE);
            return literalType;
        }
    }

    protected SOAPType schemaTypeToSOAPType(TypeDefinitionComponent component) {
        SOAPType result = (SOAPType)this._componentToSOAPTypeMap.get(component);
        if (result == null) {
            try {
                if (component.isSimple()) {
                    result = this.simpleSchemaTypeToSOAPType((SimpleTypeDefinitionComponent)component);
                } else if (component.isComplex()) {
                    result = this.complexSchemaTypeToSOAPType((ComplexTypeDefinitionComponent)component);
                } else {
                    throw new IllegalArgumentException();
                }
                this._componentToSOAPTypeMap.put(component, result);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
        return result;
    }

    protected SOAPType nillableSchemaTypeToSOAPType(TypeDefinitionComponent component) {
        JavaSimpleType javaType = (JavaSimpleType)this._builtinSchemaTypeToJavaWrapperTypeMap.get(component.getName());
        if (javaType == null) {
            return this.schemaTypeToSOAPType(component);
        }
        SOAPSimpleType result = (SOAPSimpleType)this._nillableSimpleTypeComponentToSOAPTypeMap.get(component);
        if (result != null) {
            return result;
        }
        result = new SOAPSimpleType(component.getName(), javaType);
        result.setSchemaTypeRef(component.getName());
        this.setReferenceable(result);
        this._nillableSimpleTypeComponentToSOAPTypeMap.put(component, result);
        return result;
    }

    protected SOAPType simpleSchemaTypeToSOAPType(SimpleTypeDefinitionComponent component) {
        if (component.getBaseTypeDefinition() == this._schema.getSimpleUrType()) {
            if (component.getVarietyTag() == 1) {
                String nsURI = component.getName().getNamespaceURI();
                if (nsURI != null && (nsURI.equals("http://www.w3.org/2001/XMLSchema") || nsURI.equals("http://schemas.xmlsoap.org/soap/encoding/"))) {
                    if (!component.facets().hasNext()) {
                        if (component.getName().equals(SchemaConstants.QNAME_TYPE_URTYPE)) {
                            SOAPAnyType anyType = new SOAPAnyType(component.getName());
                            JavaSimpleType javaType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(component.getName());
                            if (javaType == null) {
                                this.failUnsupported("U002", component.getName());
                            }
                            anyType.setJavaType(javaType);
                            return anyType;
                        }
                        SOAPSimpleType simpleType = new SOAPSimpleType(component.getName());
                        simpleType.setSchemaTypeRef(component.getName());
                        JavaSimpleType javaType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(component.getName());
                        if (javaType == null) {
                            this.failUnsupported("U002", component.getName());
                        }
                        simpleType.setJavaType(javaType);
                        this.setReferenceable(simpleType);
                        return simpleType;
                    }
                    this.failUnsupported("U003", component.getName());
                } else {
                    this.failUnsupported("U004", component.getName());
                }
            } else {
                this.failUnsupported("U005", component.getName());
            }
        } else {
            JavaSimpleType javaType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(component.getName());
            if (javaType != null) {
                SOAPSimpleType simpleType = new SOAPSimpleType(component.getName());
                simpleType.setSchemaTypeRef(component.getName());
                simpleType.setJavaType(javaType);
                this.setReferenceable(simpleType);
                return simpleType;
            }
            if (component.getVarietyTag() == 1) {
                Iterator iter = component.facets();
                if (iter.hasNext()) {
                    Facet facet = (Facet)iter.next();
                    if (iter.hasNext()) {
                        this.failUnsupported("U006", component.getName());
                    } else {
                        if (facet instanceof EnumerationFacet) {
                            return this.enumerationToSOAPType(component, (EnumerationFacet)facet);
                        }
                        this.failUnsupported("U008", component.getName());
                    }
                } else {
                    this.failUnsupported("U009", component.getName());
                }
            } else {
                this.failUnsupported("U010", component.getName());
            }
        }
        return null;
    }

    protected SOAPType enumerationToSOAPType(SimpleTypeDefinitionComponent component, EnumerationFacet facet) {
        SimpleTypeDefinitionComponent baseType = component.getBaseTypeDefinition();
        SimpleTypeEncoder encoder = (SimpleTypeEncoder)this._simpleTypeEncoderMap.get(baseType.getName());
        if (encoder != null) {
            JavaType javaEntryType = (JavaType)this._builtinSchemaTypeToJavaTypeMap.get(baseType.getName());
            JavaEnumerationType javaEnumType = new JavaEnumerationType(this.makePackageQualified(this._env.getNames().validJavaClassName(component.getName().getLocalPart()), component.getName()), javaEntryType, false);
            this.resolveNamingConflictsFor(javaEnumType);
            SOAPEnumerationType soapEnumType = new SOAPEnumerationType(component.getName(), this.schemaTypeToSOAPType(baseType), javaEnumType);
            boolean mustRename = false;
            Iterator values = facet.values();
            while (values.hasNext()) {
                String value = (String)values.next();
                try {
                    JavaEnumerationEntry entry = new JavaEnumerationEntry(value, encoder.stringToObject(value, null), value);
                    if (!mustRename && this.isInvalidEnumerationLabel(value)) {
                        mustRename = true;
                    }
                    javaEnumType.add(entry);
                }
                catch (Exception e) {
                    this.fail("model.schema.invalidLiteralInEnumeration", value, component.getName());
                }
            }
            if (mustRename) {
                int index = 1;
                Iterator iter = javaEnumType.getEntries();
                while (iter.hasNext()) {
                    JavaEnumerationEntry entry = (JavaEnumerationEntry)iter.next();
                    entry.setName("value" + Integer.toString(index));
                    ++index;
                }
            }
            return soapEnumType;
        }
        this.failUnsupported("U007", component.getName());
        return null;
    }

    protected SOAPType complexSchemaTypeToSOAPType(ComplexTypeDefinitionComponent component) {
        JavaSimpleType javaType;
        SOAPCustomType userDefinedType = this.getCustomTypeFor(component);
        if (userDefinedType != null) {
            return userDefinedType;
        }
        if (component == this._schema.getUrType()) {
            if (component.getName().equals(SchemaConstants.QNAME_TYPE_URTYPE)) {
                SOAPAnyType anyType = new SOAPAnyType(component.getName());
                JavaSimpleType javaType2 = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(component.getName());
                if (javaType2 == null) {
                    this.failUnsupported("U002", component.getName());
                }
                anyType.setJavaType(javaType2);
                return anyType;
            }
            SOAPSimpleType simpleType = new SOAPSimpleType(component.getName());
            simpleType.setSchemaTypeRef(component.getName());
            JavaSimpleType javaType3 = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(component.getName());
            if (javaType3 == null) {
                this.failUnsupported("U013", component.getName());
            }
            simpleType.setJavaType(javaType3);
            this.setReferenceable(simpleType);
            return simpleType;
        }
        if (component.getName().equals(SOAPConstants.QNAME_TYPE_ARRAY)) {
            SOAPType anyType = this.schemaTypeToSOAPType(SchemaConstants.QNAME_TYPE_URTYPE);
            SOAPArrayType arrayType = new SOAPArrayType(component.getName());
            arrayType.setElementName(InternalEncodingConstants.ARRAY_ELEMENT_NAME);
            arrayType.setElementType(anyType);
            arrayType.setRank(1);
            arrayType.setSize(null);
            JavaArrayType javaArrayType = new JavaArrayType(anyType.getJavaType().getName() + "[]");
            javaArrayType.setElementType(anyType.getJavaType());
            arrayType.setJavaType(javaArrayType);
            return arrayType;
        }
        if (component.getBaseTypeDefinition() == this._schema.getUrType()) {
            return this.urTypeBasedComplexSchemaTypeToSOAPType(component);
        }
        if (component.getBaseTypeDefinition().getName().equals(SOAPConstants.QNAME_TYPE_ARRAY)) {
            return this.soapArrayBasedComplexSchemaTypeToSOAPType(component);
        }
        if (component.getName() != null && (javaType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(component.getName())) != null) {
            SOAPSimpleType simpleType = new SOAPSimpleType(component.getName());
            simpleType.setSchemaTypeRef(component.getName());
            simpleType.setJavaType(javaType);
            this.setReferenceable(simpleType);
            return simpleType;
        }
        if (component.getDerivationMethod() == Symbol.EXTENSION) {
            SOAPType parentType = this.schemaTypeToSOAPType(component.getBaseTypeDefinition());
            if (parentType instanceof SOAPStructureType) {
                return this.soapStructureExtensionComplexSchemaTypeToSOAPType(component, (SOAPStructureType)parentType);
            }
            return this.mustGetCustomTypeFor(component);
        }
        return this.mustGetCustomTypeFor(component);
    }

    protected SOAPType urTypeBasedComplexSchemaTypeToSOAPType(ComplexTypeDefinitionComponent component) {
        JavaSimpleType javaType;
        if (component.getName() != null && (javaType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(component.getName())) != null) {
            SOAPSimpleType simpleType = new SOAPSimpleType(component.getName());
            simpleType.setSchemaTypeRef(component.getName());
            simpleType.setJavaType(javaType);
            this.setReferenceable(simpleType);
            return simpleType;
        }
        if (component.getContentTag() == 4) {
            if (component.hasNoAttributeUses()) {
                ParticleComponent particle = component.getParticleContent();
                if (particle.occursOnce()) {
                    if (particle.getTermTag() == 1) {
                        ModelGroupComponent modelGroup = particle.getModelGroupTerm();
                        if (modelGroup.getCompositor() == Symbol.ALL || modelGroup.getCompositor() == Symbol.SEQUENCE) {
                            SOAPStructureType structureType = null;
                            structureType = modelGroup.getCompositor() == Symbol.ALL ? new SOAPUnorderedStructureType(component.getName()) : new SOAPOrderedStructureType(component.getName());
                            JavaStructureType javaStructureType = new JavaStructureType(this.makePackageQualified(this._env.getNames().validJavaClassName(component.getName().getLocalPart()), component.getName()), false, structureType);
                            this.resolveNamingConflictsFor(javaStructureType);
                            structureType.setJavaType(javaStructureType);
                            this._componentToSOAPTypeMap.put(component, structureType);
                            Iterator iter = modelGroup.particles();
                            while (iter.hasNext()) {
                                ParticleComponent memberParticle = (ParticleComponent)iter.next();
                                if (memberParticle.occursOnce() || memberParticle.occursAtMostOnce()) {
                                    if (memberParticle.getTermTag() == 3) {
                                        ElementDeclarationComponent element = memberParticle.getElementTerm();
                                        SOAPType memberType = element.isNillable() ? (element.getTypeDefinition().isSimple() ? this.nillableSchemaTypeToSOAPType(element.getTypeDefinition()) : this.schemaTypeToSOAPType(element.getTypeDefinition())) : this.schemaTypeToSOAPType(element.getTypeDefinition());
                                        SOAPStructureMember member = new SOAPStructureMember(element.getName(), memberType);
                                        JavaStructureMember javaMember = new JavaStructureMember(this._env.getNames().validJavaMemberName(element.getName().getLocalPart()), memberType.getJavaType(), member, false);
                                        javaMember.setReadMethod(this._env.getNames().getJavaMemberReadMethod(javaMember));
                                        javaMember.setWriteMethod(this._env.getNames().getJavaMemberWriteMethod(javaMember));
                                        member.setJavaStructureMember(javaMember);
                                        javaStructureType.add(javaMember);
                                        structureType.add(member);
                                        continue;
                                    }
                                    return this.mustGetCustomTypeFor(component);
                                }
                                return this.mustGetCustomTypeFor(component);
                            }
                            structureType.setJavaType(javaStructureType);
                            return structureType;
                        }
                        return this.mustGetCustomTypeFor(component);
                    }
                    return this.mustGetCustomTypeFor(component);
                }
                return this.mustGetCustomTypeFor(component);
            }
            return this.mustGetCustomTypeFor(component);
        }
        if (component.getContentTag() == 1) {
            if (component.hasNoAttributeUses()) {
                SOAPOrderedStructureType structureType = new SOAPOrderedStructureType(component.getName());
                JavaStructureType javaStructureType = new JavaStructureType(this.makePackageQualified(this._env.getNames().validJavaClassName(component.getName().getLocalPart()), component.getName()), false, structureType);
                structureType.setJavaType(javaStructureType);
                return structureType;
            }
            return this.mustGetCustomTypeFor(component);
        }
        if (component.getContentTag() == 2) {
            if (component.hasNoAttributeUses()) {
                if (component.getName().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/encoding/")) {
                    SOAPSimpleType simpleType = new SOAPSimpleType(component.getName());
                    simpleType.setSchemaTypeRef(component.getName());
                    JavaSimpleType javaType2 = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(component.getName());
                    if (javaType2 == null) {
                        this.failUnsupported("U013", component.getName());
                    }
                    simpleType.setJavaType(javaType2);
                    this.setReferenceable(simpleType);
                    return simpleType;
                }
                return this.mustGetCustomTypeFor(component);
            }
            return this.mustGetCustomTypeFor(component);
        }
        return this.mustGetCustomTypeFor(component);
    }

    protected SOAPType soapStructureExtensionComplexSchemaTypeToSOAPType(ComplexTypeDefinitionComponent component, SOAPStructureType parentType) {
        if (component.getContentTag() == 4) {
            if (component.hasNoAttributeUses()) {
                ParticleComponent particle = component.getParticleContent();
                if (particle.occursOnce()) {
                    if (particle.getTermTag() == 1) {
                        ModelGroupComponent modelGroup = particle.getModelGroupTerm();
                        if (modelGroup.getCompositor() == Symbol.ALL || modelGroup.getCompositor() == Symbol.SEQUENCE) {
                            Iterator iter;
                            SOAPStructureType structureType = null;
                            structureType = modelGroup.getCompositor() == Symbol.ALL ? new SOAPUnorderedStructureType(component.getName()) : new SOAPOrderedStructureType(component.getName());
                            if (parentType != null && parentType.getClass() != structureType.getClass()) {
                                return this.mustGetCustomTypeFor(component);
                            }
                            JavaStructureType javaStructureType = new JavaStructureType(this.makePackageQualified(this._env.getNames().validJavaClassName(component.getName().getLocalPart()), component.getName()), false, structureType);
                            this.resolveNamingConflictsFor(javaStructureType);
                            structureType.setJavaType(javaStructureType);
                            this._componentToSOAPTypeMap.put(component, structureType);
                            if (parentType != null) {
                                iter = parentType.getMembers();
                                while (iter.hasNext()) {
                                    SOAPStructureMember member = (SOAPStructureMember)iter.next();
                                    SOAPStructureMember inheritedMember = new SOAPStructureMember(member.getName(), member.getType());
                                    inheritedMember.setInherited(true);
                                    JavaStructureMember javaMember = member.getJavaStructureMember();
                                    JavaStructureMember inheritedJavaMember = new JavaStructureMember(javaMember.getName(), javaMember.getType(), inheritedMember, false);
                                    inheritedJavaMember.setInherited(true);
                                    inheritedJavaMember.setReadMethod(javaMember.getReadMethod());
                                    inheritedJavaMember.setWriteMethod(javaMember.getWriteMethod());
                                    inheritedMember.setJavaStructureMember(inheritedJavaMember);
                                    structureType.add(inheritedMember);
                                }
                                parentType.addSubtype(structureType);
                                ((JavaStructureType)parentType.getJavaType()).addSubclass(javaStructureType);
                            }
                            iter = modelGroup.particles();
                            while (iter.hasNext()) {
                                ParticleComponent memberParticle = (ParticleComponent)iter.next();
                                if (memberParticle.occursOnce() || memberParticle.occursAtMostOnce()) {
                                    if (memberParticle.getTermTag() == 3) {
                                        ElementDeclarationComponent element = memberParticle.getElementTerm();
                                        SOAPType memberType = element.isNillable() ? (element.getTypeDefinition().isSimple() ? this.nillableSchemaTypeToSOAPType(element.getTypeDefinition()) : this.schemaTypeToSOAPType(element.getTypeDefinition())) : this.schemaTypeToSOAPType(element.getTypeDefinition());
                                        SOAPStructureMember member = new SOAPStructureMember(element.getName(), memberType);
                                        JavaStructureMember javaMember = new JavaStructureMember(this._env.getNames().validJavaMemberName(element.getName().getLocalPart()), memberType.getJavaType(), member, false);
                                        javaMember.setReadMethod(this._env.getNames().getJavaMemberReadMethod(javaMember));
                                        javaMember.setWriteMethod(this._env.getNames().getJavaMemberWriteMethod(javaMember));
                                        member.setJavaStructureMember(javaMember);
                                        javaStructureType.add(javaMember);
                                        structureType.add(member);
                                        continue;
                                    }
                                    return this.mustGetCustomTypeFor(component);
                                }
                                return this.mustGetCustomTypeFor(component);
                            }
                            structureType.setJavaType(javaStructureType);
                            return structureType;
                        }
                        return this.mustGetCustomTypeFor(component);
                    }
                    return this.mustGetCustomTypeFor(component);
                }
                return this.mustGetCustomTypeFor(component);
            }
            return this.mustGetCustomTypeFor(component);
        }
        if (component.getContentTag() == 1) {
            if (component.hasNoAttributeUses()) {
                SOAPStructureType structureType = null;
                structureType = parentType != null ? (parentType instanceof SOAPOrderedStructureType ? new SOAPOrderedStructureType(component.getName()) : new SOAPUnorderedStructureType(component.getName())) : new SOAPOrderedStructureType(component.getName());
                JavaStructureType javaStructureType = new JavaStructureType(this.makePackageQualified(this._env.getNames().validJavaClassName(component.getName().getLocalPart()), component.getName()), false, structureType);
                structureType.setJavaType(javaStructureType);
                if (parentType != null && parentType.getClass() != structureType.getClass()) {
                    return this.mustGetCustomTypeFor(component);
                }
                if (parentType != null) {
                    Iterator iter = parentType.getMembers();
                    while (iter.hasNext()) {
                        SOAPStructureMember member = (SOAPStructureMember)iter.next();
                        SOAPStructureMember inheritedMember = new SOAPStructureMember(member.getName(), member.getType());
                        inheritedMember.setInherited(true);
                        JavaStructureMember javaMember = member.getJavaStructureMember();
                        JavaStructureMember inheritedJavaMember = new JavaStructureMember(javaMember.getName(), javaMember.getType(), inheritedMember, false);
                        inheritedJavaMember.setInherited(true);
                        inheritedJavaMember.setReadMethod(javaMember.getReadMethod());
                        inheritedJavaMember.setWriteMethod(javaMember.getWriteMethod());
                        inheritedMember.setJavaStructureMember(inheritedJavaMember);
                        structureType.add(inheritedMember);
                    }
                    parentType.addSubtype(structureType);
                    ((JavaStructureType)parentType.getJavaType()).addSubclass(javaStructureType);
                }
                return structureType;
            }
            return this.mustGetCustomTypeFor(component);
        }
        if (component.getContentTag() == 2) {
            if (component.hasNoAttributeUses()) {
                if (component.getName().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/encoding/")) {
                    SOAPSimpleType simpleType = new SOAPSimpleType(component.getName());
                    simpleType.setSchemaTypeRef(component.getName());
                    JavaSimpleType javaType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(component.getName());
                    if (javaType == null) {
                        this.failUnsupported("U013", component.getName());
                    }
                    simpleType.setJavaType(javaType);
                    this.setReferenceable(simpleType);
                    return simpleType;
                }
                return this.mustGetCustomTypeFor(component);
            }
            return this.mustGetCustomTypeFor(component);
        }
        return this.mustGetCustomTypeFor(component);
    }

    protected SOAPType soapArrayBasedComplexSchemaTypeToSOAPType(ComplexTypeDefinitionComponent component) {
        JavaSimpleType javaType;
        if (component.getName() != null && (javaType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(component.getName())) != null) {
            SOAPSimpleType simpleType = new SOAPSimpleType(component.getName());
            simpleType.setSchemaTypeRef(component.getName());
            simpleType.setJavaType(javaType);
            this.setReferenceable(simpleType);
            return simpleType;
        }
        boolean found = false;
        Iterator iter = component.attributeUses();
        while (iter.hasNext()) {
            AttributeUseComponent attributeUse = (AttributeUseComponent)iter.next();
            AttributeDeclarationComponent attributeDeclaration = attributeUse.getAttributeDeclaration();
            if (attributeDeclaration.getName() == null || !attributeDeclaration.getName().equals(SOAPConstants.QNAME_ATTR_ARRAY_TYPE)) continue;
            if (found) {
                return this.mustGetCustomTypeFor(component);
            }
            found = true;
            Iterator iter2 = attributeUse.getAnnotation().attributes();
            while (iter2.hasNext()) {
                SchemaAttribute attr = (SchemaAttribute)iter2.next();
                if (!attr.getQName().equals(WSDLConstants.QNAME_ATTR_ARRAY_TYPE)) continue;
                String typeSpecifier = attr.getValue();
                if (typeSpecifier == null) {
                    throw new ModelException(new ValidationException("validation.invalidAttributeValue", new Object[]{typeSpecifier, "arrayType"}));
                }
                return this.processSOAPArrayType(component, attr.getParent(), attr.getValue());
            }
        }
        if (component.getContentTag() == 4) {
            ParticleComponent particle = component.getParticleContent();
            if (particle.occursOnce()) {
                if (particle.getTermTag() == 1) {
                    ModelGroupComponent modelGroup = particle.getModelGroupTerm();
                    if (modelGroup.getCompositor() == Symbol.SEQUENCE) {
                        SOAPArrayType arrayType = new SOAPArrayType(component.getName());
                        found = false;
                        Iterator iter2 = modelGroup.particles();
                        while (iter2.hasNext()) {
                            ParticleComponent memberParticle = (ParticleComponent)iter2.next();
                            if (found) {
                                return this.mustGetCustomTypeFor(component);
                            }
                            found = true;
                            if (memberParticle.occursZeroOrMore()) {
                                if (memberParticle.getTermTag() == 3) {
                                    ElementDeclarationComponent element = memberParticle.getElementTerm();
                                    SOAPType arrayElementType = this.schemaTypeToSOAPType(element.getTypeDefinition());
                                    arrayType.setElementName(element.getName());
                                    arrayType.setElementType(arrayElementType);
                                    arrayType.setRank(1);
                                    if (arrayElementType.getJavaType() == null) continue;
                                    JavaArrayType javaArrayType = new JavaArrayType(arrayElementType.getJavaType().getName() + "[]");
                                    javaArrayType.setElementType(arrayElementType.getJavaType());
                                    arrayType.setJavaType(javaArrayType);
                                    continue;
                                }
                                return this.mustGetCustomTypeFor(component);
                            }
                            return this.mustGetCustomTypeFor(component);
                        }
                        if (found) {
                            return arrayType;
                        }
                        return this.mustGetCustomTypeFor(component);
                    }
                    return this.mustGetCustomTypeFor(component);
                }
                return this.mustGetCustomTypeFor(component);
            }
            return this.mustGetCustomTypeFor(component);
        }
        return this.mustGetCustomTypeFor(component);
    }

    protected SOAPType processSOAPArrayType(TypeDefinitionComponent component, SchemaElement element, String typeSpecifier) {
        try {
            int closingBracketIndex;
            int openingBracketIndex = typeSpecifier.indexOf(91);
            if (openingBracketIndex == -1) {
                throw new ValidationException("validation.invalidAttributeValue", new Object[]{typeSpecifier, "arrayType"});
            }
            int currentRank = 0;
            String typeName = typeSpecifier.substring(0, openingBracketIndex).trim();
            QName typeQName = element.asQName(typeName);
            SOAPType elementType = this.schemaTypeToSOAPType(typeQName);
            if (elementType instanceof SOAPArrayType) {
                currentRank = ((SOAPArrayType)elementType).getRank();
            }
            do {
                if ((closingBracketIndex = typeSpecifier.indexOf(93, openingBracketIndex)) == -1) {
                    throw new ValidationException("validation.invalidAttributeValue", new Object[]{typeSpecifier, "arrayType"});
                }
                int commaIndex = typeSpecifier.indexOf(44, openingBracketIndex + 1);
                if (commaIndex == -1 || commaIndex > closingBracketIndex) {
                    int[] size = null;
                    if (closingBracketIndex - openingBracketIndex > 1) {
                        int i = Integer.parseInt(typeSpecifier.substring(openingBracketIndex + 1, closingBracketIndex));
                        size = new int[]{i};
                    }
                    SOAPArrayType arrayType = new SOAPArrayType(component.getName());
                    arrayType.setElementName(InternalEncodingConstants.ARRAY_ELEMENT_NAME);
                    arrayType.setElementType(elementType);
                    arrayType.setRank(++currentRank);
                    arrayType.setSize(size);
                    if (elementType.getJavaType() != null) {
                        JavaArrayType javaArrayType = new JavaArrayType(elementType.getJavaType().getName() + "[]");
                        javaArrayType.setElementType(elementType.getJavaType());
                        arrayType.setJavaType(javaArrayType);
                    }
                    elementType = arrayType;
                    continue;
                }
                ArrayList<Integer> sizeList = null;
                boolean allowSizeSpecifiers = true;
                boolean timeToGo = false;
                int rank = 0;
                int contentIndex = openingBracketIndex + 1;
                while (true) {
                    ++rank;
                    if (commaIndex - contentIndex > 0) {
                        if (!allowSizeSpecifiers) {
                            throw new ValidationException("validation.invalidAttributeValue", new Object[]{typeSpecifier, "arrayType"});
                        }
                        int i = Integer.parseInt(typeSpecifier.substring(contentIndex, commaIndex));
                        if (sizeList == null) {
                            sizeList = new ArrayList<Integer>();
                        }
                        sizeList.add(new Integer(i));
                    } else {
                        if (sizeList != null) {
                            throw new ValidationException("validation.invalidAttributeValue", new Object[]{typeSpecifier, "arrayType"});
                        }
                        allowSizeSpecifiers = false;
                    }
                    if (timeToGo) break;
                    contentIndex = commaIndex + 1;
                    if ((commaIndex = typeSpecifier.indexOf(44, contentIndex)) != -1 && commaIndex <= closingBracketIndex) continue;
                    commaIndex = closingBracketIndex;
                    timeToGo = true;
                }
                SOAPArrayType arrayType = new SOAPArrayType(component.getName());
                arrayType.setElementName(InternalEncodingConstants.ARRAY_ELEMENT_NAME);
                arrayType.setElementType(elementType);
                arrayType.setRank(currentRank += rank);
                int[] size = null;
                if (allowSizeSpecifiers && sizeList != null) {
                    size = new int[sizeList.size()];
                    int i = 0;
                    while (i < size.length) {
                        size[i] = (Integer)sizeList.get(i);
                        ++i;
                    }
                }
                arrayType.setSize(size);
                if (elementType.getJavaType() != null) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(elementType.getJavaType().getName());
                    int i = 0;
                    while (i < rank) {
                        sb.append("[]");
                        ++i;
                    }
                    String javaArrayTypeName = sb.toString();
                    JavaArrayType javaArrayType = new JavaArrayType(javaArrayTypeName);
                    javaArrayType.setElementType(elementType.getJavaType());
                    arrayType.setJavaType(javaArrayType);
                }
                elementType = arrayType;
            } while ((openingBracketIndex = typeSpecifier.indexOf(91, closingBracketIndex + 1)) != -1);
            if (closingBracketIndex != typeSpecifier.length() - 1) {
                throw new ValidationException("validation.invalidAttributeValue", new Object[]{typeSpecifier, "arrayType"});
            }
            return elementType;
        }
        catch (NumberFormatException e) {
            throw new ModelException(new ValidationException("validation.invalidAttributeValue", new Object[]{typeSpecifier, "arrayType"}));
        }
        catch (ValidationException e) {
            throw new ModelException(e);
        }
    }

    protected LiteralType schemaTypeToLiteralType(TypeDefinitionComponent component, QName nameHint) {
        LiteralType result = (LiteralType)this._componentToLiteralTypeMap.get(component);
        if (result == null) {
            try {
                if (this._noDataBinding) {
                    result = this.getLiteralFragmentTypeFor(component, nameHint);
                } else if (component.isSimple()) {
                    result = this.simpleSchemaTypeToLiteralType((SimpleTypeDefinitionComponent)component, nameHint);
                } else if (component.isComplex()) {
                    result = this.complexSchemaTypeToLiteralType((ComplexTypeDefinitionComponent)component, nameHint);
                } else {
                    throw new IllegalArgumentException();
                }
                this._componentToLiteralTypeMap.put(component, result);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
        return result;
    }

    protected LiteralType simpleSchemaTypeToLiteralType(SimpleTypeDefinitionComponent component, QName nameHint) {
        if (component.getBaseTypeDefinition() == this._schema.getSimpleUrType()) {
            if (component.getVarietyTag() == 1) {
                String nsURI = component.getName().getNamespaceURI();
                if (nsURI != null && nsURI.equals("http://www.w3.org/2001/XMLSchema")) {
                    if (!component.facets().hasNext()) {
                        if (component.getName().equals(SchemaConstants.QNAME_TYPE_URTYPE)) {
                            return this.getLiteralFragmentTypeFor(component, nameHint);
                        }
                        LiteralSimpleType simpleType = new LiteralSimpleType(component.getName());
                        simpleType.setSchemaTypeRef(component.getName());
                        JavaSimpleType javaType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(component.getName());
                        if (javaType == null) {
                            return this.getLiteralFragmentTypeFor(component, nameHint);
                        }
                        simpleType.setJavaType(javaType);
                        return simpleType;
                    }
                    return this.getLiteralSimpleStringTypeFor(component, nameHint);
                }
                return this.getLiteralSimpleStringTypeFor(component, nameHint);
            }
            return this.getLiteralSimpleStringTypeFor(component, nameHint);
        }
        SimpleTypeDefinitionComponent baseTypeComponent = component.getBaseTypeDefinition();
        if (component.getVarietyTag() == 1) {
            String nsURI = baseTypeComponent.getName().getNamespaceURI();
            if (nsURI != null && nsURI.equals("http://www.w3.org/2001/XMLSchema")) {
                LiteralType baseType = this.schemaTypeToLiteralType(baseTypeComponent, nameHint);
                return baseType;
            }
            return this.getLiteralSimpleStringTypeFor(component, nameHint);
        }
        return this.getLiteralSimpleStringTypeFor(component, nameHint);
    }

    protected LiteralType complexSchemaTypeToLiteralType(ComplexTypeDefinitionComponent component, QName nameHint) {
        if (component == this._schema.getUrType()) {
            if (component.getName().equals(SchemaConstants.QNAME_TYPE_URTYPE)) {
                LiteralFragmentType literalType = new LiteralFragmentType();
                literalType.setName(component.getName());
                literalType.setJavaType(this.javaTypes.SOAPELEMENT_JAVATYPE);
                return literalType;
            }
            LiteralSimpleType simpleType = new LiteralSimpleType(component.getName());
            simpleType.setSchemaTypeRef(component.getName());
            JavaSimpleType javaType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(component.getName());
            if (javaType == null) {
                return this.getLiteralFragmentTypeFor(component, nameHint);
            }
            simpleType.setJavaType(javaType);
            return simpleType;
        }
        if (component.getBaseTypeDefinition() == this._schema.getUrType()) {
            return this.urTypeBasedComplexSchemaTypeToLiteralType(component, nameHint);
        }
        return this.getLiteralFragmentTypeFor(component, nameHint);
    }

    protected LiteralType urTypeBasedComplexSchemaTypeToLiteralType(ComplexTypeDefinitionComponent component, QName nameHint) {
        if (component.getContentTag() == 4) {
            ParticleComponent particle = component.getParticleContent();
            if (particle.occursOnce()) {
                if (particle.getTermTag() == 1) {
                    ModelGroupComponent modelGroup = particle.getModelGroupTerm();
                    if (modelGroup.getCompositor() == Symbol.ALL || modelGroup.getCompositor() == Symbol.SEQUENCE) {
                        LiteralStructuredType structureType = null;
                        structureType = modelGroup.getCompositor() == Symbol.ALL ? new LiteralAllType(this.getUniqueQNameFor(component, nameHint)) : new LiteralSequenceType(this.getUniqueQNameFor(component, nameHint));
                        JavaStructureType javaStructureType = new JavaStructureType(this.makePackageQualified(this._env.getNames().validJavaClassName(structureType.getName().getLocalPart()), structureType.getName()), false, structureType);
                        this.resolveNamingConflictsFor(javaStructureType);
                        structureType.setJavaType(javaStructureType);
                        this._componentToLiteralTypeMap.put(component, structureType);
                        Iterator iter = component.attributeUses();
                        while (iter.hasNext()) {
                            AttributeUseComponent attributeUse = (AttributeUseComponent)iter.next();
                            AttributeDeclarationComponent attributeDeclaration = attributeUse.getAttributeDeclaration();
                            LiteralType attributeType = this.schemaTypeToLiteralType(attributeDeclaration.getTypeDefinition(), this.getAttributeQNameHint(attributeDeclaration, nameHint));
                            if (SimpleTypeSerializerWriter.getTypeEncoder(attributeType) == null) {
                                return this.getLiteralFragmentTypeFor(component, nameHint);
                            }
                            LiteralAttributeMember member = new LiteralAttributeMember(attributeDeclaration.getName(), attributeType);
                            if (attributeUse.isRequired()) {
                                member.setRequired(true);
                            }
                            JavaStructureMember javaMember = new JavaStructureMember(this._env.getNames().validJavaMemberName(attributeDeclaration.getName().getLocalPart()), attributeType.getJavaType(), member, false);
                            javaMember.setReadMethod(this._env.getNames().getJavaMemberReadMethod(javaMember));
                            javaMember.setWriteMethod(this._env.getNames().getJavaMemberWriteMethod(javaMember));
                            member.setJavaStructureMember(javaMember);
                            javaStructureType.add(javaMember);
                            structureType.add(member);
                        }
                        Iterator iter2 = modelGroup.particles();
                        while (iter2.hasNext()) {
                            ParticleComponent memberParticle = (ParticleComponent)iter2.next();
                            if (memberParticle.doesNotOccur()) continue;
                            if (memberParticle.getTermTag() == 3) {
                                ElementDeclarationComponent element = memberParticle.getElementTerm();
                                LiteralType memberType = this.schemaTypeToLiteralType(element.getTypeDefinition(), this.getElementQNameHint(element, nameHint));
                                LiteralElementMember member = new LiteralElementMember(element.getName(), memberType);
                                JavaType javaMemberType = null;
                                if (element.isNillable()) {
                                    member.setNillable(true);
                                    JavaSimpleType javaType = (JavaSimpleType)this._builtinSchemaTypeToJavaWrapperTypeMap.get(element.getTypeDefinition().getName());
                                    if (javaType != null) {
                                        LiteralSimpleType result = (LiteralSimpleType)this._nillableSimpleTypeComponentToLiteralTypeMap.get(element.getTypeDefinition());
                                        if (result == null) {
                                            result = new LiteralSimpleType(element.getTypeDefinition().getName(), javaType);
                                            result.setSchemaTypeRef(element.getTypeDefinition().getName());
                                            this._nillableSimpleTypeComponentToLiteralTypeMap.put(element.getTypeDefinition(), result);
                                        }
                                        memberType = result;
                                    }
                                }
                                if (memberParticle.occursAtLeastOnce()) {
                                    member.setRequired(true);
                                }
                                if (memberParticle.mayOccurMoreThanOnce()) {
                                    member.setRepeated(true);
                                    JavaArrayType javaArrayType = new JavaArrayType(memberType.getJavaType().getName() + "[]");
                                    javaArrayType.setElementType(memberType.getJavaType());
                                    javaMemberType = javaArrayType;
                                } else {
                                    javaMemberType = memberType.getJavaType();
                                }
                                JavaStructureMember javaMember = new JavaStructureMember(this._env.getNames().validJavaMemberName(element.getName().getLocalPart()), javaMemberType, member, false);
                                javaMember.setReadMethod(this._env.getNames().getJavaMemberReadMethod(javaMember));
                                javaMember.setWriteMethod(this._env.getNames().getJavaMemberWriteMethod(javaMember));
                                member.setJavaStructureMember(javaMember);
                                javaStructureType.add(javaMember);
                                structureType.add(member);
                                continue;
                            }
                            return this.getLiteralFragmentTypeFor(component, nameHint);
                        }
                        return structureType;
                    }
                    return this.getLiteralFragmentTypeFor(component, nameHint);
                }
                return this.getLiteralFragmentTypeFor(component, nameHint);
            }
            return this.getLiteralFragmentTypeFor(component, nameHint);
        }
        if (component.getContentTag() == 1) {
            LiteralSequenceType structureType = new LiteralSequenceType(this.getUniqueQNameFor(component, nameHint));
            JavaStructureType javaStructureType = new JavaStructureType(this.makePackageQualified(this._env.getNames().validJavaClassName(structureType.getName().getLocalPart()), structureType.getName()), false, structureType);
            this.resolveNamingConflictsFor(javaStructureType);
            structureType.setJavaType(javaStructureType);
            this._componentToLiteralTypeMap.put(component, structureType);
            Iterator iter = component.attributeUses();
            while (iter.hasNext()) {
                AttributeUseComponent attributeUse = (AttributeUseComponent)iter.next();
                AttributeDeclarationComponent attributeDeclaration = attributeUse.getAttributeDeclaration();
                LiteralType attributeType = this.schemaTypeToLiteralType(attributeDeclaration.getTypeDefinition(), this.getAttributeQNameHint(attributeDeclaration, nameHint));
                if (SimpleTypeSerializerWriter.getTypeEncoder(attributeType) == null) {
                    return this.getLiteralFragmentTypeFor(component, nameHint);
                }
                LiteralAttributeMember member = new LiteralAttributeMember(attributeDeclaration.getName(), attributeType);
                if (attributeUse.isRequired()) {
                    member.setRequired(true);
                }
                JavaStructureMember javaMember = new JavaStructureMember(this._env.getNames().validJavaMemberName(attributeDeclaration.getName().getLocalPart()), attributeType.getJavaType(), member, false);
                javaMember.setReadMethod(this._env.getNames().getJavaMemberReadMethod(javaMember));
                javaMember.setWriteMethod(this._env.getNames().getJavaMemberWriteMethod(javaMember));
                member.setJavaStructureMember(javaMember);
                javaStructureType.add(javaMember);
                structureType.add(member);
            }
            return structureType;
        }
        return this.getLiteralFragmentTypeFor(component, nameHint);
    }

    protected LiteralFragmentType getLiteralFragmentTypeFor(TypeDefinitionComponent component, QName nameHint) {
        LiteralFragmentType literalType = new LiteralFragmentType();
        literalType.setName(this.getUniqueQNameFor(component, nameHint));
        literalType.setJavaType(this.javaTypes.SOAPELEMENT_JAVATYPE);
        return literalType;
    }

    protected LiteralType getLiteralSimpleStringTypeFor(TypeDefinitionComponent component, QName nameHint) {
        LiteralSimpleType literalType = new LiteralSimpleType(this.getUniqueQNameFor(component, nameHint));
        literalType.setJavaType(this.javaTypes.STRING_JAVATYPE);
        return literalType;
    }

    protected String makePackageQualified(String s, QName name) {
        String javaPackageName = this.getJavaPackageName(name);
        if (javaPackageName != null) {
            return javaPackageName + "." + s;
        }
        if (this._modelInfo.getJavaPackageName() != null && !this._modelInfo.getJavaPackageName().equals("")) {
            return this._modelInfo.getJavaPackageName() + "." + s;
        }
        return s;
    }

    protected QName makePackageQualified(QName name) {
        return new QName(name.getNamespaceURI(), this.makePackageQualified(name.getLocalPart(), name));
    }

    protected SOAPCustomType getCustomTypeFor(TypeDefinitionComponent component) {
        TypeMappingInfo tmi;
        QName typeName = component.getName();
        if (typeName == null) {
            return null;
        }
        SOAPCustomType customType = (SOAPCustomType)this._typeNameToCustomSOAPTypeMap.get(typeName);
        if (customType == null && this._modelInfo.getTypeMappingRegistry() != null && (tmi = this._modelInfo.getTypeMappingRegistry().getTypeMappingInfo("http://schemas.xmlsoap.org/soap/encoding/", typeName)) != null) {
            customType = new SOAPCustomType(typeName);
            JavaCustomType javaCustomType = new JavaCustomType(tmi.getJavaTypeName(), tmi);
            customType.setJavaType(javaCustomType);
            this._typeNameToCustomSOAPTypeMap.put(typeName, customType);
        }
        return customType;
    }

    protected SOAPCustomType mustGetCustomTypeFor(TypeDefinitionComponent component) {
        SOAPCustomType type = this.getCustomTypeFor(component);
        if (type == null) {
            this.failUnsupported("U012", component.getName());
        }
        return type;
    }

    protected boolean isInvalidEnumerationLabel(String s) {
        if (s == null || s.equals("") || !Character.isJavaIdentifierStart(s.charAt(0))) {
            return true;
        }
        int i = 1;
        while (i < s.length()) {
            if (!Character.isJavaIdentifierPart(s.charAt(i))) {
                return true;
            }
            ++i;
        }
        return this._env.getNames().isJavaReservedWord(s);
    }

    private String getJavaPackageName(QName name) {
        NamespaceMappingInfo i;
        String packageName = null;
        if (this._modelInfo.getNamespaceMappingRegistry() != null && (i = this._modelInfo.getNamespaceMappingRegistry().getNamespaceMappingInfo(name)) != null) {
            return i.getJavaPackageName();
        }
        return packageName;
    }

    protected void fail(String key, String code, QName arg) {
        if (arg == null) {
            throw new ModelException(key + ".anonymous", code);
        }
        throw new ModelException(key, new Object[]{code, arg.getLocalPart(), arg.getNamespaceURI()});
    }

    protected void failUnsupported(String code, QName arg) {
        this.fail("model.schema.unsupportedType", code, arg);
    }

    protected QName getElementQNameHint(ElementDeclarationComponent component, QName nameHint) {
        QName componentName = component.getName();
        if (!componentName.getNamespaceURI().equals("")) {
            return componentName;
        }
        return new QName(nameHint.getNamespaceURI(), nameHint.getLocalPart() + "-" + componentName.getLocalPart());
    }

    protected QName getAttributeQNameHint(AttributeDeclarationComponent component, QName nameHint) {
        return new QName(nameHint.getNamespaceURI(), nameHint.getLocalPart() + "-" + component.getName().getLocalPart());
    }

    protected QName getUniqueLiteralArrayTypeQNameFor(QName subTypeName, QName nameHint) {
        return new QName(subTypeName.getNamespaceURI(), subTypeName.getLocalPart() + "-Array-" + this.getUniqueID());
    }

    protected QName getUniqueTypeNameForElement(QName elementName) {
        return new QName(elementName.getNamespaceURI(), elementName.getLocalPart() + "-AnonType-" + this.getUniqueID());
    }

    protected String getUniqueNCNameFor(TypeDefinitionComponent component) {
        if (component.getName() != null) {
            return component.getName().getLocalPart();
        }
        return "genType-" + this.getUniqueID();
    }

    protected QName getUniqueQNameFor(TypeDefinitionComponent component, QName nameHint) {
        if (component.getName() != null) {
            return component.getName();
        }
        QName result = null;
        result = nameHint != null ? (!this._namePool.contains(nameHint) ? nameHint : new QName(nameHint.getNamespaceURI(), nameHint.getLocalPart() + "-gen-" + this.getUniqueID())) : (!this._namePool.contains(nameHint) ? nameHint : new QName(nameHint.getLocalPart() + "-gen-" + this.getUniqueID()));
        this._namePool.add(result);
        return result;
    }

    protected int getUniqueID() {
        return this._nextUniqueID++;
    }

    protected void resolveNamingConflictsFor(JavaType javaType) {
        if (this._conflictingClassNames != null && this._conflictingClassNames.contains(javaType.getName()) && javaType.getName().equals(javaType.getRealName())) {
            javaType.doSetName(javaType.getName() + "_Type");
        }
    }

    protected void setReferenceable(SOAPSimpleType simpleType) {
        boolean referenceable = true;
        QName name = simpleType.getName();
        if (name.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") && !name.equals(BuiltInTypes.STRING) && !name.equals(BuiltInTypes.BASE64_BINARY) && !name.equals(BuiltInTypes.HEX_BINARY)) {
            referenceable = false;
        }
        simpleType.setReferenceable(referenceable);
    }

    private void initializeMaps() {
        this._builtinSchemaTypeToJavaTypeMap = new HashMap();
        if (this._useDataHandlerOnly) {
            this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_IMAGE, this.javaTypes.DATA_HANDLER_JAVATYPE);
            this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_MIME_MULTIPART, this.javaTypes.DATA_HANDLER_JAVATYPE);
            this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_SOURCE, this.javaTypes.DATA_HANDLER_JAVATYPE);
        } else {
            this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_IMAGE, this.javaTypes.IMAGE_JAVATYPE);
            this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_MIME_MULTIPART, this.javaTypes.MIME_MULTIPART_JAVATYPE);
            this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_SOURCE, this.javaTypes.SOURCE_JAVATYPE);
        }
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_DATA_HANDLER, this.javaTypes.DATA_HANDLER_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.STRING, this.javaTypes.STRING_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.INTEGER, this.javaTypes.BIG_INTEGER_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.INT, this.javaTypes.INT_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.LONG, this.javaTypes.LONG_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.SHORT, this.javaTypes.SHORT_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.DECIMAL, this.javaTypes.DECIMAL_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.FLOAT, this.javaTypes.FLOAT_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.DOUBLE, this.javaTypes.DOUBLE_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.BOOLEAN, this.javaTypes.BOOLEAN_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.BYTE, this.javaTypes.BYTE_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.QNAME, this.javaTypes.QNAME_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.DATE_TIME, this.javaTypes.CALENDAR_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.BASE64_BINARY, this.javaTypes.BYTE_ARRAY_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.HEX_BINARY, this.javaTypes.BYTE_ARRAY_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SchemaConstants.QNAME_TYPE_URTYPE, this.javaTypes.OBJECT_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_STRING, this.javaTypes.STRING_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_INTEGER, this.javaTypes.BIG_INTEGER_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_INT, this.javaTypes.BOXED_INTEGER_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_LONG, this.javaTypes.BOXED_LONG_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_SHORT, this.javaTypes.BOXED_SHORT_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_DECIMAL, this.javaTypes.DECIMAL_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_FLOAT, this.javaTypes.BOXED_FLOAT_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_DOUBLE, this.javaTypes.BOXED_DOUBLE_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_BOOLEAN, this.javaTypes.BOXED_BOOLEAN_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_BYTE, this.javaTypes.BOXED_BYTE_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_QNAME, this.javaTypes.QNAME_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_DATE_TIME, this.javaTypes.CALENDAR_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_BASE64_BINARY, this.javaTypes.BYTE_ARRAY_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_HEX_BINARY, this.javaTypes.BYTE_ARRAY_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_BASE64, this.javaTypes.BYTE_ARRAY_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_COLLECTION, this.javaTypes.COLLECTION_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_LIST, this.javaTypes.LIST_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_SET, this.javaTypes.SET_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_ARRAY_LIST, this.javaTypes.ARRAY_LIST_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_VECTOR, this.javaTypes.VECTOR_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_STACK, this.javaTypes.STACK_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_LINKED_LIST, this.javaTypes.LINKED_LIST_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_HASH_SET, this.javaTypes.HASH_SET_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_TREE_SET, this.javaTypes.TREE_SET_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_MAP, this.javaTypes.MAP_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_JAX_RPC_MAP_ENTRY, this.javaTypes.JAX_RPC_MAP_ENTRY_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_HASH_MAP, this.javaTypes.HASH_MAP_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_TREE_MAP, this.javaTypes.TREE_MAP_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_HASHTABLE, this.javaTypes.HASHTABLE_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_PROPERTIES, this.javaTypes.PROPERTIES_JAVATYPE);
        this._builtinSchemaTypeToJavaWrapperTypeMap = new HashMap();
        this._builtinSchemaTypeToJavaWrapperTypeMap.put(BuiltInTypes.INT, this.javaTypes.BOXED_INTEGER_JAVATYPE);
        this._builtinSchemaTypeToJavaWrapperTypeMap.put(BuiltInTypes.LONG, this.javaTypes.BOXED_LONG_JAVATYPE);
        this._builtinSchemaTypeToJavaWrapperTypeMap.put(BuiltInTypes.SHORT, this.javaTypes.BOXED_SHORT_JAVATYPE);
        this._builtinSchemaTypeToJavaWrapperTypeMap.put(BuiltInTypes.FLOAT, this.javaTypes.BOXED_FLOAT_JAVATYPE);
        this._builtinSchemaTypeToJavaWrapperTypeMap.put(BuiltInTypes.DOUBLE, this.javaTypes.BOXED_DOUBLE_JAVATYPE);
        this._builtinSchemaTypeToJavaWrapperTypeMap.put(BuiltInTypes.BOOLEAN, this.javaTypes.BOXED_BOOLEAN_JAVATYPE);
        this._builtinSchemaTypeToJavaWrapperTypeMap.put(BuiltInTypes.BYTE, this.javaTypes.BOXED_BYTE_JAVATYPE);
        this._simpleTypeEncoderMap = new HashMap();
        this._simpleTypeEncoderMap.put(BuiltInTypes.STRING, XSDStringEncoder.getInstance());
        this._simpleTypeEncoderMap.put(BuiltInTypes.INTEGER, XSDIntegerEncoder.getInstance());
        this._simpleTypeEncoderMap.put(BuiltInTypes.INT, XSDIntEncoder.getInstance());
        this._simpleTypeEncoderMap.put(BuiltInTypes.LONG, XSDLongEncoder.getInstance());
        this._simpleTypeEncoderMap.put(BuiltInTypes.SHORT, XSDShortEncoder.getInstance());
        this._simpleTypeEncoderMap.put(BuiltInTypes.DECIMAL, XSDDecimalEncoder.getInstance());
        this._simpleTypeEncoderMap.put(BuiltInTypes.FLOAT, XSDFloatEncoder.getInstance());
        this._simpleTypeEncoderMap.put(BuiltInTypes.DOUBLE, XSDDoubleEncoder.getInstance());
        this._simpleTypeEncoderMap.put(BuiltInTypes.BYTE, XSDByteEncoder.getInstance());
    }
}

