/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.util;

import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.ExtendedModelVisitor;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralArrayType;
import com.sun.xml.rpc.processor.model.literal.LiteralAttributeMember;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.sun.xml.rpc.processor.model.literal.LiteralStructuredType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.literal.LiteralTypeVisitor;
import com.sun.xml.rpc.processor.model.soap.RPCRequestOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCRequestUnorderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.model.soap.SOAPTypeVisitor;
import com.sun.xml.rpc.processor.model.soap.SOAPUnorderedStructureType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ClassNameCollector
extends ExtendedModelVisitor
implements SOAPTypeVisitor,
LiteralTypeVisitor {
    private Set _allClassNames;
    private Set _exceptions;
    private Set _conflictingClassNames;
    private Set _visitedTypes;
    private Set _visitedFaults;

    public void process(Model model) {
        try {
            try {
                this._allClassNames = new HashSet();
                this._exceptions = new HashSet();
                this._conflictingClassNames = new HashSet();
                this._visitedTypes = new HashSet();
                this._visitedFaults = new HashSet();
                this.visit(model);
            }
            catch (Exception e) {
                Object var4_3 = null;
                this._allClassNames = null;
                this._exceptions = null;
                this._visitedTypes = null;
                this._visitedFaults = null;
            }
            Object var4_2 = null;
            this._allClassNames = null;
            this._exceptions = null;
            this._visitedTypes = null;
            this._visitedFaults = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._allClassNames = null;
            this._exceptions = null;
            this._visitedTypes = null;
            this._visitedFaults = null;
            throw throwable;
        }
    }

    public Set getConflictingClassNames() {
        return this._conflictingClassNames;
    }

    protected void postVisit(Model model) throws Exception {
        Iterator iter = model.getExtraTypes();
        while (iter.hasNext()) {
            this.visitType((AbstractType)iter.next());
        }
    }

    protected void preVisit(Service service) throws Exception {
        this.registerClassName(service.getJavaInterface().getName());
        this.registerClassName(service.getJavaInterface().getImpl());
    }

    protected void preVisit(Port port) throws Exception {
        this.registerClassName(port.getJavaInterface().getName());
    }

    protected void preVisit(Fault fault) throws Exception {
        if (!this._exceptions.contains(fault.getJavaException())) {
            this._exceptions.add(fault.getJavaException());
            this.registerClassName(fault.getJavaException().getName());
            if (fault.getParentFault() != null) {
                this.preVisit(fault.getParentFault());
            }
            Iterator iter = fault.getSubfaults();
            while (iter != null && iter.hasNext()) {
                Fault subfault = (Fault)iter.next();
                this.preVisit(subfault);
            }
        }
    }

    protected void visitBodyBlock(Block block) throws Exception {
        this.visitBlock(block);
    }

    protected void visitHeaderBlock(Block block) throws Exception {
        this.visitBlock(block);
    }

    protected void visitFaultBlock(Block block) throws Exception {
    }

    protected void visitBlock(Block block) throws Exception {
        this.visitType(block.getType());
    }

    protected void visit(Parameter parameter) throws Exception {
        this.visitType(parameter.getType());
    }

    private void visitType(AbstractType type) throws Exception {
        if (type != null) {
            if (type.isLiteralType()) {
                this.visitType((LiteralType)type);
            } else if (type.isSOAPType()) {
                this.visitType((SOAPType)type);
            }
        }
    }

    private void visitType(LiteralType type) throws Exception {
        type.accept(this);
    }

    public void visit(LiteralSimpleType type) throws Exception {
    }

    public void visit(LiteralSequenceType type) throws Exception {
        this.visitLiteralStructuredType(type);
    }

    public void visit(LiteralAllType type) throws Exception {
        this.visitLiteralStructuredType(type);
    }

    private void visitLiteralStructuredType(LiteralStructuredType type) throws Exception {
        boolean alreadySeen = this._visitedTypes.contains(type);
        if (!alreadySeen) {
            this._visitedTypes.add(type);
            this.registerClassName(type.getJavaType().getName());
            Iterator iter = type.getAttributeMembers();
            while (iter.hasNext()) {
                LiteralAttributeMember attribute = (LiteralAttributeMember)iter.next();
                this.visitType(attribute.getType());
            }
            Iterator iter2 = type.getElementMembers();
            while (iter2.hasNext()) {
                LiteralElementMember element = (LiteralElementMember)iter2.next();
                this.visitType(element.getType());
            }
        }
    }

    public void visit(LiteralArrayType type) throws Exception {
        this.visitType(type.getElementType());
    }

    public void visit(LiteralFragmentType type) throws Exception {
    }

    private void visitType(SOAPType type) throws Exception {
        type.accept(this);
    }

    public void visit(SOAPArrayType type) throws Exception {
        this.visitType(type.getElementType());
    }

    public void visit(SOAPCustomType type) throws Exception {
    }

    public void visit(SOAPEnumerationType type) throws Exception {
        this.visitType(type.getBaseType());
    }

    public void visit(SOAPSimpleType type) throws Exception {
    }

    public void visit(SOAPAnyType type) throws Exception {
    }

    public void visit(SOAPOrderedStructureType type) throws Exception {
        this.visitSOAPStructureType(type);
    }

    public void visit(SOAPUnorderedStructureType type) throws Exception {
        this.visitSOAPStructureType(type);
    }

    public void visit(RPCRequestOrderedStructureType type) throws Exception {
        this.visitSOAPStructureType(type);
    }

    public void visit(RPCRequestUnorderedStructureType type) throws Exception {
        this.visitSOAPStructureType(type);
    }

    public void visit(RPCResponseStructureType type) throws Exception {
        this.visitSOAPStructureType(type);
    }

    private void visitSOAPStructureType(SOAPStructureType type) throws Exception {
        boolean alreadySeen = this._visitedTypes.contains(type);
        if (!alreadySeen) {
            this._visitedTypes.add(type);
            if (this._exceptions.contains(type.getJavaType())) {
                return;
            }
            this.registerClassName(type.getJavaType().getName());
            Iterator iter = type.getMembers();
            while (iter.hasNext()) {
                SOAPStructureMember member = (SOAPStructureMember)iter.next();
                this.visitType(member.getType());
            }
            Iterator iter2 = type.getSubtypes();
            while (iter2 != null && iter2.hasNext()) {
                SOAPStructureType subType = (SOAPStructureType)iter2.next();
                this.visitType(subType);
            }
        }
    }

    private void registerClassName(String name) {
        if (name == null || name.equals("")) {
            return;
        }
        if (this._allClassNames.contains(name)) {
            this._conflictingClassNames.add(name);
        } else {
            this._allClassNames.add(name);
        }
    }
}

