/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.server.http;

import com.sun.xml.rpc.server.http.ServletDelegate;
import com.sun.xml.rpc.util.localization.LocalizableMessageFactory;
import com.sun.xml.rpc.util.localization.Localizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXRPCServlet
extends HttpServlet {
    protected ServletDelegate delegate = null;
    private LocalizableMessageFactory messageFactory;
    private Localizer localizer;
    private static final String DELEGATE_PROPERTY = "delegate";
    private static final String DEFAULT_DELEGATE_CLASS_NAME = "com.sun.xml.rpc.server.http.JAXRPCServletDelegate";
    private static final String EA_CONFIG_FILE_PROPERTY = "configuration.file";
    private static final String EA_DELEGATE_CLASS_NAME = "com.sun.xml.rpc.server.http.ea.JAXRPCServletDelegate";
    public static final String JAXRPC_RI_RUNTIME_INFO = "com.sun.xml.rpc.server.http.info";
    public static final String JAXRPC_RI_PROPERTY_PUBLISH_WSDL = "com.sun.xml.rpc.server.http.publishWSDL";
    public static final String JAXRPC_RI_PROPERTY_PUBLISH_MODEL = "com.sun.xml.rpc.server.http.publishModel";
    public static final String JAXRPC_RI_PROPERTY_PUBLISH_STATUS_PAGE = "com.sun.xml.rpc.server.http.publishStatusPage";
    private static final Log logger = LogFactory.getLog((String)"com.sun.xml.rpc.server.http");

    public void init(ServletConfig servletConfig) throws ServletException {
        this.localizer = new Localizer();
        this.messageFactory = new LocalizableMessageFactory("com.sun.xml.rpc.resources.jaxrpcservlet");
        try {
            String delegateClassName = servletConfig.getInitParameter(DELEGATE_PROPERTY);
            if (delegateClassName == null && servletConfig.getInitParameter(EA_CONFIG_FILE_PROPERTY) != null) {
                delegateClassName = EA_DELEGATE_CLASS_NAME;
            }
            if (delegateClassName == null) {
                delegateClassName = DEFAULT_DELEGATE_CLASS_NAME;
            }
            Class<?> delegateClass = Class.forName(delegateClassName, true, Thread.currentThread().getContextClassLoader());
            this.delegate = (ServletDelegate)delegateClass.newInstance();
            this.delegate.init(servletConfig);
        }
        catch (ServletException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            String message = this.localizer.localize(this.messageFactory.getMessage("error.servlet.caughtThrowableInInit", new Object[]{e}));
            logger.error((Object)message, e);
            throw new ServletException(message);
        }
    }

    public void destroy() {
        if (this.delegate != null) {
            this.delegate.destroy();
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (this.delegate != null) {
            this.delegate.doPost(request, response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (this.delegate != null) {
            this.delegate.doGet(request, response);
        }
    }
}

