/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.server.http.ea;

import com.sun.xml.rpc.server.http.JAXRPCServletException;
import com.sun.xml.rpc.server.http.ea.ImplementorInfo;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class ImplementorRegistry {
    private Map _implementors = new HashMap();
    private static final String PROPERTY_PORT_COUNT = "portcount";
    private static final String PROPERTY_PORT = "port";
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_TIE = "tie";
    private static final String PROPERTY_SERVANT = "servant";

    public ImplementorInfo getImplementorInfo(String name) {
        ImplementorInfo info = (ImplementorInfo)this._implementors.get(name);
        if (info == null) {
            throw new JAXRPCServletException("error.implementorRegistry.unknownName", name);
        }
        return info;
    }

    public boolean containsName(String name) {
        return this._implementors.containsKey(name);
    }

    public Iterator names() {
        return this._implementors.keySet().iterator();
    }

    public void readFrom(String filename) {
        try {
            this.readFrom(new FileInputStream(filename));
        }
        catch (FileNotFoundException e) {
            throw new JAXRPCServletException("error.implementorRegistry.fileNotFound", filename);
        }
    }

    public void readFrom(InputStream inputStream) {
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            inputStream.close();
            int portCount = Integer.parseInt(properties.getProperty(PROPERTY_PORT_COUNT));
            int i = 0;
            while (i < portCount) {
                String portPrefix = PROPERTY_PORT + Integer.toString(i) + ".";
                String name = properties.getProperty(portPrefix + PROPERTY_NAME);
                String tieClassName = properties.getProperty(portPrefix + PROPERTY_TIE);
                String servantClassName = properties.getProperty(portPrefix + PROPERTY_SERVANT);
                if (name == null || tieClassName == null || servantClassName == null) {
                    throw new JAXRPCServletException("error.implementorRegistry.incompleteInformation");
                }
                this.register(name, tieClassName, servantClassName);
                ++i;
            }
        }
        catch (IOException e) {
            throw new JAXRPCServletException("error.implementorRegistry.cannotReadConfiguration");
        }
    }

    public void register(String name, String tieClassName, String servantClassName) {
        Class<?> tieClass = null;
        Class<?> servantClass = null;
        try {
            tieClass = Thread.currentThread().getContextClassLoader().loadClass(tieClassName);
        }
        catch (ClassNotFoundException e) {
            throw new JAXRPCServletException("error.implementorRegistry.classNotFound", tieClassName);
        }
        try {
            servantClass = Thread.currentThread().getContextClassLoader().loadClass(servantClassName);
        }
        catch (ClassNotFoundException e) {
            throw new JAXRPCServletException("error.implementorRegistry.classNotFound", servantClassName);
        }
        this.register(name, new ImplementorInfo(tieClass, servantClass));
    }

    public void register(String name, ImplementorInfo info) {
        if (this._implementors.containsKey(name)) {
            throw new JAXRPCServletException("error.implementorRegistry.duplicateName", name);
        }
        this._implementors.put(name, info);
    }
}

