
/*
 * @(#)FileMenu.java	1.1 11/17/2003
 *
 * Copyright 2003 MakeLogic, Inc. All rights reserved.
 * MakeLogic PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * @(#)FileMenu.java	1.1
 *
 * Author : R.Venkatesh
 * Copyright 2003 MakeLogic. All Rights Reserved.
 *
 * This software is the proprietary information of MakeLogic.
 * Use is subject to license terms.
 *
 */
 
package com.makeLogic.utils;


import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import java.awt.event.ActionListener;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.IOException;

import java.util.EventListener;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

import com.makeLogic.utils.MLInternalFrame;

//..Change Log
//..17th Nov 2003	:	Included VersionManager thread in FileMenu's two Constructors.

/**
 * FileMenu is a ready to use Menu for the MDI(Multiple Document Interface) applications
 * It has the functionality of accessing the JInternalFrame objects in a contianer in the following
 * ways
 *
 * <p>New
 * <p>Open
 * <p>Save
 * <p>SaveAs
 * <p>RecentFiles
 * <p>Exit
 * <p>Display all of them in a flip Menu
 *   
 *
 * @author  R.Venkatesh
 * @version 1.1
 * @see     com.makeLogic.utils
 * @since   MDK1.0
 * 
 */

/**
 * A convenience implementation of FileMenu that creates
 * all MenuItems like <br>New <br>Open<br>Save<br>SaveAs<br>RecentFiles<br> Exit<br>
 * with  their functionality which are required for the FileMenu Creation.<br>
 * FileMenu with all its Functionality can be added easily using 
 *  the following simple code
 * 
 *     <font SIZE="2" face="Courier New">
<p>Example - create a new fileMenu that collects all MenuItems</p>
<p>JDesktopPane desktop = new JDesktopPane();<br>
JMenuBar menuBar = new JMenuBar();<br>
FileMenu fileMenu = new FileMenu(desktop);<br>
menuBar.add(fileMenu);<br>
<br>
&nbsp;</p>
</font>
 * @version 1.1 17/11/2003
 * @author  R.Venkatesh
 * @param   contianer is any java.awt.Container object but this container should be
 * JFrame,JDesktopPane because it  has javax.swing.JInternalFrame objects added to it. 
 * 
 *
 */

 public class FileMenu extends JMenu 
 {
	 //..Container
	 Container container;

	 //..MenuItems
	 NewMenuItem newMenuItem;
	 OpenMenuItem openMenuItem;
	 private static SaveMenuItem saveMenuItem;
	 SaveAsMenuItem saveAsMenuItem;
	 	 
	 //..Menu
	 public static RecentFilesMenuItem recentFilesMenuItem;
	 
	 //..MenuItem
	 ExitMenuItem  exitMenuItem;

	 //..Separators
	 JSeparator   separatorOne;
	 JSeparator   separatorTwo;
	 JSeparator   separatorThree;

	 //..KeyStrokes
	 KeyStroke newMenuItemKeyStroke;
	 KeyStroke openMenuItemKeyStroke;
	 KeyStroke saveMenuItemKeyStroke;
	 KeyStroke saveAsMenuItemKeyStroke;
	 char recentFilesMenuItemKeyStroke;
	 KeyStroke exitMenuItemKeyStroke;
	 

	 //..Hashtables and Vector Declarations
     static Hashtable internalFrameOpenFileNames;
	 static Hashtable internalFrameNewFileNames;
	 static Vector recentFileEntries;

	 //..constants for Maximum File Entries and RecentFiles MenuItem Entries
	 static int maxEntriesInConfFile = 20;
	 static int maxEntriesInRecentFilesMenu = 8;

	 /**
	  * Builds a FileMenu object which must be added to the MenuBar.
	  * Adds the MenuItems to the FileMenu and keeps it ready for use.
	  * @param  container   contianer is any java.awt.Container 
	  * but here container should be JDesktopPane,JFrame,etc., because 
	  * javax.swing.JInternalFrame objects are added to it. 
	  
	  *  <font SIZE="2" face="Courier New">
<p>Example:-<br>
<br>
JDesktopPane desktop = new JDesktopPane();<br>
JMenuBar menuBar = new JMenuBar();<br>
FileMenu fileMenu = new FileMenu(desktop);<br>
menuBar.add(fileMenu);<br>
&nbsp;</p>
</font>
<p><p>
<p>For Example:-<br></p>
 *  See <a href="http://www.makelogic.com/FileMenu/FMSample01.htm">sample</a>


	  * 
	  * 
	  */

	 public FileMenu(Container container)
	 {
		 //..calls super class constructor
		 super("File");

		 //..Sets Mnemonic for FileMenu
		 setMnemonic('F');

		 //continer is assigned with argument container
		 this.container=container;

		 //..Includes VersionManager 
		 VersionManager versionManager=new VersionManager("FM_1.1",false);
		 
		 //..Hashtable
		 internalFrameOpenFileNames = new Hashtable();
		 internalFrameNewFileNames = new Hashtable();

		 //..Vector
		 recentFileEntries=new Vector();

		 //..Create New MenuItem and add it to the FileMenu       
		 newMenuItem= new NewMenuItem(container);
		 add(newMenuItem);

		 //..Create OpenMenuItem and add it to the FileMenu
		 openMenuItem=new OpenMenuItem(container);
		 add(openMenuItem);
         
		// Creates and Adds a separator
		 separatorOne=new JSeparator();
		 add(separatorOne);

         //..Create SaveMenuItem and add it to the FileMenu
		 saveMenuItem=new SaveMenuItem(container);
		 add(saveMenuItem);

		 //..Create SaveAsMenuItem and add it to the FileMenu
		 saveAsMenuItem= new SaveAsMenuItem(container);
		 add(saveAsMenuItem);

		 //..Create and Add a sepataor 
		 separatorTwo=new JSeparator();
		 add(separatorTwo);

         //.. Add a RecenfFiles Menu to the FiLeMenu
		 recentFilesMenuItem=new RecentFilesMenuItem(container);
		 add(recentFilesMenuItem);

         //..Create and Add a sepataor 
		 separatorThree=new JSeparator();
		 add(separatorThree);

		 //..Create ExitMenuItem and add it to the FileMenu
		 exitMenuItem=new ExitMenuItem(container);
		 add(exitMenuItem);

		 //...Update the RecentFilesMenu Item from the files in the conf file
		 FileMenu.updateRecentFilesMenu(FileMenu.recentFilesMenuItem);

	 }

	 /**
	  * 
	  * Builds a FileMenu object with userdefined KeyStrokes.
	  * @param container  Container is any java.awt.Container
	  * but in our case it should be JDesktopPane,JFrame,etc., because javax.swing.JInternalFrames are added to it.
	  * @param newMenuItemKeyStroke  is javax.swing.KeyStroke object.
	  * @param openMenuItemKeyStroke  is javax.swing.KeyStroke object.
	  * @param saveMenuItemKeyStroke  is javax.swing.KeyStroke object.
	  * @param saveAsMenuItemKeyStroke  is javax.swing.KeyStroke object.
	  * @param recentFilesMenuItemKeyStroke  is javax.swing.KeyStroke object.
	  * @param exitMenuItemKeyStroke  is javax.swing.KeyStroke object.
	  * 
	  * 
	  * <p><font face="Courier New" size="2">Example:-<br>
<br>
JDesktopPane desktop = new JDesktopPane();</font></p>
<p><font face="Courier New" size="2"><br>
javax.swing.KeyStroke newKeyStroke=KeyStroke.getKeyStroke('U',java.awt.Event.CTRL_MASK,false);<br>
javax.swing.KeyStroke openKeyStroke=KeyStroke.getKeyStroke('V',java.awt.Event.CTRL_MASK,false);<br>
javax.swing.KeyStroke saveKeyStroke=KeyStroke.getKeyStroke('W',java.awt.Event.CTRL_MASK,false);<br>
javax.swing.KeyStroke saveAsKeyStroke=KeyStroke.getKeyStroke('X',java.awt.Event.CTRL_MASK,false);<br>
javax.swing.KeyStroke recentFilesKeyStroke=KeyStroke.getKeyStroke('Y',java.awt.Event.CTRL_MASK,false);<br>
javax.swing.KeyStroke exitMenuItemKeyStroke=KeyStroke.getKeyStroke('Z',java.awt.Event.CTRL_MASK,false);<br>
<br>
JMenuBar menuBar = new JMenuBar();<br>
<br>
FileMenu fileMenu = new 
FileMenu(desktop,newMenuItemKeyStroke,openMenuItemKeyStroke,saveMenuKeystroke,saveAsMenuItemKeyStroke,recentFileMenuItemKeyStroke,exitMenuItemKeyStroke);<br>
<br>
menuBar.add(fileMenu);<br>
&nbsp;</font></p>
<p><p>
<p>For Example:-<br></p>
 *  See <a href="http://www.makelogic.com/FileMenu/FMSample03.htm">sample</a>

	  */

	 public FileMenu(Container container,KeyStroke newMenuItemKeyStroke,KeyStroke openMenuItemKeyStroke,KeyStroke saveMenuItemKeyStroke,KeyStroke saveAsMenuItemKeyStroke, char recentFilesMenuItemKeyStroke,KeyStroke exitMenuItemKeyStroke)
	 {
		 //..sending container object to the constructor
		 this(container);

		 //..Includes VersionManager 
		 VersionManager versionManager=new VersionManager("FM_1.1",false);
		 

		 //..Assign the NewMenuItemKeyStroke and set the user defined KeyStroke for it
		 this.newMenuItemKeyStroke=newMenuItemKeyStroke;
		 setKeyStrokeForNewMenuItem(newMenuItemKeyStroke);

		//..Assign the openMenuItemKeyStroke and set the user defined KeyStroke for it
		 this.openMenuItemKeyStroke=openMenuItemKeyStroke;
		  setKeyStrokeForOpenMenuItem(openMenuItemKeyStroke);

		//..Assign the SaveMenuItemsKeyStroke and set the user defined KeyStroke for it
		 this.saveMenuItemKeyStroke=saveMenuItemKeyStroke;
		 setKeyStrokeForSaveMenuItem(saveMenuItemKeyStroke);

         //..Assign the SaveAsMenuItemsKeyStroke and set the user defined KeyStroke for it
		 this.saveAsMenuItemKeyStroke=saveAsMenuItemKeyStroke;
		 setKeyStrokeForSaveAsMenuItem(saveAsMenuItemKeyStroke);

		 //..Assign the RecentFilesMenuItemsKeyStroke and set the user defined KeyStroke for it
		 this.recentFilesMenuItemKeyStroke=recentFilesMenuItemKeyStroke;
		 setKeyStrokeForRecentFilesMenuItem(recentFilesMenuItemKeyStroke);

		 //..Assign the ExitMenuItemsKeyStroke and set the user defined KeyStroke for it
		 this.exitMenuItemKeyStroke=exitMenuItemKeyStroke;
		 setKeyStrokeForExitMenuItem(exitMenuItemKeyStroke);

		 //...Update the RecentFilesMenu Item from the files in the conf file
		 FileMenu.updateRecentFilesMenu(FileMenu.recentFilesMenuItem);
	 
	 }

	 /**
	  * sets the userdefined KeyStroke to the NewMenuItem.
	  * @param newMenuItemKeyStroke is any javax.swing.KeyStroke.
	  * <p><font face="Courier New" size="2">Example:-<br>
<br>
JDesktopPane desktop =new JDesktopPane();<br>
FileMenu fileMenu=new FileMenu(desktop); <br>
javax.swing.KeyStroke newMenuItemKeyStroke=KeyStroke.getKeyStroke('U',java.awt.Event.CTRL_MASK,false);<br>
<br>
fileMenu.setKeyStrokeForNewMenuItem(newMenuItemKeyStroke);</font></p>
<p><p>
<p>For Example:-<br></p>
 *  See <a href="http://www.makelogic.com/FileMenu/FMSample02.htm">sample</a>

	  */
	 public void setKeyStrokeForNewMenuItem(KeyStroke  newMenuItemKeyStroke)
	 {
		 //..sets the KeyStroke for the NewMenuItem
		 newMenuItem.setKeyStrokeForNewMenuItem(newMenuItemKeyStroke);

	 }
	 /**
	  * sets the userdefined KeyStroke to the OpenMenuItem.
	  * <p><p>
	  * <p>For Example:-<br></p>
	  * See <a href="http://www.makelogic.com/FileMenu/FMSample02.htm">sample</a>
	  * @param openMenuItemKeyStroke is any javax.swing.KeyStroke.
	  * @see String#For Example
	  * @see #setKeyStrokeForNewMenuItem
	  */
	 public void setKeyStrokeForOpenMenuItem(KeyStroke openMenuItemKeyStroke)
	 {
		 //..sets the KeyStroke for the openMenuItem
		 openMenuItem.setAccelerator(openMenuItemKeyStroke);
	 }
	 /**
	  * sets the userdefined KeyStroke to the SaveMenuItem.
	  * <p><p>
	  * <p>For Example:-<br></p>
	  *  See <a href="http://www.makelogic.com/FileMenu/FMSample02.htm">sample</a>
	  * @param saveMenuItemKeyStroke is any javax.swing.KeyStroke.
	  * @see String#For Example
	  * @see #setKeyStrokeForNewMenuItem
	  */
	 public void setKeyStrokeForSaveMenuItem(KeyStroke saveMenuItemKeyStroke)
	 {
		 //..sets the KeyStroke for the SaveMenuItem
		 saveMenuItem.setAccelerator(saveMenuItemKeyStroke);
	 }
	 /**
	  * sets the userdefined KeyStroke to the SaveAsMenuItem.
	  * <p><p>
	  * <p>For Example:-<br></p>
	  * See <a href="http://www.makelogic.com/FileMenu/FMSample02.htm">sample</a>
	  * @param saveAsMenuItemKeyStroke is any javax.swing.KeyStroke.
	  * @see String#For Example
	  * @see #setKeyStrokeForNewMenuItem
	  */
	 public void setKeyStrokeForSaveAsMenuItem(KeyStroke saveAsMenuItemKeyStroke)
	 {
		 //..sets the KeyStroke for the SaveAsMenuItem
		 saveAsMenuItem.setAccelerator(saveAsMenuItemKeyStroke);
	 }
	 /**
	  * sets the userdefined KeyStroke to the RecentFilesMenuItems.
	  * <p><p>
	  * <p>For Example:-<br></p>
	  * See <a href="http://www.makelogic.com/FileMenu/FMSample02.htm">sample</a>
	  * @param recentFilesMenuItemKeyStroke is any javax.lang.char.
	  */
	 public void setKeyStrokeForRecentFilesMenuItem(char  recentFilesMenuItemKeyStroke)
	 {
		 //..sets the KeyStroke for the RecentFilesMenuItem
		 recentFilesMenuItem.setMnemonic(recentFilesMenuItemKeyStroke);//recentFilesMenuItemKeyStroke);
	 }
	 /**
	  * sets the userdefined KeyStroke to the ExitKeyStroke.
	  * <p><p>
	  * <p>For Example:-<br></p>
	  * See <a href="http://www.makelogic.com/FileMenu/FMSample02.htm">sample</a>
	  * @param exitMenuItemKeyStroke is any javax.swing.KeyStroke.
	  * @see String#For Example
	  * @see #setKeyStrokeForNewMenuItem
	  */
	 public void setKeyStrokeForExitMenuItem(KeyStroke  exitMenuItemKeyStroke)
	 {
		//..sets the KeyStroke for the ExitMenuItem
		exitMenuItem.setAccelerator(exitMenuItemKeyStroke);
	 }

	 //.. client ActionListeners
	 /**
	   *adds the ActionListener to the  NewMenuItem
	   * <p><p>
	   <p>For Example:-<br></p>
	   * See <a href="http://www.makelogic.com/FileMenu/FMSample05.htm">sample</a>
	   @param newMenuItemActionListener is a variable of type ActionListener 
	   @see #disableDefaultNewMenuItemListener
	  */

	 public void addNewMenuItemActionListener(ActionListener newMenuItemActionListener)
	 {
		 //..adds ActionListener to the NewMenuItem
		newMenuItem.addActionListener(newMenuItemActionListener);
	 }
	 /**
	  *adds the ActionListener to the  OpenMenuItem
	  * <p><p>
	  * <p>For Example:-<br></p>
	  * See <a href="http://www.makelogic.com/FileMenu/FMSample05.htm">sample</a>
	  @param openMenuItemActionListener is a variable of type ActionListener 
	  @see #disableDefaultOpenMenuItemListener
	  */
	 public void addOpenMenuItemActionListener(ActionListener openMenuItemActionListener)
	 {
		 //..adds ActionListener to the OpenMenuItem
		 openMenuItem.addActionListener(openMenuItemActionListener);
	 }
	 /**
	  *adds the ActionListener to the  SaveMenuItem
	  * <p><p>
	  * <p>For Example:-<br></p>
	  * See <a href="http://www.makelogic.com/FileMenu/FMSample05.htm">sample</a>
	  @param saveMenuItemActionListener is a variable of type ActionListener 
	  @see #disableDefaultSaveMenuItemListener
	  */
	 public void addSaveMenuItemActionListener(ActionListener saveMenuItemActionListener)
	 {
		//..adds ActionListener to the SaveMenuItem
		saveMenuItem.addActionListener(saveMenuItemActionListener);
	 }
	 /**
	  *adds the ActionListener to the  SaveAsMenuItem
	  * <p><p>
	  * <p>For Example:-<br></p>
	  * See <a href="http://www.makelogic.com/FileMenu/FMSample05.htm">sample</a>
	  @param saveAsMenuItemActionListener is a variable of type ActionListener 
	  @see #disableDefaultSaveAsMenuItemListener
	  */
	 public void addSaveAsMenuItemActionListener(ActionListener saveAsMenuItemActionListener)
	 {
		 //..adds ActionListener to the SaveMenuItem
		 saveAsMenuItem.addActionListener(saveAsMenuItemActionListener);
	 }
	 /**
	  *adds the ActionListener to the  RecentFilesMenuItem
	  * <p><p>
	  * <p>For Example:-<br></p>
	  * See <a href="http://www.makelogic.com/FileMenu/FMSample05.htm">sample</a>
	  @param recentFilesMenuItemActionListener is a variable of type ActionListener 
	  @see #disableDefaultRecentFilesMenuItemListener
	  */
	 public void addRecentFilesMenuItemActionListener(ActionListener recentFilesMenuItemActionListener)
	 {
		 //..adds ActionListener to the RecentFilesMenu
		 recentFilesMenuItem.addActionListener(recentFilesMenuItemActionListener);
	 }
	 /**
	  *adds the ActionListener to the  ExitMenuItem
	  * <p><p>
	  * <p>For Example:-<br></p>
	  * See <a href="http://www.makelogic.com/FileMenu/FMSample05.htm">sample</a>
	  @param exitMenuItemActionListener is a variable of type ActionListener 
	  @see #disableDefaultExitMenuItemListener
	  */
	 public void addExitMenuItemActionListener(ActionListener exitMenuItemActionListener)
	 {
		 //..adds ActionListener to the ExitMenuItem
		 exitMenuItem.addActionListener(exitMenuItemActionListener);
	 }

  //.. Disable Default Listener
	 /** 
	  Disables the default Listener of the NewMenuItem  developed by the
	  *  developer so that user can write his own
	  * Listener and use it for his purpose.
	  * 
	  * 
	  * <p><font face="Courier New" size="2">Example:-</font></p>
<p><font face="Courier New" size="2">The Following code will disable the Default 
Listener developed by the Developer and calls its own Listener<br>
<br>
JMenuBar menuBar =new JMenuBar();<br>
JDesktopPane desktop=new JDesktopPane();<br>
<br>
FileMenu fileMenu=new FileMenu(desktop);<br>
<br>
//..disable default Handlers<br>
fileMenu.disableDefaultNewMenuItemListener();<br>
//..add Listener<br>
fileMenu.addNewMenuItemActionListener(this);<br>
<br>
<br>
//..add the fileMenu object to the JMenuBar<br>
menuBar.add(fileMenu);<br>
//..adds the MenuBar to the frame<br>
setJMenuBar(menuBar);<br>
&nbsp;</font></p>
* <p><p>
<p>For Example:-<br></p>
* See <a href="http://www.makelogic.com/FileMenu/FMSample04.htm">sample</a>

@see #addNewMenuItemActionListener  
	  */

	 public void disableDefaultNewMenuItemListener()
	 {
		 //remove the NewMenuItemListener if it exists
		 newMenuItem.removeActionListener(newMenuItem);
	 }
	 /**
	  * Disables the default Listener of the OpenMenuItem  developed by the
	  * developer so that user can write his own
	  * Listener and use it for his purpose.
	  * <p><p>
	  * <p>For Example:-<br></p>
	  * See <a href="http://www.makelogic.com/FileMenu/FMSample04.htm">sample</a>
	  * @see #addOpenMenuItemActionListener 
	  * @see #disableDefaultNewMenuItemListener 
	  */

	 public void disableDefaultOpenMenuItemListener()
	 {
		 //remove the OpenMenuItemListener if it exists
		 openMenuItem.removeActionListener(openMenuItem);	 
	 }
	 /**
	  * Disables the default Listener of the SaveMenuItem  developed by the
	  * developer so that user can write his own
	  * Listener and use it for his purpose.
	  * <p><p>
	  * <p>For Example:-<br></p>
	  * See <a href="http://www.makelogic.com/FileMenu/FMSample04.htm">sample</a>
	  * @see #addSaveMenuItemActionListener
	  * @see #disableDefaultNewMenuItemListener  
	  */

	 public void disableDefaultSaveMenuItemListener()
	  {
		 //remove the SaveMenuItemListener if it exists
		 saveMenuItem.removeActionListener(saveMenuItem);
	  }
	 /**
	  * Disables the default Listener of the SaveAsMenuItem  developed by the
	  * Listener so that user can write his own
	  * Handler and use it for his purpose.
	  * <p><p>
	  * <p>For Example:-<br></p>
	  * See <a href="http://www.makelogic.com/FileMenu/FMSample04.htm">sample</a>
	  * @see #addSaveAsMenuItemActionListener
	  * @see #disableDefaultNewMenuItemListener 
	  */

	 public void disableDefaultSaveAsMenuItemListener()
	 {
		 //remove the SaveAsMenuItemListener if it exists
		 saveAsMenuItem.removeActionListener(saveAsMenuItem);
	 }
	 /**
	  * Disables the default Listener of the RecentFileMenuItem  developed by the
	  * developer so that user can write his own
	  * Listener and use it for his purpose.
	  * <p><p>
	  * <p>For Example:-<br></p>
	  * See <a href="http://www.makelogic.com/FileMenu/FMSample04.htm">sample</a>
	  * @see #disableDefaultNewMenuItemListener 
	  */

	 public void disableDefaultRecentFilesMenuItemListener()
	 {
		 //remove the RecentFilesMenuItemListener if it exists
		 //recentFilesMenuItem.removeActionListener(recentFilesMenuItem);
		 this.remove(recentFilesMenuItem);
		 this.remove(separatorThree);
	 }
	 /**
	  * Disables the default Listener of the ExitMenuItem  developed by the
	  * developer so that user can write his own
	  * Listener and use it for his purpose.
	  * <p><p>
	  * <p>For Example:-<br></p>
	  * See <a href="http://www.makelogic.com/FileMenu/FMSample04.htm">sample</a>
	  * @see #addExitMenuItemActionListener
	  * @see #disableDefaultNewMenuItemListener 
	  */
	 public void disableDefaultExitMenuItemListener()
	 {
		 //remove the RecentFilesMenuItemListener if it exists
		 exitMenuItem.removeActionListener(exitMenuItem);
	 }

	 //.. GetHashtables
	//..  Get Open HashTable
	  static synchronized Hashtable getInternalFramesOpenFileNamesHashTable()
	 {
		 return internalFrameOpenFileNames;
	 }

	 //..Get OpenFilesVector
	 static synchronized Vector getRecentFileEntriesVector()
	 {
		 return recentFileEntries;
	 }
	 //..Get New HashTabel
	  static synchronized Hashtable getInternalFramesNewFileNamesHashTable()
	 {
		 return internalFrameNewFileNames;
	 }
	//.. Remove InternalFrames from Open and New Hastables

	//.. Removes the InternalFrames and its filepath from Open Hashtable
	 static  void removeOpenFileEntry(MLInternalFrame internalFrame)
	 {
		 internalFrameOpenFileNames.remove(internalFrame);
	 }
	
	 //.. updates the Conf File whenever required
	 static synchronized void updateConfFile()
	 {
		 //..Vector to store FileEntries
		 Vector fileVector=new Vector();

		 //..Vector which holds the FileEntries of the OpendFiles
		 Vector recentFileVector=FileMenu.getRecentFileEntriesVector();

			 try
			 {
				 //..Opens the conf file
				 BufferedReader bufferReader=new BufferedReader(new FileReader("conf.txt"));
				 
				 //..Reads the contents from the file and create a Vector
				 String line=bufferReader.readLine();
				 while(line!=null)
				 {
					 //..adds the File contents to the vector
					 fileVector.add(line);

					 //..reads the next Line
					 line=bufferReader.readLine();
				 }

         		 //.. close the File
				 bufferReader.close();


				 //..Initialize the required variables to null
				 MLInternalFrame tempFrame = null;
				 String fileEntryInOpenHashTable = null;
				 String fileEntryInVector=null;

				 
				 for(int k=0;k<recentFileVector.size();k++)
				 {
						//..File Name from recentFileVector		
					 fileEntryInVector=(String)recentFileVector.get(k);
					 try
					 {
						
						 //..See if that file name is in the 
						 //..Recent files vector
						
						 if(fileVector.contains( fileEntryInVector ))
						 {
							 //..Yes the entry exists 
							 //..Make it the most recent file
							 
		 
							 //..Since the entries in Vector are unique (ie no duplications)
							 //..Get the entry from the vector
							 //..Delete the entry from that position
							 //..Add it at the top
							 
							 //..gets the current index of the file if it is there
							 int index =fileVector.lastIndexOf(fileEntryInVector );

							 //..remove it from that index
							 fileVector.remove(index);
						
							 //..add it to the FirstPosition
							 fileVector.add(fileEntryInVector);

						 }
						 else
						 {
							 //..No the entry does not exist in the 
							 //..Recent files vector

							 //..Just add it at the top
							 fileVector.add(fileEntryInVector);
							
						 }
					 }
					 catch(java.util.NoSuchElementException nsee)
					 {							
						 //..notify to the user by  message box
						//.. nsee.printStackTrace();
						 JOptionPane.showMessageDialog(null,nsee.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
						
					 }
					 
					 					 
				 }
				 try
				 {
					 //..open the conf file in write mode
					 //..now update the conf file
					 //..***Important
					 /*********************************************************************
					  * 
					  *  See to it that the conf file doesn not contain 
					  *  more than 20 entries
					  * 
					  ******************************************************************/
					 //.. open the file in write mode using PrintWriter object
					 PrintWriter fileWriter=new PrintWriter(new BufferedWriter(new FileWriter("conf.txt")));
					 
					 int i=0;

					 //..gets the remaining file entries from the conf file
					 if(fileVector.size()>maxEntriesInConfFile)
					 {
						 i = fileVector.size()-maxEntriesInConfFile;
					 }
					 //..writes the fileentries into the conf file
					 for( ; i < fileVector.size() ; i++)
					 {
						 //gets the fileentry from the vector and writes into a file
						 fileWriter.println(fileVector.get(i));
						 //..flushes the printwriter object
						 fileWriter.flush();
					 }
				 }
				 catch(FileNotFoundException fnfe)
				 {
					 //fnfe.printStackTrace();
					 JOptionPane.showMessageDialog(null,fnfe.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
					 
				 }

				 				 
			 }
			 catch(FileNotFoundException fnfe)
			 {
				 //fnfe.printStackTrace();
			//	 JOptionPane.showMessageDialog(null,fnfe.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);

				 /***************************
				  * 1. Show a message saying that the recent fiels informationa is lost
				  * 2. Tell the user that the application will try to recover
				  * 3. Create a new conf.txt file with no contents in it
				  * 4. Perform the same procedure whenever there is conf.txt file is not found
				  * 
				  */
					//.. sends the Information to the user saying that the recentFile Information is lost
				 JOptionPane.showMessageDialog(null,"Recent Files Information is Lost.Program will try to Recover","MakeLogic:FileMenu",JOptionPane.INFORMATION_MESSAGE );

				 try
				 {
					//..opens the conf file
					 PrintWriter fileWriter=new PrintWriter(new BufferedWriter(new FileWriter("conf.txt")));
				 }
					
				 catch(IOException ioe)
				 {
					 JOptionPane.showMessageDialog(null,ioe.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
				 }


			 }
			 catch(IOException ioe)
			 {
				 //ioe.printStackTrace();
				 JOptionPane.showMessageDialog(null,ioe.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
			 }
				 
	 }

	 static synchronized void updateRecentFilesMenu(RecentFilesMenuItem recentFilesMenu)
	 {
		 //..Remove all menu items inside recentFilesMenu
		 recentFilesMenu.removeAll();

		 //..Read the file and keep adding the MenuItems one by one

		 //open the recentfiles vector
		 Vector fileVector=new Vector();

		 try
		 {
			 //..Opens the conf file
			 BufferedReader bufferReader=new BufferedReader(new FileReader("conf.txt"));
				 
			 //..Reads the contents from the file and create a Vector
			 String line=bufferReader.readLine();
			 while(line!=null)
			 {
				 //..adds the File contents to the vector
				 fileVector.add(line);

				 //..read the next Line
				 line=bufferReader.readLine();
			 }
			 //.. close the File
			 bufferReader.close();
		 }
		 catch(FileNotFoundException fnfe)
		 {
			 //fnfe.printStackTrace();
			 //JOptionPane.showMessageDialog(null,fnfe.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);

			 //To DO

			 /***************************
			  * 1. Show a message saying that the recent fiels informationa is lost
			  * 2. Tell the user that the application will try to recover
			  * 3. Create a new conf.txt file with no contents in it
			  * 4. Perform the same procedure whenever there conf.txt file is not found
			  * 
			  */
			 //.. sends the Information to the user saying that the recentFile Information is lost
			 JOptionPane.showMessageDialog(null,"Recent File Information is Lost.Program will try to Recover","MakeLogic:FileMenu",JOptionPane.INFORMATION_MESSAGE );

			 try
			 {
					//..opens the conf file
				 PrintWriter fileWriter=new PrintWriter(new BufferedWriter(new FileWriter("conf.txt")));
			 }
			
			 catch(IOException ioe)
			 {
				 JOptionPane.showMessageDialog(null,ioe.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
			 }
		 }
		 catch(IOException ioe)
		 {
			 //ioe.printStackTrace();
			 JOptionPane.showMessageDialog(null,ioe.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
		 }

		 //..Now add the menu item components to the recent files menu
		 JMenuItem tempItem = null;

		 //int i = fileVector.size()- maxEntriesInRecentFilesMenu;
		 try
		 {
			 for(int i=fileVector.size()-1 ; i>=fileVector.size()-maxEntriesInRecentFilesMenu ; i--)
			 {
				 //..Debug
				// System.out.println("\t\tAdding : "+i+" . "+fileVector.get(i));
				 tempItem = new JMenuItem((String)fileVector.get(i));

				 //..Add handler to the tempItem
				 tempItem.addActionListener(recentFilesMenu);

				 //..Now add the menu item to the recent files menu
				 recentFilesMenu.add(tempItem);
			 }
		 }
		 catch(ArrayIndexOutOfBoundsException aiobe)
		 {
			 //..Do nothing
		 }
		
	 }

	 /**
	  * gets the MaxEntries in Conf File
	  * <p><p>
	  * <p>For Example:-<br></p>
	  * See <a href="http://www.makelogic.com/FileMenu/FMSample09.htm">sample</a>
	  * @return maxEntriesInConfFile
	  */
	 //..returns Maximum Entries that can be kept in Conf File 
	 public int getMaxEntriesInConfFile()
	 {
		 return maxEntriesInConfFile;
	 }

	 
	 /**
	  * gets the MaxEntries in RecentFilesMenu
	  * <p><p>
	  * <p>For Example:-<br></p>
	  * See <a href="http://www.makelogic.com/FileMenu/FMSample09.htm">sample</a>
	  * @return maxEntriesInRecentFileMenu
	  */
	 //..returns Maximum Entries that can be kept in RecentFilesMenu
	 public int getMaxEntriesInRecentFilesMenu()
	 {
		return maxEntriesInRecentFilesMenu;
	 }

	 /**
	  * sets the MaxEntries in Conf File
	  * <p><p>
	  * <p>For Example:-<br></p>
	  * See <a href="http://www.makelogic.com/FileMenu/FMSample09.htm">sample</a>
	  * @param maxEntriesInRecentConfFile is an int
	  */
	 //..set functions for maxEntriesInConfFile and maxEntriesInRecentFilesMenu
	 public void setMaxEntriesInConfFile(int maxEntriesInConfFile)
	 {
		 //.. Max Entries in Conf File should not be negative
		 if(maxEntriesInConfFile<0) 
		 {
			 //..if maxEntriesInConfFile is negative set maxEntriesInConfFile to 20
			 this.maxEntriesInConfFile=20;
		 }
		 this.maxEntriesInConfFile=maxEntriesInConfFile;
		
		 
	 }

	 /**
	  * sets the MaxEntries in RecentFile Menu
	  * <p><p>
	  * <p>For Example:-<br></p>
	  * See <a href="http://www.makelogic.com/FileMenu/FMSample09.htm">sample</a>
	  * @param maxEntriesInRecentFilesMenu is an int
	  */
	 public void setMaxEntriesInRecentFilesMenu(int maxEntriesInRecentFilesMenu)
	 {
		 //.. Max Entries in RecentFiles Menu should not be negative
		 if(maxEntriesInRecentFilesMenu<0)
		 {
			/* if maxEntriesInRecentFilesMenu is negative  
			 * set maxEntriesInConfFile to 8*/
			this.maxEntriesInRecentFilesMenu=4;
		 }

		 //.. gets the MaxEntries in Conf File
		 int maxEntriesInConfFile=getMaxEntriesInConfFile();

		 //..checks MaxEntries in RecentFiles Menu is lessthan Max Entries in Conf File
		 if(maxEntriesInRecentFilesMenu<maxEntriesInConfFile)
		 {
			 this.maxEntriesInRecentFilesMenu=maxEntriesInRecentFilesMenu;
		 }
		 else
		 {
			 /*.if MaxEntries in Recent Files Menu is greater than 
			  * MaxEntries in Recent Files, set MaxEntries in Recent Files to
			  * MaxEntries in ConfFile.
			  */
			 this.maxEntriesInRecentFilesMenu=maxEntriesInConfFile;
		 }
	 }

	 //..returns the WindowListener
	 /**
	  * returns the WindowListener which handles the windowclosing<br>
	  * event of the Window object, It takes care of File Saving,etc., <br>
	  * before closing.The user can directly call it in
	  * his addwindowListener() method;
	  * <p><p>
	  * <p>For Example:-<br></p>
	  * See <a href="http://www.makelogic.com/FileMenu/FMSample0.htm">sample</a>
	  */
	 public WindowListener getDefaultClosingListener()
	 {
		 //..creates WindowsListener class
	   WindowAdapter windowAdapter=new WindowAdapter()
	   {
		   public void windowClosing(WindowEvent evt)
		   {
			   //..calls the exitMenuItems actionPerformed method
			   //..It cares of saving the Files before closing,etc..,
			   exitMenuItem.actionPerformed(null);
		   }

	   };
		 //..returns windowsListener
		return windowAdapter;
	 }

	 
	 
	
	 //..Get NewMenuItem
	 /**
	  * returns the NewMenuItem Object
	  @return newMenuItem
	  */
	 //..returns newMenuItem
	 public JMenuItem getNewMenuItem()
	 {
		 return newMenuItem;
	 }

	 //..Get OpenMenuItem
	 /**
	  * returns the JMenuItem Object
	  @return OpenMenuItem
	  */
	//..returns OpenMenuItem
	 public JMenuItem getOpenMenuItem()
	 {
		 return openMenuItem;
	 }

	 //..Get SaveMenuItem
	 /**
	  * returns the JMenuItem Object
	  @return SaveMenuItem
	  */

	 public static JMenuItem getSaveMenuItem()
	 {
		 return saveMenuItem;
	 }

	 //..Get SaveAsMenuItem
	 /**
	  * returns the JMenuItem Object
	  @return SaveAsMenuItem
	  */
	//..returns SaveAsMenuItem
	 public JMenuItem getSaveAsMenuItem()
	 {
		 return saveAsMenuItem;
	 }

	 //..Get RecentFilesMenuItem
	 /**
	  * returns the JMenu Object
	  @return RecentFilesMenuItem
	  */
	 //..returns RecentFilesMenuItem
	 public static JMenu getRecentFilesMenuItem()
	 {
		 return recentFilesMenuItem;
	 }

	 //..Get ExitMenuItem
	 /**
	  * returns the JMenuItem Object
	  @return ExitMenuItem
	  */
	 //..returns ExitMenuItem
	 public JMenuItem getExitMenuItem()
	 {
		 return exitMenuItem;
	 }

 }