/*
 * @(#)MLInternalFrameClosingHandler	1.1 11/17/2003
 *
 * Copyright 2003 MakeLogic, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.makeLogic.utils;


import java.awt.Container;
import java.awt.Component;

import java.beans.PropertyVetoException;

import java.io.FileNotFoundException;
import java.io.IOException;

import java.io.File;
import java.io.DataOutputStream;
import java.io.FileOutputStream;

import java.util.Hashtable;
import java.util.Vector;

import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

import com.makeLogic.utils.MLInternalFrame;
import com.makeLogic.utils.FileMenu;

/**
 * This Class contains all the methods which are necessary 
 * to execute when the closing event of the JInternalFrame(file) fires.<br>
 * It takes care of saving the file if it is not saved , etc,,.
 * 
 */

public class InternalFrameClosingHandler extends InternalFrameAdapter
{
	//..Declarations
	Container container;
	Hashtable internalFramesOpenFileNames;
	MLInternalFrame internalFrame;

	//.. constructer for InternalFrameClosing Handler

	public InternalFrameClosingHandler(Container container, Hashtable internalFramesOpenFileNames, MLInternalFrame internalFrame)
	 {
		//..container
	 this.container = container;
		//..Hashtable
	 this.internalFramesOpenFileNames = internalFramesOpenFileNames;
		//..MLInternalFrame
	 this.internalFrame = internalFrame;
	 }

	public void internalFrameClosing(InternalFrameEvent e)
	{
		//...Create a method that writes information into the conf file
		//...Call that method from here
		
		//..updates the conf File
		FileMenu.updateConfFile();

		//..now update the RecentFilesMenuToo
		FileMenu.updateRecentFilesMenu(FileMenu.recentFilesMenuItem);

		//..OpenFilesHashtable
		Hashtable tempOpenMenuHash = FileMenu.getInternalFramesOpenFileNamesHashTable();
		//..NewFiles Hashtable
		Hashtable tempNewMenuHash =FileMenu.getInternalFramesNewFileNamesHashTable();
		//..OpenFilesVector
		Vector    recentFileEntries=FileMenu.getRecentFileEntriesVector();

		//..If contents in the internal frame are not changed
		//..close it without giving any warning
		if(internalFrame.getChanged() == false)
		{
			//.. close the InternalFrame without saving and remove the framelistener
			try
			{
				//..Remove the Listener
				internalFrame.removeInternalFrameListener(this);
				//..fires the closing event 
				internalFrame.setClosed(true);
			}
			catch(java.beans.PropertyVetoException pve)
			{
				//pve.printStackTrace();
				JOptionPane.showMessageDialog(null,pve.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
			}
			//..Remove the entry from any of the hashtable that it is present in
			//TO DO
			//
			//..Search OpenMenuHash first

			/*..Debug
			 * The following code is commented because the updateConf method will copy the 
			 * entries of the Hashtable.
			*/
			/*if(tempOpenMenuHash.containsKey(internalFrame))
			{
				//..remove the internalFrame filePath from the Hashtable
				tempOpenMenuHash.remove(internalFrame);
			}*/
		
			//..Search NewMenuHash Next
			if(tempNewMenuHash.containsKey(internalFrame))
			{
				//..remove the internalFrame filePath from the Hashtable
				tempNewMenuHash.remove(internalFrame);
			}

			
			//..return
			return;
		}

		
		
		//..Do this if the frame belongs to open hash table
		if(tempOpenMenuHash.containsKey(internalFrame))
		{
			//..InternalFrame Title
			String fileTitle=internalFrame.getTitle().substring(0,internalFrame.getTitle().length()-1);

			//..Open a message box prompting the user to save ?
			int result=JOptionPane.showConfirmDialog(internalFrame, 
				"Do You want to Save ?"+fileTitle, "Confirm Dialog", JOptionPane.YES_NO_CANCEL_OPTION);

			//..If OK - SAVE and CLOSE
			if(result==JOptionPane.YES_OPTION)
			{
				String FileName=(String)tempOpenMenuHash.get(internalFrame);
				//..Debug
				

				try
				{
					//..Open File in Output mode 
					DataOutputStream outputStream=new DataOutputStream(new FileOutputStream(FileName));
					
					//..Gets the EditorPane from the internalFrames
					Component[] jsp = internalFrame.getContentPane().getComponents();
					JScrollPane jspn = (JScrollPane)internalFrame.getContentPane().getComponent(0);
					JViewport jvp  = (JViewport)jspn.getViewport();
					JEditorPane jep = (JEditorPane)jvp.getView();
					
				
					try
					{
						//..writes the EditorPane contents into a File
                        outputStream.writeBytes(jep.getText());
					}
					catch(IOException ioexcep)
					{
						//ioexcep.printStackTrace();
						JOptionPane.showMessageDialog(null,ioexcep.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
					}
						
				}
				catch(FileNotFoundException fnfe)
				{

					//fnfe.printStackTrace();
					JOptionPane.showMessageDialog(null,fnfe.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
				}

			//	FileMenu.removeOpenFileEntry(internalFrame);

				//..Now close the internal frame
				try
				{
					//..removes the Listener and fires the closing event
					internalFrame.removeInternalFrameListener(this);
					internalFrame.setClosed(true);
				}
				catch(java.beans.PropertyVetoException pve)
				{
					//pve.printStackTrace();
					JOptionPane.showMessageDialog(null,pve.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
				}
			
			}
				//..Do nothing. Close the JOptionPane
			else if( result==JOptionPane.CANCEL_OPTION)
			{
				//..If CANCEL - DO NOT SAVE and DO NOT CLOSE
				//Keep the internal frame still opened

				return;
			}
				//..Do not save the file. Just close it.
			else if(result==JOptionPane.NO_OPTION)
			{
				//.. close the InternalFrame without saving and remove the closing listener
				try
				{
					//..removes the Listener
					internalFrame.removeInternalFrameListener(this);

					//..fires the closing Event
					internalFrame.setClosed(true);
				}
				catch(PropertyVetoException pve)
				{
					//pve.printStackTrace();
					JOptionPane.showMessageDialog(null,pve.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
				}
				
			
			}
			
			
		}//..if Open Menu HashTable
		else
   		{

			//..InternalFrame Title
			String fileTitle=internalFrame.getTitle().substring(0,internalFrame.getTitle().length()-1);
			
			//..Open a message box prompting the user to save ?
			int result=JOptionPane.showConfirmDialog(internalFrame, 
				"Do You want to Save ?"+fileTitle, "Confirm Dialog", JOptionPane.YES_NO_CANCEL_OPTION);

			//..Getst the EditorPane from the internalFrame
			Component[] jsp = internalFrame.getContentPane().getComponents();
			JScrollPane jspn = (JScrollPane)internalFrame.getContentPane().getComponent(0);
			JViewport jvp  = (JViewport)jspn.getViewport();
			JEditorPane jep = (JEditorPane)jvp.getView();

				//..If OK
			if(result==JOptionPane.YES_OPTION)
			{
				//..gets the FileName from the New hashtable
				String newFileName=(String)tempNewMenuHash.get(internalFrame);

				//..creates the File Object
				File currentFile=new File(newFileName+".txt");
				
				//..Opens a FileChooser
				JFileChooser fileChooser =new JFileChooser();

				//.. set the file path in the FileChooser
				fileChooser.setSelectedFile(currentFile);

				//.. show the FileChooser
				int response=fileChooser.showSaveDialog(container);

				//..if Save Button is clicked save the new Frame in the given path

				if(response==JFileChooser.APPROVE_OPTION)
				{
					
					try
					 {
						//.. Open the file in output mode
                        DataOutputStream outputStream= new DataOutputStream(new FileOutputStream(fileChooser.getSelectedFile().getAbsolutePath()));

						//.. write the EditorPane contents into a file
						outputStream.writeBytes(jep.getText());
					 }
					 catch(FileNotFoundException fnfe)
					 {
					 //fnfe.printStackTrace();
						JOptionPane.showMessageDialog(null,fnfe.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
					 }
					 catch(IOException ioexcep)
					 {
					 //ioexcep.printStackTrace();
						JOptionPane.showMessageDialog(null,ioexcep.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
					 }

					//.. close the Internal Frame after saving
					try
					{
						//.. remove the frame Listener
						internalFrame.removeInternalFrameListener(this);

						//..close the InternalFrame
						internalFrame.setClosed(true);
					}
					catch(PropertyVetoException pve)
					{
						//pve.printStackTrace();
						JOptionPane.showMessageDialog(null,pve.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
					}
					

					//..remove the internalFrame filePath from the Hashtable
					tempNewMenuHash.remove(internalFrame);

					//..add the internalFrame filePath into open Hashtable
					tempOpenMenuHash.put(internalFrame,fileChooser.getSelectedFile().getAbsolutePath());

					//..add the filepath to the recent file vector
					recentFileEntries.add(fileChooser.getSelectedFile().getAbsolutePath());
				}
			}
			else if( result==JOptionPane.CANCEL_OPTION)
			{
				//..If CANCEL - DO NOT SAVE and DO NOT CLOSE
				//Keep the internal frame still opened

				return;
			}
				//..Do not save the file. Just close it.
			else if(result==JOptionPane.NO_OPTION)
			{
				//.. close the InternalFrame without saving and remove the closing listener
				try
				{	//..removes the Listener
					internalFrame.removeInternalFrameListener(this);
					
					//..fires the closing Event
					internalFrame.setClosed(true);
				}
				catch(PropertyVetoException pve)
				{
					//pve.printStackTrace();
					JOptionPane.showMessageDialog(null,pve.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
				}
								
					//..remove the internalFrame filePath from the  New Hashtable
					tempNewMenuHash.remove(internalFrame);
				

			}
		}
		
		

	}//..InternalFrameClosing method ends here

}