/*
 * @(#)NewMenuItem.java	1.1 11/17/2003
 *
 * Copyright 2003 MakeLogic, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * @(#)NewMenuItem.java	1.1
 *
 * Author : R.Venkatesh
 * Copyright 2003 MakeLogic. All Rights Reserved.
 *
 * This software is the proprietary information of MakeLogic.
 * Use is subject to license terms.
 * 
 */

package com.makeLogic.utils;

import java.awt.Container;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.io.File;

import javax.swing.JMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

import java.util.Hashtable;

import com.makeLogic.utils.MLInternalFrame;

/**
 * NewMenuItem is one of the MenuItems of FileMenu.<br>
 * Itis to Open a new JInternalFrame whenever user clicks on it.
 */
public class NewMenuItem extends JMenuItem implements ActionListener
{	
	//.. variables declaration
	Container container;
	Hashtable internalFramesNewFileNames;
	JEditorPane editorPane;

	
	static int index=0;
	
	NewMenuItem(Container container)
	{	
		//..calls the super class constructor with string as parameter
		super("New");

		//..sets the Default accelerator as CTRL+N for the NewMenuItem
		setAccelerator(KeyStroke.getKeyStroke('N',java.awt.Event.CTRL_MASK,false));

		//..Adds the ActionListerner to handle the Event
		addActionListener(this);

		this.container=container;
	}


	public void setKeyStrokeForNewMenuItem(KeyStroke newMenuItemKeyStroke)
	{
		//..sets user defined Accelerator for the NewMenuItem
		setAccelerator(newMenuItemKeyStroke);
	}
	public void actionPerformed(ActionEvent evt)
	{
		/* Opens a New JInternalFrame when this event is generated */

		//..static index variable to assigne sequence to the title
		index=++index;

		String DefaultFrameFileName=new String("MakeLogic-DefaultInternalFrame"+index);

		File DefaultFile=new File(DefaultFrameFileName);
		
		//..String Buffer of size 10
		StringBuffer nullStringBuffer=new StringBuffer(10);

		//..Set null to the StringBuffer
		nullStringBuffer.append("");
		
		//..creates a MLInternalFrame
		MLInternalFrame internalFrame = new  MLInternalFrame(container,DefaultFile,nullStringBuffer);

				
		//.. gets Hashtable of the NewInternalFrames
		internalFramesNewFileNames=FileMenu.getInternalFramesNewFileNamesHashTable();

		//..puts the filepath into the Hashtable with internalFrame as key
		internalFramesNewFileNames.put(internalFrame,DefaultFile.getAbsolutePath());

		//..Adds the closing internalFrameListener
		internalFrame.addInternalFrameListener(new InternalFrameClosingHandler(container,internalFramesNewFileNames,internalFrame));

		
	}
	

	
}