/*
 * @(#)SaveMenuItem.java	1.1 11/17/2003
 *
 * Copyright 2003 MakeLogic, Inc. All rights reserved.
 * MakeLogic PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * @(#)SaveMenuItem.java	1.1
 *
 * Author : R.Venkatesh
 * Copyright 2003 MakeLogic. All Rights Reserved.
 *
 * This software is the proprietary information of MakeLogic.
 * Use is subject to license terms.
 * 
 *
 */

package com.makeLogic.utils;

import java.awt.Component;
import java.awt.Container;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.io.File;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;


import java.util.Hashtable;
import java.util.Vector;

import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JEditorPane;
import javax.swing.JViewport;

import javax.swing.KeyStroke;


import com.makeLogic.utils.MLInternalFrame;

/**
 * Save MenuItem is one of the MenuItems of FileMenu.<br>
 * It saves the contents of a selected File.
  */
public class SaveMenuItem extends JMenuItem implements ActionListener
{
	//.. Declaration
	Container container;
	MLInternalFrame internalFrame;
	int result;

	SaveMenuItem(Container container)
	{	
		//..calls the super class constructor 
		super("Save");

		//..sets the Default KeyStroke as CTRL+S to the SaveMenuItem
		setAccelerator(KeyStroke.getKeyStroke('S',java.awt.Event.CTRL_MASK,false));

		//.. adds the Listenerclass to the SaveMenuItem
		addActionListener(this);

		this.container=container;
		
	}   
	public void setKeyStrokeForSaveMenuItem(KeyStroke saveMenuItemKeyStroke)
	{
		//.. sets the user defined accelerator to the SaveMenuItem
		setAccelerator(saveMenuItemKeyStroke);
	}
	public void actionPerformed(ActionEvent evt)
	{
		

		//.. gets the OpenFileEntries into the Hastable		
		Hashtable tempOpenMenuHash = FileMenu.getInternalFramesOpenFileNamesHashTable();

		//..gets the NewFileEntries into the Hashtable
		Hashtable tempNewMenuHash =FileMenu.getInternalFramesNewFileNamesHashTable();

		//..get the OpenFileEntries into RecentFiles Vector
		Vector RecentFileEntries=FileMenu.getRecentFileEntriesVector();

		//.. gets the InternalFrames
		Component componentInternalFrames[]=container.getComponents();

		//.. stores the InternalFrames in a InternalFrames array
		MLInternalFrame internalFrames[]=new MLInternalFrame[componentInternalFrames.length];


		//.. loop until the Number of Internalframes are Present
  			for(int i=0;i<componentInternalFrames.length;i++)
			{
				try
				{
					//..gets the MLInternalFrames from the component array
					internalFrames[i]=(MLInternalFrame)componentInternalFrames[i];
				}
				catch(ClassCastException cce)
				{
					//..Do nothing
					//..Debug
					//System.out.println(cce);
					JOptionPane.showMessageDialog(null,cce.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
				}
				
				//..searches for the Active InternalFrame
				if(internalFrames[i].isSelected()==true)
				{
					//..gets the Active InternalFrame
					this.internalFrame=internalFrames[i];

					//.. Do nothing if the Frame contents are not changed 

					if(internalFrame.getChanged() == false)
					{
						//..Do Nothing when the Frame contents are not changed

						//..return
						return;
					}
					
					//..gets the EditorPane from the InternalFrame
					Component[] jsp = internalFrame.getContentPane().getComponents();
					JScrollPane jspn = (JScrollPane)internalFrame.getContentPane().getComponent(0);
					JViewport jvp  = (JViewport)jspn.getViewport();
					JEditorPane jep = (JEditorPane)jvp.getView();

					//..Do this if the frame belongs to open hash table
					if(tempOpenMenuHash.containsKey(internalFrame))
					{
						//..get the FileName of the Opend FileName		
						String FileName=(String)tempOpenMenuHash.get(internalFrames[i]);

						
						try
						{
							//.. opens a File in output Mode for writing data into a File
							DataOutputStream outputStream=new DataOutputStream(new FileOutputStream(FileName));
							
							try
							{
								//..writes the contents of the editorpane into the File
								outputStream.writeBytes(jep.getText());

								//..change the flag to saved mode
								internalFrame.setChanged(false);

								//.. removes '*' from the Frame Title 
								if(internalFrame.getTitle().endsWith("*"))
								{
									internalFrame.setTitle(internalFrame.getTitle().substring(0,internalFrame.getTitle().length()-1));
								}
											
							}
							catch(IOException ioexcep)
							{
								//ioexcep.printStackTrace();
								JOptionPane.showMessageDialog(null,ioexcep.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
							}										
										
						}
						catch(FileNotFoundException fnfe)
						{

							//fnfe.printStackTrace();
							JOptionPane.showMessageDialog(null,fnfe.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
						}

					}//..if Open Menu HashTable
					else
					{
						//..if the InternalFrame is in NewHastable
						String newFileName=(String)tempNewMenuHash.get(internalFrame);
						
						//..set current File as newFileNeme.txt
						File currentFile=new File(newFileName+".txt");

						//..Open a FileChooser
						JFileChooser fileChooser =new JFileChooser();

						//..Fire the property change event
						firePropertyChange("FileChooserOpened",fileChooser,null);

						//.. set the file path in the FileChooser
						fileChooser.setSelectedFile(currentFile);

						//.. show the FileChooser
						int response=fileChooser.showSaveDialog(container);

						//..if Save Button is clicked save the new Frame in the given path
						if(response==JFileChooser.APPROVE_OPTION)
						{
					
							try
							{
								//.. Open the file in output mode
								DataOutputStream outputStream= new DataOutputStream(new FileOutputStream(fileChooser.getSelectedFile()));

								//.. write the EditorPane contents into a file
								outputStream.writeBytes(jep.getText());

								//..change the flag to saved mode
								internalFrame.setChanged(false);

								//.. removes '*' from the Frame Title 
								if(internalFrame.getTitle().endsWith("*"))
								{
									internalFrame.setTitle(internalFrame.getTitle().substring(0,internalFrame.getTitle().length()-1));
								}

								internalFrame.setTitle(fileChooser.getSelectedFile().getAbsolutePath());

								//..remove the InternalFrame from the New Hashtable
								tempNewMenuHash.remove(internalFrame);

								//..Add the InternalFrame into Open Hashtable
								tempOpenMenuHash.put(internalFrame,fileChooser.getSelectedFile().getAbsolutePath());

								//..Adds the OpenFileEntrie to a Vector
								RecentFileEntries.add(fileChooser.getSelectedFile().getAbsolutePath());

								
							}
							catch(FileNotFoundException fnfe)
							{
								//fnfe.printStackTrace();
								JOptionPane.showMessageDialog(null,fnfe.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
							}
							catch(IOException ioexcep)
							{
								//ioexcep.printStackTrace();
								JOptionPane.showMessageDialog(null,ioexcep.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
							}

						}//..end-if
					}//..end -else i.e. it is a new Frame


				}//..end -if of selected Frame
			
			}//.. for loop end
		
	}//.. end of Event Handler

	
}