/*
 * @(#)AddFileMenuExample.java 
 *
 * Product Of	: MakeLogic
 * URL			: http://www.makelogic.com
 * Author		: R.Venkatesh
 * Date			: 18 June, 2003
 * email		: venkat@makelogicmldb.com
 * 
 * Please feel free to use this Sample Code in your applications.
 */


/*
 * This sample Application Demonstrates how to use the FileMenu Object and add 
 * it into your menuBar.
 */

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JMenuBar;

import com.makeLogic.utils.FileMenu;

class AddFileMenu extends JFrame 
{
	JMenuBar menuBar;
	JDesktopPane desktop;

	AddFileMenu(String title)
	{
		//..calls the super class constructor
		super(title);
		//..MenuBar
		menuBar = new JMenuBar();
		//..Container
		desktop=new JDesktopPane();
		
		//..Gets the ContentPane of the JFrame and adds the container to the center
		getContentPane().add("Center",desktop);

		//..Creates a FileMenu Object
		//..The following two lines of code is sufficient to create complete FileMenu Object
		//..and adds it to the MenuBar
		FileMenu fileMenu=new FileMenu(desktop);

		//..add the fileMenu object to the JMenuBar
		menuBar.add(fileMenu);

		//..adds the MenuBar to the frame
		setJMenuBar(menuBar);

		//..window closing Listener
		addWindowListener(fileMenu.getDefaultClosingListener());
				
	}
	
}
public class AddFileMenuExample
{

	public static void main(String args[])
	{
		AddFileMenu addFileMenu=new AddFileMenu("Create and Add FileMenu Example");
		addFileMenu.show();
		addFileMenu.setSize(500,500);
		addFileMenu.validate();
	}

}


