
/*
 * @(#)ChangeAcceleratorsExample.java	
 *
 * Product Of	: MakeLogic
 * URL			: http://www.makelogic.com
 * Author		: R.Venkatesh
 * Date			: 18 June, 2003
 * email		: venkat@makelogicmldb.com
 * 
 * Please feel free to use this Sample Code in your applications.
 */

/*
 * This sample Application will Demonstrate how to use the 
 * SetKeyStroke method which sets the Accelerator for the 
 * MenuItems of the FileMenu Object. 
 * 
 * similarly you can set Accelerator for the other MenuItems
 * using its corresponding SetKeyStroke method except for the 
 * RecentFiles MenuItem.
 */

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;

import com.makeLogic.utils.FileMenu;

class ChangeAccelerators extends JFrame 
{
	JMenuBar menuBar;
	JDesktopPane desktop;
	KeyStroke newMenuItemKeyStroke;

	ChangeAccelerators(String title)
	{
		//..calls the super class constructor
		super(title);
		//..MenuBar
		menuBar = new JMenuBar();
		//..Container
		desktop=new JDesktopPane();
		
		//..Gets the ContentPane of the JFrame and adds the container to the center
		getContentPane().add("Center",desktop);

		//..Creates a FileMenu Object
		FileMenu fileMenu=new FileMenu(desktop);

		//..add the fileMenu object to the JMenuBar
		menuBar.add(fileMenu);

		//..Create KeyStroke
		newMenuItemKeyStroke=KeyStroke.getKeyStroke('U',java.awt.Event.CTRL_MASK,false);

		//..set userdefined KeyStroke to the NewMenuItem
		fileMenu.setKeyStrokeForNewMenuItem(newMenuItemKeyStroke);

		//..adds the MenuBar to the frame
		setJMenuBar(menuBar);

		//..window closing Listener
		addWindowListener(fileMenu.getDefaultClosingListener());
				
	}
	
}
public class ChangeAcceleratorsExample
{

	public static void main(String args[])
	{
		ChangeAccelerators changeAccelerator=new ChangeAccelerators("ChangeAcceleratorsExample");
		changeAccelerator.show();
		changeAccelerator.setSize(500,500);
		changeAccelerator.validate();
	}

}


