
/*
 * @(#)AddFileMenuConstructorExample.java	
 *
 * Product Of	: MakeLogic
 * URL			: http://www.makelogic.com
 * Author		: R.Venkatesh
 * Date			: 18 June, 2003
 * email		: venkat@makelogicmldb.com
 * 
 * Please feel free to use this Sample Code in your applications.
 */

/*
 * This sample Application  Demonstrates how to use the 
 * second Constructor of the FileMenu Object. 
 */
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;

import com.makeLogic.utils.FileMenu;

class AddFileMenuConstructor extends JFrame 
{
	JMenuBar menuBar;
	JDesktopPane desktop;

	KeyStroke newMenuItemKeyStroke;
	KeyStroke openMenuItemKeyStroke;
	KeyStroke saveMenuItemKeyStroke;
	KeyStroke saveAsMenuItemKeyStroke;
	char recentFilesMenuItemKeyStroke;
	KeyStroke exitMenuItemKeyStroke;


	AddFileMenuConstructor(String title)
	{
		//..calls the super class constructor
		super(title);
		//..MenuBar
		menuBar = new JMenuBar();
		//..Container
		desktop=new JDesktopPane();
		
		//..Gets the ContentPane of the JFrame and adds the container to the center
		getContentPane().add("Center",desktop);

		//..create KeyStrokes for the MenuItems
		newMenuItemKeyStroke=KeyStroke.getKeyStroke('N',java.awt.Event.CTRL_MASK,false);
		openMenuItemKeyStroke=KeyStroke.getKeyStroke('O',java.awt.Event.CTRL_MASK,false);
		saveMenuItemKeyStroke=KeyStroke.getKeyStroke('S',java.awt.Event.CTRL_MASK,false);
		saveAsMenuItemKeyStroke=KeyStroke.getKeyStroke('A',java.awt.Event.CTRL_MASK,false);
		recentFilesMenuItemKeyStroke='R';
		exitMenuItemKeyStroke=KeyStroke.getKeyStroke('X',java.awt.Event.CTRL_MASK,false);



		//..Creates a FileMenu using FileMenu parameterised Constructor
		FileMenu fileMenu=new FileMenu(desktop,newMenuItemKeyStroke,openMenuItemKeyStroke,
		saveMenuItemKeyStroke,saveAsMenuItemKeyStroke,recentFilesMenuItemKeyStroke,
		exitMenuItemKeyStroke);

		//..add the fileMenu object to the JMenuBar
		menuBar.add(fileMenu);

		//..adds the MenuBar to the frame
		setJMenuBar(menuBar);

		//..window closing Listener
		addWindowListener(fileMenu.getDefaultClosingListener());
				
	}
	
}
public class AddFileMenuConstructorExample
{

	public static void main(String args[])
	{
		AddFileMenuConstructor addFileMenuConstructor=new AddFileMenuConstructor("FileMenu Second Constructor Example");
		addFileMenuConstructor.show();
		addFileMenuConstructor.setSize(500,500);
		addFileMenuConstructor.validate();
	}

}


