
/*
* @(#)HandleFileChooserExample.java 
*
*Product Of : MakeLogic
* URL		: http://www.makelogic.com
* Author	: R.Venkatesh
* Date		: 20 June, 2003
* email		: venkat@makelogicmldb.com

* Please feel free to use this Sample Code in your Applications.
*/

/*
* This sample Application Demonstrates how to get the
* FileChooser and make Changes to the FileChooser.
*/


import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;


import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

import com.makeLogic.utils.FileMenu;


class HandleFileChooser extends JFrame implements  PropertyChangeListener
{
	JDesktopPane desktop;
	JMenuBar menuBar;
			
	HandleFileChooser(String title)
	{
		//..calls the super class constructor
		super(title);

		//..creates a JMenuBar to Place Menus
		menuBar=new JMenuBar();

		//..container
		desktop=new JDesktopPane();

		//..gets the ContentPane of the JFrame
		getContentPane().add("Center",desktop);

    
		//..Creates the FileMenu Object
		FileMenu fileMenu=new FileMenu(desktop);

		//..Adds fileMenu to the MenuBar
		menuBar.add(fileMenu);

		//..Adds the JMenuBar to the JFrame
		setJMenuBar(menuBar);
		
		//..adds the PropertyChange Listeners
		fileMenu.getOpenMenuItem().addPropertyChangeListener(this);
		fileMenu.getSaveMenuItem().addPropertyChangeListener(this);
		fileMenu.getSaveAsMenuItem().addPropertyChangeListener(this);
	
		//.. exit when window closed
		addWindowListener(fileMenu.getDefaultClosingListener());

	}

	//..PropertyChangeListener
	//..it gets the FileChooser and changes the FileChooser properties
	public void propertyChange(PropertyChangeEvent propertyChangeEvent)
	{
		//..checks the property Name as FileChooserOpend which is set by the developer
		if(propertyChangeEvent.getPropertyName().equalsIgnoreCase("FileChooserOpened"))
		{
			//..gets the FileChooser
			JFileChooser fileChooser = (JFileChooser)propertyChangeEvent.getOldValue(); 

            if(fileChooser != null)
			{
				//..makes modifications to the FileChooser

				//..creates the FileFilters
				FileChooserFileFilter myFileFilter = new FileChooserFileFilter();

				//..sets the FileFilters to the FileChooser
				myFileFilter.addExtension("jpg");
				myFileFilter.addExtension("gif");
				myFileFilter.setDescription("JPG & GIF Images");
				fileChooser.setFileFilter(myFileFilter);

				//..sets the Title to the FileChooser
				fileChooser.setDialogTitle("HandleFileChooser Demo");
				fileChooser.validate();
			}
			else
			{
				//..do nothing
				
			}

		}
	}
	
}

public class HandleFileChooserExample 
{
	public static void main(String args[]) throws Exception
	{
       	HandleFileChooser handleFileChooser=new HandleFileChooser("Handle FileChooser Example");
		handleFileChooser.show();
		handleFileChooser.setSize(500,500);
		handleFileChooser.validate();
	}
}