/*
 * @(#)GetSetMaxEntriesExample.java	
 *
 * Product Of	: MakeLogic
 * URL			: http://www.makelogic.com
 * Author		: R.Venkatesh
 * Date			: 20 June, 2003
 * email		: venkat@makelogicmldb.com
 * 
 * Please feel free to use this Sample Code in your applications.
 */

/*
 * This sample Application Demonstrates how to use the 
 * get and set Methods for MaxEntries in ConfFile and 
 * RecentFiles Menu
 */

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;

import com.makeLogic.utils.FileMenu;

class GetSetMaxEntries extends JFrame 
{
	JMenuBar menuBar;
	JDesktopPane desktop;

	GetSetMaxEntries(String title)
	{
		//..calls the super class constructor
		super(title);
		//..MenuBar
		menuBar = new JMenuBar();
		//..Container
		desktop=new JDesktopPane();
		
		//..Gets the ContentPane of the JFrame and adds the container to the center
		getContentPane().add("Center",desktop);

		//..Creates a FileMenu Object
		//..The following two lines of code is sufficient to create complete FileMenu Object
		//..and adds it to the MenuBar
		FileMenu fileMenu=new FileMenu(desktop);

		//..add the fileMenu object to the JMenuBar
		menuBar.add(fileMenu);

		//..adds the MenuBar to the frame
		setJMenuBar(menuBar);

		
		//..set MaxEntries in Conf File
		fileMenu.setMaxEntriesInConfFile(30);

		//..set MaxEntries in RecentFilesMenu
		fileMenu.setMaxEntriesInRecentFilesMenu(10);
		

		//..getMaxEntries in Conf File
		int maxEntriesInConfFile=fileMenu.getMaxEntriesInConfFile();

		//..getMaxEntries in RecentFiles Menu
		int maxEntriesInRecentFilesMenu=fileMenu.getMaxEntriesInRecentFilesMenu();

		//..shows the Max_Entries Values in the MessageBox
		JOptionPane.showMessageDialog(null, "MaxEntriesInConfFile is  "+maxEntriesInConfFile+" And MaxEntriesInRecentFilesMenu is "+maxEntriesInRecentFilesMenu, "MessageDialog", JOptionPane.INFORMATION_MESSAGE ); 
		

		//..window closing Listener
		addWindowListener(fileMenu.getDefaultClosingListener());
				
	}
	
}
public class GetSetMaxEntriesExample
{

	public static void main(String args[])
	{
		GetSetMaxEntries getSetMaxEntries=new GetSetMaxEntries("Get and Set Methods for MaxEntries Example");
		getSetMaxEntries.show();
		getSetMaxEntries.setSize(500,500);
		getSetMaxEntries.validate();
	}

}


