/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.components.base;

import com.softaspects.framework.galileo.components.base.Component;
import com.softaspects.framework.galileo.components.base.ComponentBaseImpl;
import com.softaspects.framework.galileo.components.base.PresentationEvent;
import java.util.HashMap;
import java.util.Iterator;

public abstract class ComponentImpl
extends ComponentBaseImpl
implements Component {
    protected String fLeft = null;
    protected String fTop = null;
    protected String fWidth = null;
    protected String fHeight = null;
    protected String fHintText = null;
    protected boolean fEnabled = true;
    protected boolean fVisible = true;
    protected boolean fRequired = false;
    protected boolean fFocused = false;
    protected int fZindex = -1;
    protected char fAccessKey = '\u0000';
    protected int fAlign = -1;
    protected int fValign = -1;
    protected int fTabIndex = -1;
    protected HashMap fPresentationEvents = new HashMap();

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public void setEnabled(boolean aEnabled) {
        this.fEnabled = aEnabled;
    }

    public boolean isVisible() {
        return this.fVisible;
    }

    public void setVisible(boolean aVisible) {
        this.fVisible = aVisible;
    }

    public boolean isFocused() {
        return this.fFocused;
    }

    public void setFocused(boolean aFocused) {
        this.fFocused = aFocused;
    }

    public char getAccessKey() {
        return this.fAccessKey;
    }

    public void setAccessKey(char aAccessKey) {
        this.fAccessKey = aAccessKey;
    }

    public String getHintText() {
        return this.fHintText;
    }

    public void setHintText(String aHintText) {
        this.fHintText = aHintText;
    }

    public int getTabIndex() {
        return this.fTabIndex;
    }

    public void setTabIndex(int aTabIndex) {
        ComponentBaseImpl.validateValue(aTabIndex, "Tab index");
        this.fTabIndex = aTabIndex;
    }

    public void setAlign(int aAlign) {
        if (aAlign < 1 || aAlign > 3) {
            throw new IllegalArgumentException("Component: value of align is incorrect.");
        }
        this.fAlign = aAlign;
    }

    public int getAlign() {
        return this.fAlign;
    }

    public void setValign(int aValign) {
        if (aValign < 1 || aValign > 5) {
            throw new IllegalArgumentException("Component: value of valign is incorrect.");
        }
        this.fValign = aValign;
    }

    public int getValign() {
        return this.fValign;
    }

    public void setWidth(String aWidth) {
        this.fWidth = aWidth;
    }

    public String getWidth() {
        return this.fWidth;
    }

    public void setHeight(String aHeight) {
        this.fHeight = aHeight;
    }

    public String getHeight() {
        return this.fHeight;
    }

    public void setLeft(String aLeft) {
        this.fLeft = aLeft;
    }

    public String getLeft() {
        return this.fLeft;
    }

    public void setTop(String aTop) {
        this.fTop = aTop;
    }

    public String getTop() {
        return this.fTop;
    }

    public void setZindex(int aZindex) {
        ComponentBaseImpl.validateValue(aZindex, "Z-index");
        this.fZindex = aZindex;
    }

    public int getZindex() {
        return this.fZindex;
    }

    public boolean isValid() {
        return true;
    }

    public boolean isRequired() {
        return this.fRequired;
    }

    public void setRequired(boolean aRequired) {
        this.fRequired = aRequired;
    }

    public boolean hasRequiredValue() {
        return true;
    }

    public void setPresentationEvent(int aType, String aValue) {
        ComponentBaseImpl.validateValue(aValue, "Event");
        this.fPresentationEvents.put(new Integer(aType), aValue);
    }

    public void setPresentationEvent(PresentationEvent aPresentationEvent) {
        this.setPresentationEvent(aPresentationEvent.getType(), aPresentationEvent.getValue());
    }

    public boolean isPresentationEventFound(int aType) {
        return this.fPresentationEvents.containsKey(new Integer(aType));
    }

    public String getPresentationEventValue(int aType) {
        return (String)this.fPresentationEvents.get(new Integer(aType));
    }

    public void addPresentationEvent(int aType, String aValue) {
        if (!this.isPresentationEventFound(aType)) {
            this.setPresentationEvent(aType, aValue);
        } else {
            StringBuffer sb = new StringBuffer(this.getPresentationEventValue(aType));
            if (sb.charAt(sb.length() - 1) != ';') {
                sb.append(';');
            }
            sb.append(aValue);
            this.setPresentationEvent(aType, sb.toString());
        }
    }

    public void addPresentationEvent(PresentationEvent aPresentationEvent) {
        this.addPresentationEvent(aPresentationEvent.getType(), aPresentationEvent.getValue());
    }

    public void removePresentationEvent(int aType) {
        this.fPresentationEvents.remove(new Integer(aType));
    }

    public Iterator getPresentationEvents() {
        return new IteratorPresentationEvents(this.fPresentationEvents.keySet().iterator());
    }

    class IteratorPresentationEvents
    implements Iterator {
        private Iterator keys;

        IteratorPresentationEvents(Iterator aKeys) {
            this.keys = aKeys;
        }

        public boolean hasNext() {
            return this.keys.hasNext();
        }

        public void remove() {
            this.keys.remove();
        }

        public Object next() {
            Integer key = (Integer)this.keys.next();
            String value = (String)ComponentImpl.this.fPresentationEvents.get(key);
            return new PresentationEvent(key, value);
        }
    }
}

