/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.components.table;

import com.softaspects.framework.galileo.components.table.CellChanger;
import com.softaspects.framework.galileo.components.table.ChangeException;
import com.softaspects.framework.galileo.components.table.Table;
import java.lang.reflect.Constructor;

public class BaseCellChanger
implements CellChanger {
    private static final Class[] CONSTRUCTOR_PARAMS;
    static /* synthetic */ Class class$0;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        CONSTRUCTOR_PARAMS = classArray;
    }

    protected Object createNewCellObject(Class aCellClass, String aValue) throws ChangeException {
        if (aCellClass != null) {
            try {
                Constructor constructor = aCellClass.getConstructor(CONSTRUCTOR_PARAMS);
                return constructor.newInstance(aValue);
            }
            catch (Exception e) {
                throw new ChangeException(e.toString(), e);
            }
        }
        return null;
    }

    protected Object setValue(Object aCellObject, String aValue) throws ChangeException {
        return this.createNewCellObject(aCellObject.getClass(), aValue);
    }

    protected void initCellChanger(Table aTable, int aRowIndex, int aColumnIndex) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateCellValue(Table aTable, String aValue, int aRowIndex, int aColumnIndex) throws ChangeException {
        if (aTable == null) {
            throw new IllegalArgumentException("TableCellChanger: Table can't be null");
        }
        this.initCellChanger(aTable, aRowIndex, aColumnIndex);
        Object cellObject = aTable.getValueAt(aRowIndex, aColumnIndex);
        if (cellObject == null) {
            Class cellClass = aTable.getCellClass(aRowIndex, aColumnIndex);
            cellObject = this.createNewCellObject(cellClass, aValue);
            if (cellObject == null) throw new ChangeException("TableCellChanger: Can't create table cell object.");
            aTable.setValueAt(cellObject, aRowIndex, aColumnIndex);
            return;
        }
        try {
            aTable.setValueAt(this.setValue(cellObject, aValue), aRowIndex, aColumnIndex);
            return;
        }
        catch (Exception e) {
            throw new ChangeException(e.toString(), e);
        }
    }
}

