/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.button;

import com.softaspects.framework.galileo.components.base.ComponentBase;
import com.softaspects.framework.galileo.components.base.PresentationEvent;
import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.renderers.html.base.ContextRendererImpl;
import com.softaspects.framework.galileo.renderers.html.base.HtmlProperty;
import com.softaspects.framework.galileo.renderers.html.base.JavaScriptProviderBase;
import com.softaspects.framework.galileo.renderers.html.base.JavaScriptResource;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.support.components.button.Button;
import com.softaspects.galileo.client.jsp.html.base.ColorFactory;
import java.io.IOException;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;

public class HiButtonRenderer
extends ContextRendererImpl {
    private static final String BUTTON_MODEL_SCRIPT_WAS_LOADED = "BUTTON_MODEL_SCRIPT_WAS_LOADED";
    private static final String BUTTON_JSCRIPT_FUNCTION = "ButtonComponent";

    public String doRender() throws RendererException {
        JspWriter out = this.fPageContext.getOut();
        Button button = (Button)this.getComponent();
        try {
            String textSize;
            Object flag = this.fPageContext.getAttribute(BUTTON_MODEL_SCRIPT_WAS_LOADED, 2);
            StringBuffer sBuffer = new StringBuffer();
            if (flag == null) {
                JavaScriptResource javaScriptResource = new JavaScriptProviderBase().getJavaScriptResource((HttpServletRequest)this.fPageContext.getRequest());
                sBuffer.append(RendererFactory.createJScriptBeginTag(javaScriptResource.getComponentJavaScriptSource(button.getComponentTypeName()), null));
                sBuffer.append(RendererFactory.createJScriptEndTag());
                sBuffer.append("\n");
                this.fPageContext.setAttribute(BUTTON_MODEL_SCRIPT_WAS_LOADED, (Object)BUTTON_MODEL_SCRIPT_WAS_LOADED, 2);
            }
            if (button.getTextColor() != 0) {
                String color = ColorFactory.convertColorFromIntToHtml(button.getTextColor());
                button.addStyleProperty("COLOR", color);
            }
            if ((textSize = button.getTextSize()) != null) {
                button.addStyleProperty("FONT-SIZE", textSize);
            }
            sBuffer.append("<BUTTON");
            Iterator htmlProperties = RendererFactory.componentHtmlPropertiesIterator(button);
            while (htmlProperties.hasNext()) {
                sBuffer.append(' ');
                HtmlProperty htmlProperty = (HtmlProperty)htmlProperties.next();
                sBuffer.append(RendererFactory.createHtmlStylePropertyString(htmlProperty));
            }
            Iterator presentationEvents = button.getPresentationEvents();
            while (presentationEvents.hasNext()) {
                PresentationEvent presentationEvent = (PresentationEvent)presentationEvents.next();
                String type = RendererFactory.getPresentationEventName(presentationEvent.getType());
                String value = presentationEvent.getValue();
                sBuffer.append(' ');
                sBuffer.append(RendererFactory.createHtmlStylePropertyString(type, value));
            }
            sBuffer.append('>');
            sBuffer = new StringBuffer("<TABLE");
            sBuffer.append(' ');
            sBuffer.append(RendererFactory.createHtmlStylePropertyString("BORDER", 0));
            sBuffer.append(' ');
            sBuffer.append(RendererFactory.createHtmlStylePropertyString("CELLPADDING", 0));
            sBuffer.append(' ');
            sBuffer.append(RendererFactory.createHtmlStylePropertyString("CELLSPACING", 0));
            sBuffer.append('>');
            String buttonImage = button.getButtonImage();
            if (buttonImage != null) {
                sBuffer.append("<TR>").append("<TD ");
                sBuffer.append(' ');
                sBuffer.append(RendererFactory.createHtmlStylePropertyString("ALIGN", "CENTER"));
                sBuffer.append('>');
                sBuffer.append("<IMG ");
                sBuffer.append(RendererFactory.createHtmlStylePropertyString("SRC", buttonImage));
                sBuffer.append('>');
                sBuffer.append("</TD>").append("</TR>");
            }
            sBuffer.append("<TR>").append("<TD NOWRAP>");
            sBuffer.append(button.getValue());
            sBuffer.append("</TD>").append("</TR>");
            sBuffer.append("</TABLE>");
            sBuffer.append(RendererFactory.indentString(2, sBuffer.toString()));
            sBuffer.append("</BUTTON>");
            StringBuffer params = new StringBuffer();
            params.append(button.isFocused());
            params.append(',');
            params.append(button.isRequired());
            sBuffer.append(RendererFactory.createHtmlJScriptVariable((ComponentBase)button, BUTTON_JSCRIPT_FUNCTION, params.toString()));
            String result = sBuffer.toString();
            if (button.isPageContextRendering()) {
                out.println(result);
            }
            return result;
        }
        catch (IOException e) {
            throw new RendererException(e.toString());
        }
    }
}

