/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.clientagent;

import com.softaspects.framework.galileo.components.base.PresentationEvent;
import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.components.base.RendererImpl;
import com.softaspects.framework.galileo.renderers.html.base.ContextRenderer;
import com.softaspects.framework.galileo.renderers.html.base.HtmlProperty;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.support.components.clientagent.ClientAgentInfoComponent;
import com.softaspects.framework.galileo.support.components.form.custom.HiddenForm;
import com.softaspects.framework.galileo.support.util.StreamUtil;
import com.softaspects.galileo.client.jsp.html.base.TagFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Iterator;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;

public class ClientAgentInfoComponentRenderer
extends RendererImpl
implements ContextRenderer {
    private static final String USER_AGENT_INFO_SCRIPT = "useragentinfo.js";
    private static final String USER_AGENT_INFO_METHOD = "getUserAgentInfo";
    private static final String HFORM_JSCRIPT_FUNCTION = "HFormComponent";
    private static final String HFORM_MODEL_SCRIPT = "hformcomponent.js";
    private static final String HFORM_VARIABLE_NAME = "hForm";
    protected PageContext fPageContext = null;

    public void setPageContext(PageContext aPageContext) {
        this.fPageContext = aPageContext;
    }

    public String render() throws RendererException {
        ClientAgentInfoComponent agentInfocomponent = (ClientAgentInfoComponent)this.getComponent();
        HttpServletResponse response = (HttpServletResponse)this.fPageContext.getResponse();
        response.addIntHeader("Refresh", agentInfocomponent.getRefreshRate());
        JspWriter out = this.fPageContext.getOut();
        try {
            int i = 0;
            while (i < 4) {
                out.println(ClientAgentInfoComponentRenderer.generateScriptVersionTest(1.0f + 0.1f * (float)i));
                ++i;
            }
            out.println("<xml:namespace ns='http://www.microsoft.com/ie' prefix='MSIE'>");
            out.println("<STYLE>");
            out.println("@media all { MSIE\\:clientCaps {behavior:url(#default#clientcaps);}  }");
            out.println("</STYLE>");
            out.println("<MSIE:CLIENTCAPS ID='fClientCaps'/>");
            HiddenForm hiddenForm = agentInfocomponent.getHiddenForm();
            this.hFormRenderer(hiddenForm, this.fPageContext);
            StringBuffer sBuffer = new StringBuffer("<SCRIPT");
            sBuffer.append(' ');
            sBuffer.append(RendererFactory.createHtmlStylePropertyString("LANGUAGE", "JavaScript"));
            sBuffer.append('>');
            out.println((Object)sBuffer);
            this.writeFile(HFORM_MODEL_SCRIPT, out);
            out.println();
            this.writeFile(USER_AGENT_INFO_SCRIPT, out);
            out.println();
            sBuffer = new StringBuffer(HFORM_VARIABLE_NAME);
            sBuffer.append("= new ").append(HFORM_JSCRIPT_FUNCTION);
            String formId = hiddenForm.getId();
            sBuffer.append('(').append(RendererFactory.bracketString(formId)).append(");");
            out.println(sBuffer.toString());
            out.println();
            sBuffer = new StringBuffer(USER_AGENT_INFO_METHOD);
            sBuffer.append('(').append(HFORM_VARIABLE_NAME).append(");");
            out.println((Object)sBuffer);
            out.println("</SCRIPT>");
            return null;
        }
        catch (IOException e) {
            throw new RendererException(e.toString());
        }
    }

    protected static String generateScriptVersionTest(float aVer) {
        StringBuffer sBuffer = new StringBuffer("<SCRIPT LANGUAGE=");
        sBuffer.append('\"').append("JavaScript").append(aVer).append('\"');
        sBuffer.append('>').append("\n");
        sBuffer.append("<!--").append("\n");
        String ver = String.valueOf(aVer).replace('.', '_');
        sBuffer.append("var js").append(ver).append("=1;").append("\n");
        sBuffer.append("// -->").append("\n");
        sBuffer.append("</SCRIPT>");
        return sBuffer.toString();
    }

    protected void writeFile(String aFileName, JspWriter aWriter) throws IOException {
        block4: {
            StringBuffer fileName = new StringBuffer(RendererFactory.getPathToJavaScriptsExplorer());
            fileName.append(aFileName);
            InputStream input = null;
            try {
                input = this.fPageContext.getServletContext().getResourceAsStream(fileName.toString());
                if (input == null) {
                    System.err.println("Resource not found '" + fileName + "'.");
                    throw new IOException("Resource not found '" + aFileName + "'.");
                }
                StreamUtil.copy(input, (Writer)aWriter);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (input != null) {
                    input.close();
                }
                throw throwable;
            }
            Object var5_7 = null;
            if (input == null) break block4;
            input.close();
        }
    }

    protected void hFormRenderer(HiddenForm aForm, PageContext aPageContext) throws IOException {
        JspWriter out = this.fPageContext.getOut();
        StringBuffer sBuffer = new StringBuffer("<FORM");
        Iterator htmlProperties = RendererFactory.componentHtmlPropertiesIterator(aForm);
        while (htmlProperties.hasNext()) {
            sBuffer.append(' ');
            HtmlProperty htmlProperty = (HtmlProperty)htmlProperties.next();
            sBuffer.append(RendererFactory.createHtmlStylePropertyString(htmlProperty));
        }
        Iterator presentationEvents = aForm.getPresentationEvents();
        while (presentationEvents.hasNext()) {
            PresentationEvent presentationEvent = (PresentationEvent)presentationEvents.next();
            String type = RendererFactory.getPresentationEventName(presentationEvent.getType());
            String value = presentationEvent.getValue();
            sBuffer.append(RendererFactory.createHtmlStylePropertyString(type, value));
            sBuffer.append(' ');
        }
        String method = TagFactory.getFormMethodValue(aForm.getMethod());
        sBuffer.append(' ');
        sBuffer.append(RendererFactory.createHtmlStylePropertyString("METHOD", method));
        String action = RendererFactory.getJSPPath(this.fPageContext);
        action = RendererFactory.getEncodedURL(action, this.fPageContext);
        sBuffer.append(' ');
        sBuffer.append(RendererFactory.createHtmlStylePropertyString("ACTION", action));
        sBuffer.append('>');
        out.println((Object)sBuffer);
        Iterator formFields = aForm.getFields();
        while (formFields.hasNext()) {
            String field = (String)formFields.next();
            sBuffer = new StringBuffer("<INPUT");
            sBuffer.append(' ');
            sBuffer.append(RendererFactory.createHtmlStylePropertyString("NAME", field));
            sBuffer.append(' ');
            sBuffer.append(RendererFactory.createHtmlStylePropertyString("TYPE", "HIDDEN"));
            String value = aForm.getValue(field);
            if (value != null) {
                sBuffer.append(' ');
                sBuffer.append(RendererFactory.createHtmlStylePropertyString("VALUE", value));
            }
            sBuffer.append('>');
            out.println(RendererFactory.indentString(1, sBuffer.toString()));
        }
        out.println("</FORM>");
    }
}

