/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.container.layout;

import com.softaspects.framework.galileo.components.base.Component;
import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.renderers.html.container.layout.TableBasedLayoutRenderer;
import com.softaspects.framework.galileo.support.components.container.Container;
import com.softaspects.framework.galileo.support.components.container.layout.GridBasedLayoutManager;

public class GridLayoutRenderer
extends TableBasedLayoutRenderer {
    private int fDirection = 2;

    public String intoTableComponensRender(Container aContainer) throws RendererException {
        GridBasedLayoutManager gridLayout = (GridBasedLayoutManager)aContainer.getLayoutManager();
        StringBuffer sBuffer = new StringBuffer();
        int countRows = gridLayout.getCountRows(aContainer);
        int countColumns = gridLayout.getCountColumns(aContainer);
        try {
            int i = 0;
            while (i < countRows) {
                sBuffer.append(RendererFactory.indentString(1, "<TR>"));
                int j = 0;
                while (j < countColumns) {
                    Component component = null;
                    try {
                        if (this.fDirection == 2) {
                            component = aContainer.getComponent(i * countColumns + j);
                        } else if (this.fDirection == 1) {
                            component = aContainer.getComponent(j * countRows + i);
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    String td = RendererFactory.createHtmlStartTagForTableCell(component, -1, -1, gridLayout.getDefaultAlign(), gridLayout.getDefaultValign());
                    sBuffer.append(RendererFactory.indentString(2, td));
                    if (component != null) {
                        sBuffer.append(this.renderComponent(component));
                    } else {
                        sBuffer.append(RendererFactory.freeSpaceRender(this.fPageContext));
                    }
                    sBuffer.append(RendererFactory.indentString(2, "</TD>"));
                    ++j;
                }
                sBuffer.append(RendererFactory.indentString(1, "</TR>"));
                ++i;
            }
            return sBuffer.toString();
        }
        catch (Exception e) {
            throw new RendererException(e.toString());
        }
    }

    public void setDirection(int aDirection) {
        if (aDirection != 2 && aDirection != 1) {
            throw new IllegalArgumentException("GridRenderer: value of direction is invalid.");
        }
        this.fDirection = aDirection;
    }
}

