/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.table;

import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.components.table.Table;
import com.softaspects.framework.galileo.renderers.html.base.JavaScriptProviderBase;
import com.softaspects.framework.galileo.renderers.html.base.JavaScriptResource;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.renderers.html.table.AbstractTableRenderer;
import com.softaspects.framework.galileo.renderers.html.table.CellRenderer;
import com.softaspects.framework.galileo.renderers.html.table.RendererUtils;
import com.softaspects.framework.galileo.renderers.html.table.TableRenderer;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractCellEditor
extends AbstractTableRenderer
implements CellRenderer {
    protected static final String TABLE_EDIT_SCRIPT_WAS_LOADED = "TABLE_EDIT_SCRIPT_WAS_LOADED";
    protected static final String TABLE_EDIT_SCRIPT_FUNCTION = "TableEdit";
    protected static final String TABLE_EDIT_SCRIPT_PREFIX = "Cell";
    protected static final String JS_onEditChanged = "edit_changed";
    protected static final String JS_onEditFocus = "edit_focus";
    protected static final String JS_onEditBlur = "edit_blur";
    private int fRowIndex = -1;
    protected int fColumnIndex = -1;
    protected boolean fPageContextRendering = true;

    public void setRowIndex(int aRowIndex) {
        AbstractCellEditor.validateValue(aRowIndex, "Row index");
        this.fRowIndex = aRowIndex;
    }

    public int getRowIndex() {
        AbstractCellEditor.validateState(this.fRowIndex, "Row index");
        return this.fRowIndex;
    }

    public void setColumnIndex(int aColumnIndex) {
        AbstractCellEditor.validateValue(aColumnIndex, "Column index");
        this.fColumnIndex = aColumnIndex;
    }

    public int getColumnIndex() {
        AbstractCellEditor.validateState(this.fColumnIndex, "Column index");
        return this.fColumnIndex;
    }

    public void addJScriptCommamd(String aJsCommand) {
        if (aJsCommand != null && aJsCommand.length() > 0) {
            ((TableRenderer)this.getTable().getRenderer()).addJScriptCommamd(aJsCommand);
        }
    }

    public String doRender() throws RendererException {
        StringBuffer sBuffer = new StringBuffer();
        this.fPageContextRendering = this.getTable().isPageContextRendering();
        sBuffer.append(this.loadJScript());
        sBuffer.append(this.makeRender());
        this.createJSVariable();
        String result = sBuffer.toString();
        return sBuffer.toString();
    }

    public String loadJScript() throws RendererException {
        Object flag = this.fPageContext.getAttribute(TABLE_EDIT_SCRIPT_WAS_LOADED, 2);
        StringBuffer sBuffer = new StringBuffer();
        if (flag == null) {
            try {
                JavaScriptResource javaScriptResource = new JavaScriptProviderBase().getJavaScriptResource((HttpServletRequest)this.fPageContext.getRequest());
                this.fPageContext.getOut().println(RendererFactory.createJScriptBeginTag(javaScriptResource.getComponentJavaScriptSource("TABLE_CELL_EDITOR"), null));
                this.fPageContext.getOut().println(RendererFactory.createJScriptEndTag());
                this.fPageContext.setAttribute(TABLE_EDIT_SCRIPT_WAS_LOADED, (Object)TABLE_EDIT_SCRIPT_WAS_LOADED, 2);
            }
            catch (Exception e) {
                throw new RendererException(e.toString());
            }
        }
        return sBuffer.toString();
    }

    public abstract String makeRender() throws RendererException;

    public void createJSVariable() throws RendererException {
        Object value = this.getValue();
        String param = null;
        param = value instanceof String ? RendererFactory.bracketString(this.getValue().toString()) : this.getValue().toString();
        String editId = RendererUtils.getTableCellEditorId(this.getTable(), this.getRowIndex(), this.getColumnIndex());
        this.addJScriptCommamd(AbstractTableRenderer.createJsCommand(TABLE_EDIT_SCRIPT_PREFIX, editId, TABLE_EDIT_SCRIPT_FUNCTION, param));
    }

    protected String getFunctionOnChange(String aId, int aRow, int aColumn) {
        Table table = this.getTable();
        String funcOnChange = table.getInterfaceManager().getJScriptFunctionOnEditDataChanged(aRow, aColumn);
        StringBuffer sBuffer = new StringBuffer();
        if (funcOnChange != null) {
            sBuffer.append(funcOnChange);
        } else {
            sBuffer.append(RendererFactory.createJScriptVariableName(table));
            sBuffer.append('.');
            sBuffer.append(JS_onEditChanged);
        }
        sBuffer.append('(');
        sBuffer.append(aRow);
        sBuffer.append(',');
        sBuffer.append(aColumn);
        sBuffer.append(',');
        sBuffer.append(RendererFactory.createJScriptVariableName(TABLE_EDIT_SCRIPT_PREFIX, aId));
        sBuffer.append('.');
        sBuffer.append("getNewValue()");
        sBuffer.append(')');
        return sBuffer.toString();
    }

    protected static void validateValue(int aValue, String aName) {
        if (aValue < 0) {
            throw new IllegalArgumentException("TableCellEditor: " + aName + " can't be negative.");
        }
    }

    protected static void validateState(int aValue, String aName) {
        if (aValue == -1) {
            throw new IllegalStateException("TableCellEditor: " + aName + " must be initialized.");
        }
    }

    public abstract Object getValue();
}

