/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.table.additions.booleans;

import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.components.table.InterfaceManager;
import com.softaspects.framework.galileo.renderers.html.table.additions.AbstractImageTableCellRenderer;
import com.softaspects.framework.galileo.support.components.label.model.LabelModel;
import com.softaspects.framework.galileo.support.components.listmodel.ListDataModel;

public class BooleanImageTableCellRenderer
extends AbstractImageTableCellRenderer {
    public Object getValue() {
        int rowIndex = this.getRowIndex();
        int columnIndex = this.getColumnIndex();
        Object value = this.getTable().getValueAt(rowIndex, columnIndex);
        if (value != null && value instanceof Boolean) {
            return value;
        }
        return this.generateExceptionIfTypeNotCompartable(rowIndex, columnIndex, value);
    }

    public String makeRender() throws RendererException {
        boolean value;
        Object object;
        InterfaceManager interfaceManager = this.getTable().getInterfaceManager();
        int rowIndex = this.getRowIndex();
        int columnIndex = this.getColumnIndex();
        StringBuffer sBuffer = new StringBuffer();
        ListDataModel rendererData = interfaceManager.getRendererDataModel(rowIndex, columnIndex);
        if (rendererData == null) {
            BooleanImageTableCellRenderer.rendererException("Can't render without renderer data model.");
        }
        if ((object = rendererData.getValuetAt((value = ((Boolean)this.getValue()).booleanValue()) ? 0 : 1)) instanceof String) {
            sBuffer.append(this.renderLabel((String)object, null, null));
        } else if (object instanceof LabelModel) {
            LabelModel label = (LabelModel)object;
            String text = label.getText();
            String image = label.getDefaultImage();
            if (text == null && image == null) {
                BooleanImageTableCellRenderer.rendererException("Can't render label without image and text.");
            }
            String hintText = null;
            if (image != null) {
                hintText = label.getHintText() != null ? label.getHintText() : String.valueOf(value);
            }
            sBuffer.append(this.renderLabel(text, image, hintText));
        } else {
            BooleanImageTableCellRenderer.rendererException("Can't recognize type of renderer data model.");
        }
        return sBuffer.toString();
    }

    protected static void rendererException(String aText) throws RendererException {
        throw new RendererException("Boolean as Label Renderer: " + aText);
    }
}

