/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.components.button;

import com.softaspects.framework.galileo.components.base.ComponentImpl;
import com.softaspects.framework.galileo.renderers.html.button.ButtonRenderer;
import com.softaspects.framework.galileo.support.components.button.Button;
import com.softaspects.framework.galileo.support.components.button.model.Model;
import com.softaspects.framework.galileo.support.components.button.model.ModelImpl;

public abstract class ButtonImpl
extends ComponentImpl
implements Button {
    protected String fValue = null;
    protected Model fButtonModel = new ModelImpl();
    protected int fImagePosition = 2;
    protected int fTextColor = 0;
    protected String fTextSize = null;
    protected String fButtonImage = null;
    protected String fButtonDisabledImage = null;

    public ButtonImpl() {
        this.setRenderer(new ButtonRenderer());
    }

    public void setValue(String aValue) {
        this.fValue = aValue;
    }

    public String getValue() {
        return this.fValue;
    }

    public Model getButtonModel() {
        return this.fButtonModel;
    }

    public void setButtonModel(Model aButtonModel) {
        this.fButtonModel = aButtonModel;
    }

    public boolean isRequired() {
        return this.getType() != 4 && this.getType() != 5 ? false : super.isRequired();
    }

    public boolean hasRequiredValue() {
        return !this.isRequired() ? true : this.getButtonModel().isPressed();
    }

    public String getComponentTypeName() {
        switch (this.getType()) {
            case 4: {
                return "BUTTON_CHECKBOX";
            }
            case 6: {
                return "BUTTON_COMMON";
            }
            case 3: {
                return "BUTTON_IMAGE";
            }
            case 5: {
                return "BUTTON_RADIO";
            }
            case 2: {
                return "BUTTON_RESET";
            }
            case 1: {
                return "BUTTON_SUBMIT";
            }
        }
        return null;
    }

    public String getButtonImage() {
        return this.fButtonImage;
    }

    public void setButtonImage(String aButtonImage) {
        this.fButtonImage = aButtonImage;
    }

    public String getButtonDisabledImage() {
        return this.fButtonDisabledImage;
    }

    public void setButtonDisabledImage(String aButtonDisabledImage) {
        this.fButtonDisabledImage = aButtonDisabledImage;
    }

    public int getImagePosition() {
        return this.fImagePosition;
    }

    public void setImagePosition(int aAlign) {
        this.fImagePosition = aAlign;
    }

    public int getTextColor() {
        return this.fTextColor;
    }

    public void setTextColor(int aTextColor) {
        this.fTextColor = aTextColor;
    }

    public String getTextSize() {
        return this.fTextSize;
    }

    public void setTextSize(String aTextSize) {
        this.fTextSize = aTextSize;
    }

    public abstract int getType();
}

