/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.components.container;

import com.softaspects.framework.galileo.components.base.Component;
import com.softaspects.framework.galileo.components.base.ComponentBaseImpl;
import com.softaspects.framework.galileo.components.base.ComponentImpl;
import com.softaspects.framework.galileo.support.components.container.Container;
import com.softaspects.framework.galileo.support.components.container.Inset;
import com.softaspects.framework.galileo.support.components.container.decorator.Decorator;
import com.softaspects.framework.galileo.support.components.container.layout.BoxLayoutManager;
import com.softaspects.framework.galileo.support.components.container.layout.LayoutManager;
import com.softaspects.framework.galileo.support.components.container.layout.LayoutManagerPolicy;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ContainerImpl
extends ComponentImpl
implements Container {
    private Inset fInset = null;
    private LayoutManager fLayoutManager;
    private ArrayList fComponentsList = new ArrayList();
    private ArrayList fDecoratorsList = new ArrayList();
    private HashMap fComponentsIdMap = new HashMap();
    private boolean fLayoutManagerAlreadyWasSet = false;

    public ContainerImpl() {
        this.setLayoutManager(new BoxLayoutManager());
    }

    public ContainerImpl(String aId) {
        this();
        this.setId(aId);
    }

    public String getComponentTypeName() {
        return "CONTAINER";
    }

    public int getComponentsCount() {
        this.getLayoutManager().doLayout(this);
        return this.fComponentsList.size();
    }

    public Component getComponent(int aNumber) {
        return (Component)this.fComponentsList.get(aNumber);
    }

    public Component getComponent(String aId) {
        return (Component)this.fComponentsIdMap.get(aId);
    }

    public Iterator getComponents() {
        return ((AbstractList)this.fComponentsList).iterator();
    }

    public Component[] getComponentsArray() {
        Component[] array = new Component[this.fComponentsList.size()];
        return this.fComponentsList.toArray(array);
    }

    public List getComponentsList() {
        return this.fComponentsList;
    }

    public void addComponent(Component aComponent) {
        this.validateComponentID(aComponent);
        this.fComponentsList.add(aComponent);
        this.fComponentsIdMap.put(aComponent.getId(), aComponent);
        this.fLayoutManager.addLayoutComponent(aComponent);
        aComponent.setParentComponent(this);
    }

    public void removeComponent(Component aComponent) {
        if (aComponent != null && aComponent.getId() != null) {
            ((AbstractCollection)this.fComponentsList).remove(aComponent);
            this.fComponentsIdMap.remove(aComponent.getId());
            this.fLayoutManager.removeLayoutComponent(aComponent);
            aComponent.setParentComponent(null);
        }
    }

    public void removeComponent(int aIndex) {
        this.removeComponent(this.getComponent(aIndex));
    }

    public void removeComponent(String aId) {
        this.removeComponent(this.getComponent(aId));
    }

    public void removeAllComponents() {
        Iterator components = this.getComponents();
        while (components.hasNext()) {
            Component component = (Component)components.next();
            if (component == null) continue;
            component.setParentComponent(null);
        }
        this.fComponentsList.clear();
        this.fComponentsIdMap.clear();
        this.fLayoutManager.removeAllLayoutComponents();
    }

    public boolean isEmpty() {
        return this.fComponentsList.isEmpty();
    }

    public boolean isAncestorOf(Component aComponent) {
        return this.fComponentsList.contains(aComponent);
    }

    public boolean isAncestorOf(String aId) {
        return this.fComponentsIdMap.containsKey(aId);
    }

    public Inset getInset() {
        return this.fInset;
    }

    public void setInset(Inset aInset) {
        this.fInset = aInset;
    }

    public LayoutManager getLayoutManager() {
        return this.fLayoutManager;
    }

    public void setLayoutManager(LayoutManager aLayoutManager) {
        if (aLayoutManager == null) {
            throw new IllegalArgumentException("Container: Layout manager can't be null.");
        }
        if (!this.fLayoutManagerAlreadyWasSet) {
            this.fLayoutManagerAlreadyWasSet = true;
        } else if (LayoutManagerPolicy.generateExceptionIfContainerAlreadyHasLayoutManager()) {
            throw new IllegalStateException("Container: Container already has Layout manager.");
        }
        this.fLayoutManager = aLayoutManager;
        this.fLayoutManager.delegateRenderer(this);
    }

    public void addDecorator(Decorator aDecorator) {
        if (aDecorator == null) {
            throw new IllegalArgumentException("Container: decorator can't be null.");
        }
        this.fDecoratorsList.add(aDecorator);
        aDecorator.setParentComponent(this);
    }

    public void removeDecorator(Decorator aDecorator) {
        ((AbstractCollection)this.fDecoratorsList).remove(aDecorator);
        aDecorator.setParentComponent(null);
    }

    public void removeAllDecorators() {
        Iterator decorators = this.getDecorators();
        while (decorators.hasNext()) {
            Decorator decorator = (Decorator)decorators.next();
            decorator.setParentComponent(null);
        }
        this.fDecoratorsList.clear();
    }

    public Iterator getHeaderDecorators() {
        ArrayList<Decorator> headers = new ArrayList<Decorator>();
        Iterator decorators = this.getDecorators();
        while (decorators.hasNext()) {
            Decorator decorator = (Decorator)decorators.next();
            if (decorator.getOrderOfRendering() != 1) continue;
            headers.add(decorator);
        }
        return ((AbstractList)headers).iterator();
    }

    public Iterator getFooterDecorators() {
        ArrayList<Decorator> footers = new ArrayList<Decorator>();
        Iterator decorators = this.getDecorators();
        while (decorators.hasNext()) {
            Decorator decorator = (Decorator)decorators.next();
            if (decorator.getOrderOfRendering() != 2) continue;
            footers.add(decorator);
        }
        return ((AbstractList)footers).iterator();
    }

    private Iterator getDecorators() {
        return ((AbstractList)this.fDecoratorsList).iterator();
    }

    private static void validateComponent(Component aComponent) {
        if (aComponent == null) {
            throw new IllegalArgumentException("Container: Component can't be null.");
        }
    }

    private void validateComponentID(Component aComponent) {
        ContainerImpl.validateComponent(aComponent);
        ComponentBaseImpl.validateValue(aComponent.getId(), "Component's ID");
        if (this.fComponentsIdMap.containsKey(aComponent.getId())) {
            throw new IllegalArgumentException("Container: Components ID duplication. '" + aComponent.getId() + "'.");
        }
    }
}

