/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.components.container.layout;

import com.softaspects.framework.galileo.components.base.Component;
import com.softaspects.framework.galileo.components.base.Constraint;
import com.softaspects.framework.galileo.support.components.container.constraint.TableConstraint;
import com.softaspects.framework.galileo.support.components.container.layout.Bounds;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Bag
extends Bounds {
    private ArrayList fBagComponentsList = new ArrayList();
    private boolean fIsBagForNonClassified = false;
    private boolean fIsBagWasRendered = false;

    public void addComponent(Component aComponent) {
        if (this.isBagCorresponding(aComponent)) {
            this.fBagComponentsList.add(aComponent);
            Constraint constraint = aComponent.getConstraint();
            if (constraint != null && constraint instanceof TableConstraint) {
                TableConstraint tableConstraint = (TableConstraint)constraint;
                this.correctBounds(new Bounds(tableConstraint));
                this.setBagForNonClassifiedComponents(false);
            } else {
                this.setBagForNonClassifiedComponents(true);
            }
        }
    }

    public void removeComponent(Component aComponent) {
        if (this.fBagComponentsList.contains(aComponent)) {
            ((AbstractCollection)this.fBagComponentsList).remove(aComponent);
            this.clearBounds();
            if (!this.fIsBagForNonClassified) {
                Iterator components = this.getComponents();
                while (components.hasNext()) {
                    Component component = (Component)components.next();
                    Constraint constraint = component.getConstraint();
                    if (constraint == null || !(constraint instanceof TableConstraint)) continue;
                    TableConstraint tableConstraint = (TableConstraint)constraint;
                    this.correctBounds(new Bounds(tableConstraint));
                }
            }
        }
    }

    public void addBag(Bag aBag) {
        Iterator components = aBag.getComponents();
        while (components.hasNext()) {
            this.addComponent((Component)components.next());
        }
    }

    public boolean isBagCorresponding(Component aComponent) {
        if (!this.isBagEmpty()) {
            this.validateComponent(aComponent);
            Constraint constraint = aComponent.getConstraint();
            if (constraint != null && constraint instanceof TableConstraint) {
                TableConstraint tableConstraint = (TableConstraint)constraint;
                return this.isCrossBounds(new Bounds(tableConstraint));
            }
            return this.isBagForNonClassifiedComponents();
        }
        return true;
    }

    public boolean isBagEmpty() {
        return this.fBagComponentsList.isEmpty();
    }

    public Iterator getComponents() {
        return ((AbstractList)this.fBagComponentsList).iterator();
    }

    public List getComponentsList() {
        return this.fBagComponentsList;
    }

    public int getRowSpan() {
        return this.isBagEmpty() ? 0 : this.getEndRow() - this.getStartRow() + 1;
    }

    public int getColSpan() {
        return this.isBagEmpty() ? 0 : this.getEndCol() - this.getStartCol() + 1;
    }

    public boolean isBagForNonClassifiedComponents() {
        return this.fIsBagForNonClassified;
    }

    public void setBagForNonClassifiedComponents(boolean aIsBagForNonClassified) {
        this.fIsBagForNonClassified = aIsBagForNonClassified;
    }

    public boolean isBagWasRendered() {
        return this.fIsBagWasRendered;
    }

    public void setBagWasRendered(boolean aIsBagWasRendered) {
        this.fIsBagWasRendered = aIsBagWasRendered;
    }

    private void validateComponent(Component aComponent) {
        if (aComponent == null) {
            throw new IllegalArgumentException("Bag: component is null.");
        }
    }
}

