/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.components.container.layout;

import com.softaspects.framework.galileo.components.base.Component;
import com.softaspects.framework.galileo.components.base.Constraint;
import com.softaspects.framework.galileo.components.base.Renderer;
import com.softaspects.framework.galileo.support.components.container.Container;
import com.softaspects.framework.galileo.support.components.container.constraint.BorderConstraint;
import com.softaspects.framework.galileo.support.components.container.layout.ConstraintBasedLayoutManager;
import com.softaspects.framework.galileo.support.components.container.layout.GridBasedLayoutManagerImpl;
import com.softaspects.framework.galileo.support.components.container.layout.LayoutManagerImpl;
import com.softaspects.framework.galileo.support.components.container.layout.LayoutManagerPolicy;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public class BorderLayoutManager
extends GridBasedLayoutManagerImpl
implements ConstraintBasedLayoutManager {
    private static final int MAX_COUNT = 5;
    private int fType;
    private ArrayList[] fComponentsArray = new ArrayList[5];
    private static HashMap fRenderersHashMap = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        BorderLayoutManager.initRendererHashMap();
    }

    private static void initRendererHashMap() {
        Integer n = new Integer(1);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.softaspects.framework.galileo.renderers.html.container.layout.BodrerLayoutRendererNorthSouth");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fRenderersHashMap.put(n, clazz);
        Integer n2 = new Integer(2);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.softaspects.framework.galileo.renderers.html.container.layout.BodrerLayoutRendererEastWest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fRenderersHashMap.put(n2, clazz2);
    }

    public BorderLayoutManager() {
        this.setType(1);
        int i = 0;
        while (i < 5) {
            this.fComponentsArray[i] = new ArrayList();
            ++i;
        }
    }

    public void setType(int aType) {
        Class rendClass = (Class)fRenderersHashMap.get(new Integer(aType));
        if (rendClass == null) {
            throw new IllegalArgumentException("BorderLayoutManager: type not supported.");
        }
        try {
            this.setRenderer((Renderer)rendClass.newInstance());
        }
        catch (Exception e) {
            throw new IllegalStateException("BorderLayoutManager: can't create renderer.");
        }
        this.fType = aType;
    }

    public int getType() {
        return this.fType;
    }

    public Iterator getLayoutComponents(int aBorder) {
        BorderLayoutManager.validateBorder(aBorder);
        return ((AbstractList)this.fComponentsArray[aBorder]).iterator();
    }

    public Iterator getLayoutComponents(Constraint aConstraint) {
        return this.getLayoutComponents(this.getBorderValue(aConstraint));
    }

    public int getCountLayoutComponents(int aBorder) {
        BorderLayoutManager.validateBorder(aBorder);
        return this.fComponentsArray[aBorder].size();
    }

    public int getCountLayoutComponents(Constraint aConstraint) {
        return this.getCountLayoutComponents(this.getBorderValue(aConstraint));
    }

    public void addLayoutComponent(Component aComponent) {
        if (aComponent != null) {
            int border = this.getBorderValue(aComponent.getConstraint());
            this.fComponentsArray[border].add(aComponent);
        }
    }

    public void removeLayoutComponent(Component aComponent) {
        if (aComponent != null) {
            int border = this.getBorderValue(aComponent.getConstraint());
            ((AbstractCollection)this.fComponentsArray[border]).remove(aComponent);
        }
    }

    public void removeAllLayoutComponents() {
        int i = 0;
        while (i < 5) {
            this.fComponentsArray[i].clear();
            ++i;
        }
    }

    public int getCountRows(Container aContainer) {
        this.doLayout(aContainer);
        int result = this.fComponentsArray[4].size() + this.fComponentsArray[2].size();
        if (!(this.fComponentsArray[0].isEmpty() && (this.getType() != 1 || this.fComponentsArray[1].isEmpty() && this.fComponentsArray[3].isEmpty()))) {
            ++result;
        }
        return result;
    }

    public int getCountColumns(Container aContainer) {
        this.doLayout(aContainer);
        int result = this.fComponentsArray[1].size() + this.fComponentsArray[3].size();
        if (!(this.fComponentsArray[0].isEmpty() && (this.getType() != 2 || this.fComponentsArray[4].isEmpty() && this.fComponentsArray[2].isEmpty()))) {
            ++result;
        }
        return result;
    }

    public void doLayout(Container aContainer) {
        LayoutManagerImpl.validateContainer(aContainer);
        ArrayList layoutComponentsList = new ArrayList();
        int i = 0;
        while (i < 5) {
            layoutComponentsList.addAll(this.fComponentsArray[i]);
            ++i;
        }
        if (!Arrays.equals(layoutComponentsList.toArray(), aContainer.getComponentsArray())) {
            this.removeAllLayoutComponents();
            Iterator componentsIterator = aContainer.getComponents();
            while (componentsIterator.hasNext()) {
                this.addLayoutComponent((Component)componentsIterator.next());
            }
            aContainer.getComponentsList().clear();
            int i2 = 0;
            while (i2 < 5) {
                aContainer.getComponentsList().addAll(this.fComponentsArray[i2]);
                ++i2;
            }
        }
    }

    private int getBorderValue(Constraint aConstraint) {
        int border = 0;
        if (aConstraint == null) {
            if (LayoutManagerPolicy.generateExceptionIfConstraintIsNull()) {
                throw new IllegalArgumentException("BorderLayoutManager: constraint is null.");
            }
        } else if (aConstraint instanceof BorderConstraint) {
            border = ((BorderConstraint)aConstraint).getBorder();
        } else if (LayoutManagerPolicy.generateExceptionIfLayoutDontSupportedThisConstraint()) {
            throw new IllegalStateException("BorderLayoutManager: type of constraint is not supported.");
        }
        return border;
    }

    private static void validateBorder(int aBorder) {
        if (aBorder < 0 || aBorder > 4) {
            throw new IllegalArgumentException("BorderLayoutManager: border value is not supported.");
        }
    }
}

