/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.components.container.layout;

import com.softaspects.framework.galileo.components.base.Component;
import com.softaspects.framework.galileo.components.base.Renderer;
import com.softaspects.framework.galileo.support.components.container.Container;
import com.softaspects.framework.galileo.support.components.container.layout.LayoutManager;

public abstract class LayoutManagerImpl
implements LayoutManager {
    protected int fOverflow = 4;
    protected Renderer fRenderer = null;

    public void setRenderer(Renderer aRenderer) {
        LayoutManagerImpl.validateRenderer(aRenderer);
        this.fRenderer = aRenderer;
    }

    public Renderer getRenderer() {
        return this.fRenderer;
    }

    public void delegateRenderer(Container aContainer) {
        LayoutManagerImpl.validateContainer(aContainer);
        aContainer.setRenderer(this.getRenderer());
        this.getRenderer().setComponent(aContainer);
    }

    public int getOverflow() {
        return this.fOverflow;
    }

    public void setOverflow(int aOverflow) {
        if (aOverflow < 1 || aOverflow > 4) {
            throw new IllegalArgumentException("LayoutManager: value of overflow is not supported.");
        }
        this.fOverflow = aOverflow;
    }

    protected static void validateComponent(Component aComponent) {
        LayoutManagerImpl.validateValue(aComponent, "Component");
    }

    protected static void validateContainer(Container aContainer) {
        LayoutManagerImpl.validateValue(aContainer, "Container");
    }

    protected static void validateRenderer(Renderer aRenderer) {
        LayoutManagerImpl.validateValue(aRenderer, "Renderer");
    }

    private static void validateValue(Object aValue, String aName) {
        if (aValue == null) {
            throw new IllegalArgumentException("LayoutManager: " + aName + " can't be null.");
        }
    }

    public abstract void addLayoutComponent(Component var1);

    public abstract void removeLayoutComponent(Component var1);

    public abstract void removeAllLayoutComponents();

    public abstract void doLayout(Container var1);
}

