/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.components.container.layout;

import com.softaspects.framework.galileo.components.base.Component;
import com.softaspects.framework.galileo.components.base.Constraint;
import com.softaspects.framework.galileo.renderers.html.container.layout.GridLayoutRenderer;
import com.softaspects.framework.galileo.support.components.container.Container;
import com.softaspects.framework.galileo.support.components.container.constraint.OrderConstraint;
import com.softaspects.framework.galileo.support.components.container.layout.LayoutManagerImpl;
import com.softaspects.framework.galileo.support.components.container.layout.LayoutManagerPolicy;
import com.softaspects.framework.galileo.support.components.container.layout.OrientationSupportedLayoutManager;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;

public class OrderingBoxLayoutManager
extends OrientationSupportedLayoutManager {
    private TreeSet fComponentSet = new TreeSet(new ComparatorByOrder());

    public OrderingBoxLayoutManager() {
        this.setRenderer(new GridLayoutRenderer());
    }

    public int getCountRows(Container aContainer) {
        if (this.getOrientation()) {
            return 1;
        }
        this.doLayout(aContainer);
        return aContainer.getComponentsCount();
    }

    public int getCountColumns(Container aContainer) {
        if (!this.getOrientation()) {
            return 1;
        }
        this.doLayout(aContainer);
        return aContainer.getComponentsCount();
    }

    public void addLayoutComponent(Component aComponent) {
        if (aComponent != null) {
            this.fComponentSet.add(aComponent);
        }
    }

    public void removeLayoutComponent(Component aComponent) {
        if (aComponent != null) {
            this.fComponentSet.remove(aComponent);
        }
    }

    public void removeAllLayoutComponents() {
        this.fComponentSet.clear();
    }

    public void doLayout(Container aContainer) {
        LayoutManagerImpl.validateContainer(aContainer);
        Object[] containerComponents = aContainer.getComponentsArray();
        if (!Arrays.equals(this.fComponentSet.toArray(), containerComponents)) {
            this.removeAllLayoutComponents();
            int i = 0;
            while (i < containerComponents.length) {
                this.addLayoutComponent((Component)containerComponents[i]);
                ++i;
            }
            aContainer.getComponentsList().clear();
            aContainer.getComponentsList().addAll(this.fComponentSet);
        }
    }

    class ComparatorByOrder
    implements Comparator {
        ComparatorByOrder() {
        }

        public int compare(Object aObject1, Object aObject2) {
            if (!(aObject1 instanceof Component) || !(aObject2 instanceof Component)) {
                throw new IllegalArgumentException("Comporator: Type of objects not supported.");
            }
            Constraint constraint1 = ((Component)aObject1).getConstraint();
            Constraint constraint2 = ((Component)aObject2).getConstraint();
            int value1 = Integer.MAX_VALUE;
            int value2 = Integer.MAX_VALUE;
            if ((constraint1 == null || constraint2 == null) && LayoutManagerPolicy.generateExceptionIfConstraintIsNull()) {
                throw new IllegalStateException("OrderingBoxLayoutManager: constraint is null.");
            }
            if ((constraint1 != null && !(constraint1 instanceof OrderConstraint) || constraint2 != null && !(constraint2 instanceof OrderConstraint)) && LayoutManagerPolicy.generateExceptionIfLayoutDontSupportedThisConstraint()) {
                throw new IllegalStateException("OrderingBoxLayoutManager: type of constraint is not supported.");
            }
            if (constraint1 != null && constraint1 instanceof OrderConstraint) {
                value1 = ((OrderConstraint)constraint1).getOrder();
            }
            if (constraint2 != null && constraint2 instanceof OrderConstraint) {
                value2 = ((OrderConstraint)constraint2).getOrder();
            }
            return value1 <= value2 ? -1 : 1;
        }

        public boolean equals(Object aObject) {
            return false;
        }
    }
}

