/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.Writer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public final class StreamUtil {
    private static final int MAX_SIZE = 65536;
    private static final int SIZE = 4096;

    public static synchronized byte[] readA(InputStream aInputStream) throws IOException {
        ArrayList<byte[]> bufferList = new ArrayList<byte[]>();
        PushbackInputStream bStream = new PushbackInputStream(aInputStream);
        byte[] result = null;
        int size = 0;
        while (true) {
            int available;
            if ((available = bStream.available()) > 0) {
                if (available > 65536) {
                    available = 65536;
                }
                size += available;
                byte[] buffer = new byte[available];
                bStream.read(buffer);
                bufferList.add(buffer);
                continue;
            }
            int count = bStream.read();
            if (count < 0) break;
            bStream.unread(count);
        }
        result = new byte[size];
        Iterator iterator = ((AbstractList)bufferList).iterator();
        size = 0;
        while (iterator.hasNext()) {
            byte[] buffer = (byte[])iterator.next();
            System.arraycopy(buffer, 0, result, size, buffer.length);
            size += buffer.length;
        }
        return result;
    }

    public static synchronized byte[] readB(InputStream aInputStream) throws IOException {
        int count;
        byte[] tmpBuffer = new byte[4096];
        int size = 4096;
        int pos = 0;
        while ((count = aInputStream.read(tmpBuffer, pos, size - pos)) >= 0) {
            if ((pos += count) != size) continue;
            int newSize = size <= 8192 ? size << 1 : size + 4096;
            byte[] newBuffer = new byte[newSize];
            System.arraycopy(tmpBuffer, 0, newBuffer, 0, size);
            size = newSize;
            tmpBuffer = newBuffer;
        }
        byte[] result = new byte[pos];
        System.arraycopy(tmpBuffer, 0, result, 0, pos);
        return result;
    }

    public static synchronized void copy(InputStream aInput, OutputStream aOutput) throws IOException {
        int count;
        byte[] buffer = new byte[4096];
        while ((count = aInput.read(buffer)) >= 0) {
            aOutput.write(buffer, 0, count);
        }
    }

    public static synchronized void copy(InputStream aInput, Writer aOutput) throws IOException {
        int count;
        InputStreamReader reader = new InputStreamReader(aInput);
        char[] buffer = new char[4096];
        while ((count = reader.read(buffer)) >= 0) {
            aOutput.write(buffer, 0, count);
        }
    }
}

