/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.galileo.client.jsp.html.base;

import com.softaspects.galileo.client.jsp.html.base.TagBeanManager;
import com.softaspects.galileo.client.jsp.html.base.TagFactory;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.TagSupport;

public class TagBeanManagerImpl
extends BodyTagSupport
implements TagBeanManager {
    protected int fOverwriteExistent = -1;
    protected String fBeanName = null;
    protected int fScope = -1;
    private int fReturnCode = 2;

    public void setOverwriteExistent(String aOverwriteExistent) {
        TagBeanManagerImpl.validateValue(aOverwriteExistent, "Overwrite existent");
        this.fOverwriteExistent = TagFactory.getBooleanCode(aOverwriteExistent);
    }

    public String getOverwriteExistent() {
        return TagFactory.getBooleanValue(this.fOverwriteExistent);
    }

    protected boolean isOverwriteExistentValue() {
        return this.fOverwriteExistent == 1;
    }

    public void setBeanName(String aBeanName) {
        TagBeanManagerImpl.validateValue(aBeanName, "Bean name");
        this.fBeanName = aBeanName;
    }

    public String getBeanName() {
        return this.fBeanName;
    }

    public void setScope(String aScope) {
        TagBeanManagerImpl.validateValue(aScope, "Scope");
        int code = TagFactory.getScopeCode(aScope);
        if (code < 0) {
            throw new IllegalArgumentException("Bean support: Scope value is incorrect.");
        }
        this.fScope = code;
    }

    public String getScope() {
        return TagFactory.getScopeValue(this.fScope);
    }

    public int getScopeIntValue() {
        return this.fScope;
    }

    public Object loadBean() {
        Object bean = null;
        bean = this.fScope == -1 ? ((TagSupport)this).pageContext.findAttribute(this.fBeanName) : ((TagSupport)this).pageContext.getAttribute(this.fBeanName, this.fScope);
        return bean;
    }

    public void removeBean() {
        if (this.fScope == -1) {
            ((TagSupport)this).pageContext.removeAttribute(this.fBeanName);
        } else {
            ((TagSupport)this).pageContext.removeAttribute(this.fBeanName, this.fScope);
        }
    }

    public Object saveBean(Object aBean, boolean aOverwriteExistent) {
        if (aBean == null) {
            throw new IllegalArgumentException("Bean support: bean is null.");
        }
        Object result = this.loadBean();
        if (!aOverwriteExistent && result != null) {
            this.fReturnCode = 0;
            return result;
        }
        if (this.fScope == -1) {
            ((TagSupport)this).pageContext.setAttribute(this.fBeanName, aBean);
        } else {
            ((TagSupport)this).pageContext.setAttribute(this.fBeanName, aBean, this.fScope);
        }
        return aBean;
    }

    protected int getReturnCode() {
        return this.fReturnCode;
    }

    public Object saveBean(Object aBean) {
        return this.saveBean(aBean, this.isOverwriteExistentValue());
    }

    protected void validateBeanAttribute(String aTagName) {
        if (this.getBeanName() == null && (this.getScopeIntValue() != -1 || this.getOverwriteExistent() != null)) {
            throw new IllegalStateException(String.valueOf(aTagName) + ": Must specify 'beanName'.");
        }
    }

    protected void validateBeanName(String aTagName, String aAncestorName) {
        if (this.getBeanName() == null) {
            throw new IllegalStateException(String.valueOf(aTagName) + ": Must specify 'beanName' or uses ancestor tag '" + aAncestorName + "'.");
        }
    }

    protected static void validateValue(String aTagName, Object aValue, String aName) {
        if (aValue == null) {
            throw new IllegalArgumentException(String.valueOf(aTagName) + ": " + aName + " can't be null.");
        }
    }

    protected static void validateVariableName(String aVariable) {
        TagBeanManagerImpl.validateValue(aVariable, "Variable name");
        char[] chars = aVariable.toCharArray();
        boolean result = false;
        if (Character.isJavaIdentifierStart(chars[0])) {
            result = true;
            int i = 1;
            while (i < chars.length) {
                if (!Character.isJavaIdentifierPart(chars[i])) {
                    result = false;
                    break;
                }
                ++i;
            }
        }
        if (!result) {
            throw new IllegalArgumentException("BeanSupport: Variable name has wrong syntax.");
        }
    }

    public void release() {
        this.fBeanName = null;
        this.fOverwriteExistent = -1;
        this.fScope = -1;
    }

    private static void validateValue(String aValue, String aName) {
        if (aValue == null || aValue.length() == 0) {
            throw new IllegalArgumentException("Bean support: " + aName + " value is null.");
        }
    }
}

