/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.galileo.client.jsp.html.base;

import com.softaspects.framework.galileo.support.beans.BeanUtils;
import com.softaspects.framework.galileo.support.util.ReverseHashMap;
import com.softaspects.galileo.client.jsp.html.base.TagDefinitions;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;

public class TagFactory
implements TagDefinitions {
    private static ReverseHashMap fAlignsMap = new ReverseHashMap();
    private static ReverseHashMap fIframeAlignsMap = new ReverseHashMap();
    private static ReverseHashMap fValignsMap = new ReverseHashMap();
    private static ReverseHashMap fSelectionsMap = new ReverseHashMap();
    private static ReverseHashMap fKindOfImagesMap = new ReverseHashMap();
    private static ReverseHashMap fOrientationsMap = new ReverseHashMap();
    private static ReverseHashMap fOrientationConstantsMap = new ReverseHashMap();
    private static ReverseHashMap fScopesMap = new ReverseHashMap();
    private static ReverseHashMap fBorderConstraintsMap = new ReverseHashMap();
    private static ReverseHashMap fBorderLayoutTypeMap = new ReverseHashMap();
    private static ReverseHashMap fLayoutDirectionsMap = new ReverseHashMap();
    private static ReverseHashMap fBooleansMap = new ReverseHashMap();
    private static ReverseHashMap fScrollingMap = new ReverseHashMap();
    private static ReverseHashMap fOverFlowMap = new ReverseHashMap();
    private static ReverseHashMap fTableRulesMap = new ReverseHashMap();
    private static ReverseHashMap fFormMethodsMap = new ReverseHashMap();
    private static ReverseHashMap fTargetWindowMap = new ReverseHashMap();

    static {
        TagFactory.initTarget();
        TagFactory.initAligns();
        TagFactory.initValigns();
        TagFactory.initIframeAligns();
        TagFactory.initScopes();
        TagFactory.initSelections();
        TagFactory.initOrientations();
        TagFactory.initOrientationConstants();
        TagFactory.initKindsOfImages();
        TagFactory.initBorderConstraints();
        TagFactory.initBorderLayoutTypes();
        TagFactory.initLayoutDirections();
        TagFactory.initBooleans();
        TagFactory.initScrollings();
        TagFactory.initOverflows();
        TagFactory.initRulesMap();
        TagFactory.initFormMethodsMap();
    }

    private static void initTarget() {
        fTargetWindowMap.put(new Integer(2), "_blank");
        fTargetWindowMap.put(new Integer(4), "_self");
        fTargetWindowMap.put(new Integer(3), "_top");
        fTargetWindowMap.put(new Integer(1), "_parent");
    }

    private static void initAligns() {
        fAlignsMap.put(new Integer(2), "LEFT");
        fAlignsMap.put(new Integer(1), "RIGHT");
        fAlignsMap.put(new Integer(3), "CENTER");
    }

    private static void initValigns() {
        fValignsMap.put(new Integer(2), "MIDDLE");
        fValignsMap.put(new Integer(3), "TOP");
        fValignsMap.put(new Integer(4), "BOTTOM");
        fValignsMap.put(new Integer(5), "BASELINE");
    }

    private static void initIframeAligns() {
        fIframeAlignsMap.put(new Integer(2), "LEFT");
        fIframeAlignsMap.put(new Integer(1), "RIGHT");
        fIframeAlignsMap.put(new Integer(3), "TOP");
        fIframeAlignsMap.put(new Integer(6), "BASELINE");
        fIframeAlignsMap.put(new Integer(4), "BOTTOM");
        fIframeAlignsMap.put(new Integer(5), "MIDDLE");
    }

    private static void initOrientations() {
        fOrientationsMap.put(new Boolean(true), "HORIZONTAL");
        fOrientationsMap.put(new Boolean(false), "VERTICAL");
    }

    private static void initOrientationConstants() {
        fOrientationConstantsMap.put(new Short(1), "HORIZONTAL");
        fOrientationConstantsMap.put(new Short(2), "VERTICAL");
    }

    private static void initScopes() {
        fScopesMap.put(new Integer(2), "REQUEST");
        fScopesMap.put(new Integer(3), "SESSION");
        fScopesMap.put(new Integer(4), "APPLICATION");
        fScopesMap.put(new Integer(1), "PAGE");
    }

    private static void initSelections() {
        fSelectionsMap.put(new Integer(1), "SINGLE");
        fSelectionsMap.put(new Integer(2), "SINGLE_INTERVAL");
        fSelectionsMap.put(new Integer(3), "MULTIPLE");
    }

    private static void initBorderConstraints() {
        fBorderConstraintsMap.put(new Integer(1), "WEST");
        fBorderConstraintsMap.put(new Integer(3), "EAST");
        fBorderConstraintsMap.put(new Integer(2), "SOUTH");
        fBorderConstraintsMap.put(new Integer(4), "NORTH");
        fBorderConstraintsMap.put(new Integer(0), "CENTER");
    }

    private static void initKindsOfImages() {
        fKindOfImagesMap.put(new Boolean(false), "BIG");
        fKindOfImagesMap.put(new Boolean(true), "SMALL");
    }

    private static void initBorderLayoutTypes() {
        fBorderLayoutTypeMap.put(new Integer(2), "EAST-WEST");
        fBorderLayoutTypeMap.put(new Integer(1), "NORTH-SOUTH");
    }

    private static void initLayoutDirections() {
        fLayoutDirectionsMap.put(new Integer(2), "HORIZONTAL");
        fLayoutDirectionsMap.put(new Integer(1), "VERTICAL");
    }

    private static void initBooleans() {
        fBooleansMap.put(new Integer(0), "FALSE");
        fBooleansMap.put(new Integer(1), "TRUE");
    }

    private static void initScrollings() {
        fScrollingMap.put(new Integer(3), "AUTO");
        fScrollingMap.put(new Integer(2), "NO");
        fScrollingMap.put(new Integer(1), "YES");
    }

    private static void initOverflows() {
        fOverFlowMap.put(new Integer(2), "AUTO");
        fOverFlowMap.put(new Integer(1), "SCROLL");
        fOverFlowMap.put(new Integer(3), "VISIBLE");
        fOverFlowMap.put(new Integer(4), "HIDDEN");
    }

    private static void initRulesMap() {
        fTableRulesMap.put(new Integer(1), "ALL");
        fTableRulesMap.put(new Integer(2), "COLS");
        fTableRulesMap.put(new Integer(3), "GROUPS");
        fTableRulesMap.put(new Integer(4), "NONE");
        fTableRulesMap.put(new Integer(5), "ROWS");
    }

    private static void initFormMethodsMap() {
        fFormMethodsMap.put(new Integer(1), "GET");
        fFormMethodsMap.put(new Integer(2), "POST");
    }

    public static void setComponentModifiedProperties(ArrayList aModifiedPropertiesNamesList, ArrayList aModifiedPropertiesValuesList, Object anObject) {
        Iterator namesIterator = ((AbstractList)aModifiedPropertiesNamesList).iterator();
        Iterator valuesIterator = ((AbstractList)aModifiedPropertiesValuesList).iterator();
        String propertyName = null;
        Object propertyValue = null;
        while (namesIterator.hasNext()) {
            propertyName = (String)namesIterator.next();
            propertyValue = valuesIterator.next();
            BeanUtils.setPropertyValue(anObject, propertyName, propertyValue);
        }
    }

    private static boolean simpleLoginCheck(PageContext context) {
        ReverseHashMap map = (ReverseHashMap)context.getAttribute("MAP", 4);
        return map != null;
    }

    private static boolean checkSessionId(ReverseHashMap map, String id) {
        Object object = map.getValue(id);
        return object != null;
    }

    public static boolean checkLogin(PageContext context, HttpServletRequest request) {
        String id;
        if (!TagFactory.simpleLoginCheck(context)) {
            return false;
        }
        ReverseHashMap map = (ReverseHashMap)context.getAttribute("MAP", 4);
        return TagFactory.checkSessionId(map, id = request.getSession(true).getId());
    }

    public static boolean checkLogin(String id, PageContext context, String destination, boolean encodeUrl) throws IOException {
        boolean ind1 = TagFactory.simpleLoginCheck(context);
        if (!ind1) {
            TagFactory.redirect(context, destination, encodeUrl);
            return false;
        }
        ReverseHashMap map = (ReverseHashMap)context.getAttribute("MAP", 4);
        boolean ind2 = TagFactory.checkSessionId(map, id);
        if (!ind2) {
            TagFactory.redirect(context, destination, encodeUrl);
            return false;
        }
        return true;
    }

    public static void redirect(PageContext context, String destination, boolean encodeUrl) throws IOException {
        HttpServletResponse response = (HttpServletResponse)context.getResponse();
        String dest = null;
        dest = encodeUrl ? response.encodeURL(destination) : destination;
        response.sendRedirect(dest);
    }

    public static boolean checkLogin(String id, PageContext context) {
        boolean ind1 = TagFactory.simpleLoginCheck(context);
        System.out.println("Simple login check : " + ind1);
        if (!ind1) {
            return false;
        }
        ReverseHashMap map = (ReverseHashMap)context.getAttribute("MAP", 4);
        boolean ind2 = TagFactory.checkSessionId(map, id);
        System.out.println("Check session id : " + ind2);
        return ind2;
    }

    public static int getTargetCode(String aTarget) {
        TagFactory.validateOnNull(aTarget, "Target");
        Object result = fTargetWindowMap.getKey(aTarget.trim().toLowerCase());
        if (result == null) {
            TagFactory.sendMessageNotSupported(aTarget, "Target");
        }
        return (Integer)result;
    }

    public static String getTargetValue(int aTarget) {
        return aTarget < 0 ? null : (String)fTargetWindowMap.getValue(new Integer(aTarget));
    }

    public static int getAlignCode(String aAlign) {
        TagFactory.validateOnNull(aAlign, "Align");
        Object result = fAlignsMap.getKey(aAlign.trim().toUpperCase());
        if (result == null) {
            TagFactory.sendMessageNotSupported(aAlign, "Align");
        }
        return (Integer)result;
    }

    public static String getAlignValue(int aAlign) {
        return aAlign < 0 ? null : (String)fAlignsMap.getValue(new Integer(aAlign));
    }

    public static int getIframeAlignCode(String aAlign) {
        TagFactory.validateOnNull(aAlign, "Align");
        Object result = fIframeAlignsMap.getKey(aAlign.trim().toUpperCase());
        if (result == null) {
            TagFactory.sendMessageNotSupported(aAlign, "Align");
        }
        return (Integer)result;
    }

    public static String getIframeAlignValue(int aAlign) {
        return aAlign < 0 ? null : (String)fIframeAlignsMap.getValue(new Integer(aAlign));
    }

    public static int getValignCode(String aValign) {
        TagFactory.validateOnNull(aValign, "Valign");
        Object result = fValignsMap.getKey(aValign.trim().toUpperCase());
        if (result == null) {
            TagFactory.sendMessageNotSupported(aValign, "Valign");
        }
        return (Integer)result;
    }

    public static String getValignValue(int aValign) {
        return aValign < 0 ? null : (String)fValignsMap.getValue(new Integer(aValign));
    }

    public static boolean getOrientationCode(String aOrientation) {
        TagFactory.validateOnNull(aOrientation, "Orientation");
        Object result = fOrientationsMap.getKey(aOrientation.trim().toUpperCase());
        if (result == null) {
            TagFactory.sendMessageNotSupported(aOrientation, "Orientation");
        }
        return (Boolean)result;
    }

    public static short getOrientationConstantCode(String aOrientation) {
        TagFactory.validateOnNull(aOrientation, "Orientation");
        Object result = fOrientationConstantsMap.getKey(aOrientation.trim().toUpperCase());
        if (result == null) {
            TagFactory.sendMessageNotSupported(aOrientation, "Orientation");
        }
        return (Short)result;
    }

    public static String getOrientationValue(boolean aOrientation) {
        return (String)fOrientationsMap.getValue(new Boolean(aOrientation));
    }

    public static boolean getKindOfImagesCode(String aValue) {
        TagFactory.validateOnNull(aValue, "Kind of images");
        Object result = fKindOfImagesMap.getKey(aValue.trim().toUpperCase());
        if (result == null) {
            TagFactory.sendMessageNotSupported(aValue, "Kind of images");
        }
        return (Boolean)result;
    }

    public static String getKindOfImagesValue(boolean aCode) {
        return (String)fKindOfImagesMap.get(new Boolean(aCode));
    }

    public static int getSelectionCode(String aSelection) {
        TagFactory.validateOnNull(aSelection, "Selection");
        Object result = fSelectionsMap.getKey(aSelection.trim().toUpperCase());
        if (result == null) {
            TagFactory.sendMessageNotSupported(aSelection, "Selection");
        }
        return (Integer)result;
    }

    public static String getSelectionValue(int aSelection) {
        return aSelection < 0 ? null : (String)fSelectionsMap.getValue(new Integer(aSelection));
    }

    public static int getBorderConstraintCode(String aBorderConstraint) {
        TagFactory.validateOnNull(aBorderConstraint, "Border constraint");
        Object result = fBorderConstraintsMap.getKey(aBorderConstraint.trim().toUpperCase());
        if (result == null) {
            TagFactory.sendMessageNotSupported(aBorderConstraint, "Border constraint");
        }
        return (Integer)result;
    }

    public static String getBorderConstraintValue(int aBorderConstraint) {
        return aBorderConstraint < 0 ? null : (String)fBorderConstraintsMap.getValue(new Integer(aBorderConstraint));
    }

    public static int getBorderLayoutTypeCode(String aBorderLayoutType) {
        TagFactory.validateOnNull(aBorderLayoutType, "Border layout type");
        Object result = fBorderLayoutTypeMap.getKey(aBorderLayoutType.trim().toUpperCase());
        if (result == null) {
            TagFactory.sendMessageNotSupported(aBorderLayoutType, "Border layout type");
        }
        return (Integer)result;
    }

    public static String getBorderLayoutTypeValue(int aBorderLayoutType) {
        return aBorderLayoutType < 0 ? null : (String)fBorderLayoutTypeMap.getValue(new Integer(aBorderLayoutType));
    }

    public static int getLayoutDirectionCode(String aDirection) {
        TagFactory.validateOnNull(aDirection, "Layout direction");
        Object result = fLayoutDirectionsMap.getKey(aDirection.trim().toUpperCase());
        if (result == null) {
            TagFactory.sendMessageNotSupported(aDirection, "Layout direction");
        }
        return (Integer)result;
    }

    public static String getLayoutDirectionValue(int aDirection) {
        return aDirection < 0 ? null : (String)fLayoutDirectionsMap.getValue(new Integer(aDirection));
    }

    public static int getScopeCode(String aScope) {
        TagFactory.validateOnNull(aScope, "Scope");
        Object result = fScopesMap.getKey(aScope.trim().toUpperCase());
        if (result == null) {
            TagFactory.sendMessageNotSupported(aScope, "Scope");
        }
        return (Integer)result;
    }

    public static String getScopeValue(int aScope) {
        return aScope < 0 ? null : (String)fScopesMap.getValue(new Integer(aScope));
    }

    public static int getBooleanCode(String aBoolean) {
        TagFactory.validateOnNull(aBoolean, "Boolean");
        Object result = fBooleansMap.getKey(aBoolean.trim().toUpperCase());
        if (result == null) {
            TagFactory.sendMessageNotSupported(aBoolean, "Boolean");
        }
        return (Integer)result;
    }

    public static String getBooleanValue(int aBoolean) {
        return aBoolean < 0 ? null : (String)fBooleansMap.getValue(new Integer(aBoolean));
    }

    public static boolean getBoolean(int aBoolean) {
        if (!fBooleansMap.containsKey(new Integer(aBoolean))) {
            TagFactory.sendMessageNotSupported(String.valueOf(aBoolean), "Boolean");
        }
        return aBoolean == 1;
    }

    public static int getScrollingCode(String aScrolling) {
        TagFactory.validateOnNull(aScrolling, "Scrolling");
        Object result = fScrollingMap.getKey(aScrolling.trim().toUpperCase());
        if (result == null) {
            TagFactory.sendMessageNotSupported(aScrolling, "Scrolling");
        }
        return (Integer)result;
    }

    public static String getScrollingValue(int aScrolling) {
        return aScrolling < 0 ? null : (String)fScrollingMap.getValue(new Integer(aScrolling));
    }

    public static int getOverflowCode(String aOverflow) {
        TagFactory.validateOnNull(aOverflow, "Overflow");
        Object result = fOverFlowMap.getKey(aOverflow.trim().toUpperCase());
        if (result == null) {
            TagFactory.sendMessageNotSupported(aOverflow, "Overflow");
        }
        return (Integer)result;
    }

    public static String getOverflowValue(int aOverflow) {
        return aOverflow < 0 ? null : (String)fOverFlowMap.getValue(new Integer(aOverflow));
    }

    public static String getRulesValue(int aRules) {
        return aRules < 0 ? null : (String)fTableRulesMap.getValue(new Integer(aRules));
    }

    public static int getRulesCode(String aRules) {
        TagFactory.validateOnNull(aRules, "Valign");
        Object result = fTableRulesMap.getKey(aRules.trim().toUpperCase());
        if (result == null) {
            TagFactory.sendMessageNotSupported(aRules, "Rules");
        }
        return (Integer)result;
    }

    public static String getFormMethodValue(int aMethod) {
        return aMethod < 0 ? null : (String)fFormMethodsMap.getValue(new Integer(aMethod));
    }

    public static int getFormMethodCode(String aMethod) {
        TagFactory.validateOnNull(aMethod, "Form Method");
        Object result = fFormMethodsMap.getKey(aMethod.trim().toUpperCase());
        if (result == null) {
            TagFactory.sendMessageNotSupported(aMethod, "Form Method");
        }
        return (Integer)result;
    }

    public static void validateBooleanValue(String aValue) {
        String value = aValue.toUpperCase();
        if (!value.equals("TRUE") && !value.equals("FALSE")) {
            throw new IllegalArgumentException("Boolean value must be 'true' or 'false'");
        }
    }

    public static void validateOnNull(String aValue, String aName) {
        if (aValue == null) {
            throw new IllegalArgumentException("TagFactory: " + aName + " can't be null.");
        }
    }

    public static boolean validateOnNullAndEmptiness(String aValue) {
        return aValue != null && aValue != "";
    }

    private static void sendMessageNotSupported(String aValue, String aName) {
        throw new IllegalArgumentException("TagFactory: " + aName + " value '" + aValue + "' not supported.");
    }
}

