// Copyright:    Copyright (c) 2002-2003  .
//               All rights reserved.

// Company:      SoftAspects 
//
// @version      1.5



  var TAB_VARIABLE_PREFIX ="tab_";

  function TabSetDataModel(aId, aSize)
  {
   this.fId   = aId;
   this.fSize = aSize;
 
   this.isEmpty          = tabsetDataModel_isEmpty;
   this.getSize          = tabsetDataModel_getSize;
   this.getValueAt       = tabsetDataModel_getValueAt;
   this.getTabComponentAt   = tabsetDataModel_getTabComponentAt;
   this.setValueAt       = tabsetDataModel_setValueAt;
   this.contains         = tabsetDataModel_contains;
   this.indexOfValue     = tabsetDataModel_indexOfValue;
   this.lastIndexOfValue = tabsetDataModel_lastIndexOfValue;
   this.toArray          = tabsetDataModel_toArray; 
  }
  
  function tabsetDataModel_isEmpty()
  {
   return (this.getSize() == 0);
  }
  
  function tabsetDataModel_getSize()
  {
   return this.fSize; 
  }
  
  function tabsetDataModel_getTabComponentAt(aIndex)
  {
    if (aIndex >= this.getSize()) return null;
    return x0653090547866255818095811111(this.fId + "_" + aIndex);
  }

  function tabsetDataModel_getValueAt(aIndex)
  {
   if (aIndex >= this.getSize()) return null;
   return x0653090547866255818095811111(this.fId + "_" + aIndex + "_data").innerHTML;
  }   

  function tabsetDataModel_setValueAt(aValue, aIndex)
  {
   if (aIndex >= this.getSize()) return;
   x0653090547866255818095811111(this.fId + "_" + aIndex +"_data").innerHTML =  aValue ;
  }

  function tabsetDataModel_contains(aValue)
  {
   var size = this.getSize();
   for (i = 0; i < size; i++ )
   {
    if (this.getValueAt(i) == aValue) return true;
   }
   return false;
  }

  function tabsetDataModel_indexOfValue(aValue)
  {
   var size = this.getSize();
   for (i = 0; i < size; i++ )
   {
    if (this.getValueAt(i) == aValue) return i;
   }
   return -1;
  }

  function tabsetDataModel_lastIndexOfValue(aValue)
  {
   var size = this.getSize();
   for (i = size; i >= 0; i-- )
   {
    if (this.getValueAt(i) == aValue) return i;
   }
   return -1;
  }

  function tabsetDataModel_toArray()
  {
   var size  = this.getSize();
   var array = new Array(size);
   for (i = 0; i < size; i++ )
   {
     array[i] = this.getValueAt(i);
   }
  return array; 
  }

//****************************************************

  function TabSetSelectionModel(aId, aSelect, aSize)
  {
   this.fId     = aId; 
   this.fSelect = aSelect;
   this.fOldSelect = null;
   this.fSize   = aSize;

   this.getSelectionType        = tabsetSelectionModel_getSelectionType;

   this.setSelectionItem        = tabsetSelectionModel_setSelectionItem;
   this.removeSelectionInterval = tabsetSelectionModel_removeSelectionInterval;
   this.getSelectedItem         = tabsetSelectionModel_getSelectedItem;
   this.getOldSelectedItem      = tabsetSelectionModel_getOldSelectedItem;
   this.isSelected              = tabsetSelectionModel_isSelected;
   this.clearSelection          = tabsetSelectionModel_clearSelection;
   this.isEmpty                 = tabsetSelectionModel_selectionIsEmpty;

   this.setSelectionItem(aSelect);
  } 

   function tabsetSelectionModel_getSelectionType()
   {
    return "SINGLE";
   }

   function tabsetSelectionModel_getOldSelectedItem()
   {
        return this.oldSelect;
   }

   function tabsetSelectionModel_setSelectionItem( aTop )
   {
    if (aTop == null || aTop >= this.fSize )
    {
     alert("Illegal argument exception");
     return;
    }

    if(this.oldSelect == null)
    {
        this.oldSelect = aTop;
    }
    else
    {
        this.oldSelect = this.getSelectedItem();
    }

    this.clearSelection();
    eval(TAB_VARIABLE_PREFIX + this.fId + "_" + aTop +".tselect()");  
    this.fSelect = aTop;  
   }

   function tabsetSelectionModel_removeSelectionInterval( aTop, aBottom)
   {
    if (aTop == null)
    {
     alert("Illegal argument exception");
     return;
    }
    
    if (aTop > aBottom) 
    {
     s = aBottom;
     aTop = aBottom;
     aBottom = s; 
    }

    if (this.fSelect >= aTop &&  this.fSelect <= aBottom) 
    {
     this.clearSelection();
    } 
   }
   
   function tabsetSelectionModel_getSelectedItem()
   {
    if ( !this.isEmpty() )  return this.fSelect;
    return null;
   }

   function tabsetSelectionModel_isSelected(aIndex)
   {
    if (aIndex == null)
    {
      alert("Illegal argument exception");
      return;
    }
    return (this.fSelect == aIndex);
   }

   function tabsetSelectionModel_clearSelection()
   {
    if ( !this.isEmpty() )
    {
      eval(TAB_VARIABLE_PREFIX + this.fId + "_" + this.fSelect +".tdeselect()");  
      this.fSelect = null;
    }
   }

   function tabsetSelectionModel_selectionIsEmpty()
   {
    return (this.fSelect == null);
   }

//****************************************************

  function TabsetComponent(aId, aAxes, aSelect, aRequred, aSize,
                                                   aImagesWidth,
                                                  aImagesHeight, 
                                               aActiveImageLeft, 
                                             aActiveImageCenter, 
                                              aActiveImageRight,
                                             aInactiveImageLeft,
                                           aInactiveImageCenter,                         
                                            aInactiveImageRight, 
                                                aTabImagesWidth,
                                               aTabImagesHeight, 
                                           aTabSmallImagesWidth,                                                
                                          aTabSmallImagesHeight,                                                
                                               aTabKindOfImages, 
                                                aTabActiveStyle, 
                                                      aTabStyle, 
                                                aTabHLightStyle, 
                                           aTabActiveStyleClass, 
                                                 aTabStyleClass, 
                                           aTabHLightStyleClass) 
 {
   this.fId                  = aId;
   this.fAxes                = aAxes;
   this.fSelect              = aSelect;
   this.fRequred             = aRequred;
   this.fSize                = aSize;
   this.fImagesWidth         = aImagesWidth;
   this.fImagesHeight        = aImagesHeight; 
   
   this.ACTIVE_IMAGE_LEFT_INDEX = 0;
   this.ACTIVE_IMAGE_CENTER_INDEX = 1;
   this.ACTIVE_IMAGE_RIGHT_INDEX = 2;
   
   this.INACTIVE_IMAGE_LEFT_INDEX = 3;
   this.INACTIVE_IMAGE_CENTER_INDEX = 4;
   this.INACTIVE_IMAGE_RIGHT_INDEX = 5;
   
   this.imagesArray = new Array();
   
   this.fActiveImageLeft     = aActiveImageLeft;
   this.fActiveImageCenter   = aActiveImageCenter;
   this.fActiveImageRight    = aActiveImageRight;
   this.fInactiveImageLeft   = aInactiveImageLeft;
   this.fInactiveImageCenter = aInactiveImageCenter;                                                                   
   this.fInactiveImageRight  = aInactiveImageRight;                                           
   
   
   
   
   this.fTabImagesWidth      = aTabImagesWidth;                                                
   this.fTabImagesHeight     = aTabImagesHeight;
   this.fTabSmallImagesWidth = aTabSmallImagesWidth;                                                
   this.fTabSmallImagesHeight= aTabSmallImagesHeight;                                                
   this.fTabKindOfImages     = aTabKindOfImages;
   
   this.fTabActiveStyle      = aTabActiveStyle;                                                 
   this.fTabStyle            = aTabStyle;                                                       
   this.fTabHLightStyle      = aTabHLightStyle;                                                 
   
   if(isNetscape)
   {
   this.getTabColors = getTabColors;
   this.getTabBgColors  = getTabBgColors;
   
   this.fTabActiveColor = null;
   this.fTabColor    = null;
   this.fTabHLightColor = null;
   
   this.fTabActiveBgColor = null;
   this.fTabBgColor     = null;
   this.fTabHLightBgColor = null;
   
   this.getTabColors(this.fTabActiveStyle,this.fTabStyle,this.fTabHLightStyle);
   this.getTabBgColors(this.fTabActiveStyle,this.fTabStyle,this.fTabHLightStyle);
   

   }
   
   
   
   this.fTabActiveStyleClass = aTabActiveStyleClass;
   this.fTabStyleClass       = aTabStyleClass;                                                  
   this.fTabHLightStyleClass = aTabHLightStyleClass;                                            

   this.fcomponent;
   this.fObj;
   this.getId;
   this.getName;             this.setName;
   this.getHintText;         this.setHintText;
   this.getStyleClass;       this.setStyleClass;
   this.isEnabled;           this.setEnabled;
   this.getStyle;
   this.getStyleString;      this.setStyleString;
   this.setFocused;          this.isFocused;
   this.getTabIndex;         this.setTabIndex;
   this.getWidth;            this.setWidth;
   this.getHeight;           this.setHeight;

   this.dataModel;
   this.selectionModel;

   this.init             = tabset_init;
   this.initImages          = tabset_initImages;
   this.hasRequiredValue = tabset_hasRequiredValue;
   this.repaint          = tabset_repaint;
   this.setBigImages     = tabset_setBigImages;
   this.setSmallImages   = tabset_setSmallImages;
   this.getTabBackground = tabset_getTabBackground;
   
   this.initImages();
   
  }
  

   function tabset_getTabBackground(index)
   {
       var tab = this.dataModel.getTabComponentAt(index);

       if(tab == null)
       {
            return null;
       }
       else
       {
            return tab.backgroundColor;
       }
   }

   function tabset_init()
   {
    
    
    this.fcomponent = new Component(this.fId); 
    this.fObj       = this.fcomponent.getObj();

    this.getId            = this.fcomponent.getId;
    this.getName          = this.fcomponent.getName;
    this.setName          = this.fcomponent.setName;
    this.getHintText      = this.fcomponent.getHintText;
    this.setHintText      = this.fcomponent.setHintText;
    this.getStyleClass    = this.fcomponent.getStyleClass;
    this.setStyleClass    = this.fcomponent.setStyleClass;
    this.isEnabled        = this.fcomponent.isEnabled;
    this.setEnabled       = this.fcomponent.setEnabled;
    this.getStyle         = this.fcomponent.getStyle;
    this.getWidth         = this.fcomponent.getWidth;
    this.setWidth         = this.fcomponent.setWidth;
    this.getHeight        = this.fcomponent.getHeight;
    this.setHeight        = this.fcomponent.setHeight;
    this.getStyleString   = this.fcomponent.getStyleString;
    this.setStyleString   = this.fcomponent.setStyleString;
    this.setFocused       = this.fcomponent.setFocused;
    this.isFocused        = this.fcomponent.isFocused;
    this.getTabIndex      = this.fcomponent.getTabIndex;
    this.setTabIndex      = this.fcomponent.setTabIndex;


    dataModel             = new TabSetDataModel(this.fId, this.fSize);
    this.dataModel        = dataModel;
   
    selectionModel        = new TabSetSelectionModel(this.fId, this.fSelect, this.fSize);
    this.selectionModel   = selectionModel;
    
    
    
   }
   

   function tabset_initImages()     
   {
   this.imagesArray[this.ACTIVE_IMAGE_LEFT_INDEX] = new Image();
   this.imagesArray[this.ACTIVE_IMAGE_LEFT_INDEX].src = this.fActiveImageLeft;
   
   this.imagesArray[this.ACTIVE_IMAGE_CENTER_INDEX] = new Image();
   this.imagesArray[this.ACTIVE_IMAGE_CENTER_INDEX].src = this.fActiveImageCenter;
   
   this.imagesArray[this.ACTIVE_IMAGE_RIGHT_INDEX] = new Image();
   this.imagesArray[this.ACTIVE_IMAGE_RIGHT_INDEX].src = this.fActiveImageRight;
   
   
   this.imagesArray[this.INACTIVE_IMAGE_LEFT_INDEX] = new Image();
   this.imagesArray[this.INACTIVE_IMAGE_LEFT_INDEX].src = this.fInactiveImageLeft;
   
   this.imagesArray[this.INACTIVE_IMAGE_CENTER_INDEX] = new Image();
   this.imagesArray[this.INACTIVE_IMAGE_CENTER_INDEX].src = this.fInactiveImageCenter;
   
   this.imagesArray[this.INACTIVE_IMAGE_RIGHT_INDEX] = new Image();
   this.imagesArray[this.INACTIVE_IMAGE_RIGHT_INDEX].src = this.fInactiveImageRight;
   
   
   }

      
   function tabset_hasRequiredValue()
   {
    if (!this.fRequired) return true;
    return !this.selectionModel.isEmpty(); 
   }

   function tabset_repaint()
   {
    var size   = this.dataModel.getSize();
    var select = this.selectionModel.getSelectedItem();

    for (i = 0; i < size; i++ )
    {
     if (i != select)
     {
      eval(TAB_VARIABLE_PREFIX + this.fId + "_" + i +".tpaint(false)");  
     } 
     else 
      {
       eval(TAB_VARIABLE_PREFIX + this.fId + "_" + i +".tpaint(true)");  
      }
    }
   }

   function tabset_setBigImages()
   {
    this.fTabKindOfImages = false;   
    this.repaint();
   }

   function tabset_setSmallImages()
   {
    this.fTabKindOfImages = true;
    this.repaint();
   }

   function getColors(tabActiveStyle,tabStyle,tabHLightStyle,propertyName)
   {
     var colorsArray = new Array(3);
    if(tabActiveStyle != null && tabActiveStyle != "")
    {
      var activePropertyString = getPropertyString(tabActiveStyle,propertyName);
      if(activePropertyString == null) 
      {
        colorsArray[0] = null;
      }
      else
      {
        colorsArray[0] = getStyleValue(activePropertyString);
      }  
    }
    
    if(tabStyle != null && tabStyle != "")
    {
      var propertyString = getPropertyString(tabStyle,propertyName);
      if(propertyString == null) 
      {
        colorsArray[1] = null;
      }
      else
      {
        colorsArray[1] = getStyleValue(propertyString);
      }   
    }
    
    if(tabHLightStyle != null && tabHLightStyle != "")
    {
      var hLightPropertyString = getPropertyString(tabHLightStyle,propertyName);
      if(hLightPropertyString == null)
      {
        colorsArray[2] = null;
      }
      else
      {
        colorsArray[2] = getStyleValue(hLightPropertyString);
      }   
    }
    return colorsArray;
   }
   
   function getTabColors(tabActiveStyle,tabStyle,tabHLightStyle)
   {
     var colorsArray = getColors(tabActiveStyle,tabStyle,tabHLightStyle,"color");
    this.fTabActiveColor = colorsArray[0];
    this.fTabColor = colorsArray[1];
    this.fTabHLightColor = colorsArray[2];
   }
   
   function getTabBgColors(tabActiveStyle,tabStyle,tabHLightStyle)
   {
     var colorsArray = getColors(tabActiveStyle,tabStyle,tabHLightStyle,"background-color");
    this.fTabActiveBgColor = colorsArray[0];
    this.fTabBgColor = colorsArray[1];
    this.fTabHLightBgColor = colorsArray[2];
   }
//*************************************************** 
