// Copyright:    Copyright (c) 2002-2003  .
//               All rights reserved.

// Company:      SoftAspects 
//
// @version      1.5

  function AbstractSelectionModel()
  {
   this.initSelection       = abstractSelectionModel_initSelection;
   this.selectionIsEmpty    = abstractSelectionModel_selectionIsEmpty;
   this.getSelectionsCount  = abstractSelectionModel_getSelectionsCount;
   this.getSelectionType    = abstractSelectionModel_getSelectionType;
   this.isSelectionAllowed  = abstractSelectionModel_isSelectionAllowed;
   this.isSelected          = abstractSelectionModel_isSelected;
   this.getSelectedIndex    = abstractSelectionModel_getSelectedIndex;
   this.getFreeIndex        = abstractSelectionModel_getFreeIndex;
   this.getMinIndex         = abstractSelectionModel_getMinIndex;
   this.getMaxIndex         = abstractSelectionModel_getMaxIndex;
   this.getSelection        = abstractSelectionModel_getSelection;

   this.setSelectionInterval= abstractSelectionModel_setSelectionInterval;
   this.clearSelection      = abstractSelectionModel_clearSelection;
   this.changeSelection     = abstractSelectionModel_changeSelection;
  }

   function abstractSelectionModel_initSelection()
   {
     for (var i = 0; i < this.initSelection.arguments.length; i++)
     {
      this.fSelected[ this.fSelected.length ] = this.initSelection.arguments[i];
     }
   }

   function abstractSelectionModel_isSelectionAllowed()
   {
    return this.fSelectionAllowed;
   }

   function abstractSelectionModel_getSelectionType()
   {
    return this.fSelectionTypes[ this.fSelectionType ];
   }

   function abstractSelectionModel_isSelected( aIndex )
   {
    var slength = this.fSelected.length;
    for (var i = 0; i < slength; i++ )
    {
     if (this.fSelected[i] == aIndex)
     {
      return true;
     }
    }
    return false;
   }

   function abstractSelectionModel_getSelectedIndex( aIndex )
   {
    var slength = this.fSelected.length;
    for (var i = 0; i < slength; i++ )
    {
     if ( this.fSelected[i] == aIndex)
     {
      return i;
     }
    }
    return -1;
   }

   function abstractSelectionModel_selectionIsEmpty()
   {
    var slength = this.fSelected.length;
    for (var i = 0; i < slength; i++ )
    {
     if (this.fSelected[i] != null) return false
    }
    return true;
   }

  function abstractSelectionModel_getSelectionsCount()
  {
    var result = 0;
    var slength = this.fSelected.length;
    for (var i = 0; i < slength; i++ )
    {
     if (this.fSelected[i] != null) result++;
    }
    return result;
  }

  function abstractSelectionModel_getFreeIndex()
  {
    var ind = this.fSelected.length;
    var slength = ind;
    for( var i = 0; i < slength; i++)
    {
       if (this.fSelected[i] == null)
       {
        ind = i;
        break;
       }
    }
    return ind;
  }

  function abstractSelectionModel_getMinIndex()
  {
    var minIndex = Number.MAX_VALUE;
    var slength = this.fSelected.length;
    for( var i = 0; i < slength; i++)
    {
     if (this.fSelected[i] != null && this.fSelected[i] < minIndex)
     {
       minIndex = this.fSelected[i];
      }
    }
    return minIndex;
  }

  function abstractSelectionModel_getMaxIndex()
  {
    var maxIndex = Number.MIN_VALUE;
    var slength = this.fSelected.length;
    for( var i = 0; i < slength; i++)
    {
     if (this.fSelected[i] != null && this.fSelected[i] > maxIndex)
     {
       maxIndex = this.fSelected[i];
     }
    }
    return maxIndex;
  }

  function abstractSelectionModel_getSelection()
  {
    return this.fSelected;
  } 

  function abstractSelectionModel_setSelectionInterval( aIndex )
  {
    this.clearSelection();
    this.addSelectionInterval( aIndex );
  }

  function abstractSelectionModel_clearSelection()
  {
    var slength = this.fSelected.length;
    for( var i = 0; i < slength; i++)
    {
     if (this.fSelected[i] != null)
     {
      this.removeSelectionInterval( this.fSelected[i] );
     }
    }
  }

  function abstractSelectionModel_changeSelection( aIndex )
  {
    var type = this.getSelectionType();
     
     if ( window.event.shiftKey || window.event.crtlKey)
     {
       document.selection.empty();
     }

    if ( this.isSelected(aIndex) && type != "SINGLE" )
    {
        if ( window.event.shiftKey && !this.selectionIsEmpty() )
         {
           for (var i = this.getMinIndex(); i < aIndex; i++)
           {
             this.removeSelectionInterval( i );
           }
         }
         else
         if ( type == "SINGLE_INTERVAL" && window.event.ctrlKey )
         {
              var minRow = this.getMinIndex();
              var maxRow = this.getMaxIndex();
           if ( this.getSelectionsCount() > 1 && (aIndex == maxRow || aIndex == minRow) )
           {
                this.removeSelectionInterval( aIndex );
           }
              else
               {
                 this.setSelectionInterval( aIndex );
            }
         }
         else  
            if ( !window.event.ctrlKey || type != "MULTIPLE" )
            {
              this.setSelectionInterval( aIndex );
            }
            else
             {
               this.removeSelectionInterval( aIndex );
             }
    }
    else
     {
          if ( type == "MULTIPLE" && window.event.ctrlKey )
          {
            this.addSelectionInterval( aIndex );
          }
          else
            if ( type == "SINGLE_INTERVAL" && window.event.ctrlKey )
            {
              var minRow = this.getMinIndex() - 1;
              var maxRow = this.getMaxIndex() + 1;
           if ( aIndex == maxRow || aIndex == minRow )
           {
                this.addSelectionInterval( aIndex );
           }
           else 
            {
                 this.setSelectionInterval( aIndex );
               }
            }
            else
                if (type != "SINGLE" && window.event.shiftKey && !this.selectionIsEmpty() )
                {
                  var minRow = this.getMinIndex();
                  var maxRow = this.getMaxIndex();

                  if (aIndex < minRow)
                  {
                    minRow = aIndex;
                  }
                  if (aIndex > maxRow)
                  {
                    maxRow = aIndex;
                  }

                  this.clearSelection();
                  for(var i = minRow; i <= maxRow; i++)
                  {
                    this.addSelectionInterval( i );
                  }
                }
                else
                  {
                    this.setSelectionInterval( aIndex );
                  }
     }
  }

// =====================================================================

  function RowSelectionModel(aObj, aRowSelectionAllowed, aRowSelectionType)
  {
   this.fObj                   = aObj;
   this.abstractSelectionModel = new AbstractSelectionModel();

   this.fSelectionAllowed      = aRowSelectionAllowed;
   this.fSelectionType         = aRowSelectionType;

   this.fSelectionTypes        = new Array();
   this.fSelectionTypes[1]     = "SINGLE";
   this.fSelectionTypes[2]     = "SINGLE_INTERVAL";
   this.fSelectionTypes[3]     = "MULTIPLE";

   this.fSelected              = new Array();

   this.initSelection          = this.abstractSelectionModel.initSelection;
   this.isRowSelectionAllowed  = this.abstractSelectionModel.isSelectionAllowed;
   this.isSelected             = this.abstractSelectionModel.isSelected;
   this.selectionIsEmpty       = this.abstractSelectionModel.selectionIsEmpty;
   this.getSelectionsCount     = this.abstractSelectionModel.getSelectionsCount;
   this.getSelectionType       = this.abstractSelectionModel.getSelectionType;
   this.getSelectedIndex       = this.abstractSelectionModel.getSelectedIndex;
   this.getFreeIndex           = this.abstractSelectionModel.getFreeIndex;
   this.getMinIndex            = this.abstractSelectionModel.getMinIndex;
   this.getMaxIndex            = this.abstractSelectionModel.getMaxIndex;
   this.setSelectionInterval   = this.abstractSelectionModel.setSelectionInterval;
   this.clearSelection         = this.abstractSelectionModel.clearSelection;
   this.getSelection           = this.abstractSelectionModel.getSelection;    

   this.setSelectionType       = rowSelectionModel_setSelectionType;
   this.addSelectionInterval   = rowSelectionModel_addSelectionInterval;
   this.removeSelectionInterval= rowSelectionModel_removeSelectionInterval;
   this.changeSelection        = this.abstractSelectionModel.changeSelection;
  }

   function rowSelectionModel_setSelectionType(aType)
   {

    if (aType < 1 || aType >= this.fSelectionTypes.length)
    {
     alert("RowSelectionModel: Type not supported.");
     return;
    }
    if (aType != this.fSelectionType)
    {
      this.fSelectionType = aType;
      this.fObj.addChangeRequest( "rmodel", this.getSelectionType() );
      this.setSelectionInterval( this.fObj.getFirstRowIndex() );
    }
   }

   function rowSelectionModel_removeSelectionInterval( aRow )
   {

    if ( this.isSelected(aRow) )
    {
     this.fSelected[ this.getSelectedIndex(aRow) ] = null;
     this.fObj.addChangeRequest( "rselect", "-" + aRow);

     if ( this.fObj.isRowVisible(aRow) )
     {
        var count = this.fObj.getColumnsCount()
        for( var i = 0; i < count; i++ )
        {
          var column   = this.fObj.fColumnsArray[i];
          var selected = this.fObj.columnSelectionModel.isSelected( column );
          var focused  = this.fObj.isCellFocused(aRow, column);
          var edited   = this.fObj.isCellEditable(aRow, column);
          this.fObj.setCellColor( selected, focused, edited, aRow, column);
        }
     }
    }
   }

   function rowSelectionModel_addSelectionInterval( aRow )
   {

    if ( !this.isSelected(aRow) || !this.isRowSelectionAllowed() )
    {
      var type = this.getSelectionType();
      if ( type == "SINGLE" && this.getSelectionsCount() > 0 )
      {
       return;
      }
      this.fSelected[ this.getFreeIndex() ] = aRow;
      this.fObj.addChangeRequest( "rselect", aRow);

      if ( this.fObj.isRowVisible(aRow) )
      {
        var count = this.fObj.getColumnsCount()
        for( var i = 0; i < count; i++ )
        {
          var column  = this.fObj.fColumnsArray[i];
          var focused = this.fObj.isCellFocused(aRow, column);
          var edited  = this.fObj.isCellEditable(aRow, column);
          this.fObj.setCellColor( true, focused, edited, aRow, column);
        }
      }
    }
   }

// ============================================================================

  function ColumnSelectionModel(aObj, aColumnSelectionAllowed, aColumnSelectionType)
  {
   this.fObj                     = aObj;
   this.abstractSelectionModel   = new AbstractSelectionModel();

   this.fSelectionAllowed        = aColumnSelectionAllowed;
   this.fSelectionType           = aColumnSelectionType;

   this.fSelectionTypes          = new Array();
   this.fSelectionTypes[1]       = "SINGLE";
   this.fSelectionTypes[2]       = "SINGLE_INTERVAL";
   this.fSelectionTypes[3]       = "MULTIPLE";

   this.fSelected                = new Array();

   this.initSelection            = this.abstractSelectionModel.initSelection;
   this.isColumnSelectionAllowed = this.abstractSelectionModel.isSelectionAllowed;
   this.isSelected               = this.abstractSelectionModel.isSelected;
   this.selectionIsEmpty         = this.abstractSelectionModel.selectionIsEmpty;
   this.getSelectionsCount       = this.abstractSelectionModel.getSelectionsCount;
   this.getSelectionType         = this.abstractSelectionModel.getSelectionType;
   this.getSelectedIndex         = this.abstractSelectionModel.getSelectedIndex;
   this.getFreeIndex             = this.abstractSelectionModel.getFreeIndex;
   this.getMinIndex              = this.abstractSelectionModel.getMinIndex;
   this.getMaxIndex              = this.abstractSelectionModel.getMaxIndex;
   this.setSelectionInterval     = this.abstractSelectionModel.setSelectionInterval;
   this.clearSelection           = this.abstractSelectionModel.clearSelection;
   this.getSelection             = this.abstractSelectionModel.getSelection;

   this.setSelectionType         = columnSelectionModel_setSelectionType;
   this.addSelectionInterval     = columnSelectionModel_addSelectionInterval;
   this.removeSelectionInterval  = columnSelectionModel_removeSelectionInterval;
   this.changeSelection          = this.abstractSelectionModel.changeSelection;
  }

   function columnSelectionModel_setSelectionType(aType)
   {

    if (aType < 1 || aType >= this.fSelectionTypes.length)
    {
     alert("ColumnSelectionModel: Illegal argument exception. Type not supported.");
     return;
    }

    if (aType != this.fSelectionType)
    {
      this.fSelectionType = aType;
      this.fObj.addChangeRequest( "cmodel", this.getSelectionType() );
      this.setSelectionInterval( 0 );  // first show row
    }
   }

   function columnSelectionModel_removeSelectionInterval( aColumn )
   {

    if ( this.isSelected(aColumn) )
    {
     this.fSelected[ this.getSelectedIndex( aColumn ) ] = null;
     this.fObj.addChangeRequest( "cselect", "-" + aColumn);

     if ( this.fObj.isHeaderVisible() )
     {
       var sorted  = this.fObj.isSortColumn( aColumn );
       var focused = this.fObj.isHeaderFocused( aColumn );
       this.fObj.setHeaderColor(false, sorted, focused, aColumn);
     }

     var firstRow = this.fObj.getFirstRowIndex();
     var lastRow  = this.fObj.getLastRowIndex();
     for( var i = firstRow; i <= lastRow; i++ )
     {
       var selected = this.fObj.rowSelectionModel.isSelected( i );
       var focused  = this.fObj.isCellFocused(i, aColumn);
       var edited   = this.fObj.isCellEditable(i, aColumn);
       this.fObj.setCellColor( selected, focused, edited, i, aColumn);
     }
    }
   }

   function columnSelectionModel_addSelectionInterval( aColumn )
   {

    var type = this.getSelectionType();

    if ( type == "SINGLE" && this.getSelectionsCount() > 0 )
    {
     return;
    }
    if ( !this.isSelected(aColumn) )
    {
      this.fSelected[ this.getFreeIndex() ] = aColumn;
      this.fObj.addChangeRequest( "cselect", aColumn);

      if ( this.fObj.isHeaderVisible() )
      {
       var sorted  = this.fObj.isSortColumn( aColumn );
       var focused = this.fObj.isHeaderFocused( aColumn );
       this.fObj.setHeaderColor(true, sorted, focused, aColumn);
      }

      var firstRow = this.fObj.getFirstRowIndex();
      var lastRow  = this.fObj.getLastRowIndex();
      for( var i = firstRow; i <= lastRow; i++ )
      {
        var focused  = this.fObj.isCellFocused(i, aColumn);
        var edited   = this.fObj.isCellEditable(i, aColumn);
        this.fObj.setCellColor( true, focused, edited, i, aColumn);
      }
    }
   }

// ============================================================================

   function TableDataModel( aObj, aFunctionOnDataChanged )
   {
    this.fObj = aObj;
    this.fFunctionOnDataChanged = aFunctionOnDataChanged;

    this.setValue         = tabledatamodel_setValue;
    this.getValue         = tabledatamodel_getValue;
    this.getColumnsCoumnt = tabledatamodel_getColumnsCoumnt;
    this.getRowsCoumnt    = tabledatamodel_getRowsCoumnt;
    this.isCellEditable   = tabledatamodel_isCellEditable;
   }

   function tabledatamodel_setValue( aRow, aColumn, aValue )
   {
     if ( !this.fObj.fSimpleVeiwMode && this.fObj.edit_changed(aRow, aColumn, aValue) )
     {
      var value = aValue;
      if ( typeof(aValue) == 'string' )
      {
       value = "'" + aValue + "'";
      }

      eval( this.fObj.getCellJs(aRow, aColumn) + ".setValue(" + value + ")" );
      if (this.fFunctionOnDataChanged != null)
      {
       eval( this.fFunctionOnDataChanged + "(" + aRow + "," + aColumn + "," + value + ")" );
      }
     }
   }

   function tabledatamodel_getValue( aRow, aColumn )
   {
     if ( !this.fObj.fSimpleVeiwMode && this.fObj.isCellVisible(aRow, aColumn) )
     {
      return eval( this.fObj.getCellJs(aRow, aColumn) + ".getValue()");
     }
     return null;
   }

   function tabledatamodel_isCellEditable( aRow, aColumn )
   {
     if ( !this.fObj.fSimpleVeiwMode && this.fObj.isCellVisible(aRow, aColumn) )
     {
       return eval( this.fObj.getCellJs(aRow, aColumn) + ".isEditable()");
     }
     return null;
   }

   function tabledatamodel_getColumnsCoumnt()
   {
    return this.fObj.getColumnsCoumnt();
   }

   function tabledatamodel_getRowsCoumnt()
   {
    return this.fObj.getRowsCoumnt();
   }


// ============================================================================

  function TableComponent(aId, aFormId, aColumnsCount, aFirstRowIndex,
                                                        aLastRowIndex,
                                                        aSortedColumn,
                                                           aSortedAsc,
                                                 aRowSelectionAllowed,
                                              aColumnSelectionAllowed,
                                                    aRowSelectionType,
                                                 aColumnSelectionType,
                                                          aCountPages,
                                                         aCurrentPage,
                                               aFunctionOnDataChanged,
                                                      aHeaderVisisble,
                                                     aInplaceEditMode,
                                          aSimpleViewMode
                                                                     )

  {

   this.fComponent       = new Component(aId);
   this.fObj             = this.fComponent.getObj();

   this.getId            = this.fComponent.getId;
   this.getName          = this.fComponent.getName;
   this.setName          = this.fComponent.setName;
   this.getHintText      = this.fComponent.getHintText;
   this.setHintText      = this.fComponent.setHintText;
   this.getStyleClass    = this.fComponent.getStyleClass;
   this.setStyleClass    = this.fComponent.setStyleClass;
   this.isEnabled        = this.fComponent.isEnabled;
   this.setEnabled       = this.fComponent.setEnabled;
   this.getStyle         = this.fComponent.getStyle;
   this.getStyleString   = this.fComponent.getStyleString;
   this.setStyleString   = this.fComponent.setStyleString;

   this.fFormId                 = aFormId;
   this.fColumnsCount           = aColumnsCount;
   this.fFirstRowIndex          = aFirstRowIndex;
   this.fLastRowIndex           = aLastRowIndex;
   this.fSortedColumn           = aSortedColumn;
   this.fSortedAsc              = aSortedAsc;
   this.fCurrentPage            = aCurrentPage;
   this.fCountPages             = aCountPages;
   this.fHeaderVisisble         = aHeaderVisisble;
   this.fColumnSelectionAllowed = aColumnSelectionAllowed;
   this.fRowSelectionAllowed    = aRowSelectionAllowed;
   this.fFunctionOnDataChanged  = aFunctionOnDataChanged;
   this.fInplaceEditMode        = aInplaceEditMode;
   this.fSimpleViewMode         = aSimpleViewMode;

   this.fFocusedHeader          =  -1;
   this.fFocusedColumn          =  -1;
   this.fFocusedRow             =  -1;
   this.fEditedColumn           =  -1;
   this.fEditedRow              =  -1;
   this.fFocusedObject          = null;
   this.fColumnsArray           = new Array();
   this.fEditModeArray          = new Array();
   this.fRunning                = false;

   this.addChangeRequest    = table_addChangeRequest;
   this.optimizeSelect      = table_optimizeSelect;
   this.optimizeChange      = table_optimizeChange;
   this.initVisisbleColumns = table_initVisisbleColumns;
   this.initEditModeCells   = table_initEditModeCells;
   this.addEditModeCell     = table_addEditModeCell;
   this.removeEditModeCell  = table_removeEditModeCell;
   this.refresh             = table_refresh;

   this.getColumnsCount     = table_getColumnsCount;
   this.getFirstRowIndex    = table_getFirstRowIndex;
   this.getLastRowIndex     = table_getLastRowIndex;
   this.getRowsCount        = table_getRowsCount;
   this.getCurrentPage      = table_getCurrentPage;
   this.getCountPages       = table_getCountPages;

   this.getColumSortedKey   = table_getColumSortedKey;
   this.isSortColumn        = table_isSortColumn;
   this.changeSortColumn    = table_changeSortColumn;

   this.isRowVisible        = table_isRowVisible;
   this.isColumnVisible     = table_isColumnVisible;
   this.isCellVisible       = table_isCellVisible;
   this.isHeaderVisible     = table_isHeaderVisisble;
   this.isCellSelected      = table_isCellSelected;
   this.isCellFocused       = table_isCellFocused;
   this.isCellEditMode      = table_isCellEditMode;
   this.isCellChanged       = table_isCellChanged;
   this.isHeaderFocused     = table_isHeaderFocused;
   this.isCellEditable      = table_isCellEditable;
   this.isEditInplaceMode   = table_isEditInplaceMode;

   if ( aRowSelectionAllowed  ||  aColumnSelectionAllowed )
   {
    this.rowSelectionModel    = new RowSelectionModel   ( this, aRowSelectionAllowed, aRowSelectionType );
    this.columnSelectionModel = new ColumnSelectionModel( this, aColumnSelectionAllowed, aColumnSelectionType );
   }

   this.getCellBackground    = eval( this.getId() + "_interfaceManager_getCellBackground");
   this.getHeaderBackground  = eval( this.getId() + "_interfaceManager_getHeaderBackground");

   if ( !aSimpleViewMode )
   {
     this.dataModel            = new TableDataModel( this, aFunctionOnDataChanged );
     this.getCellForeground    = eval( this.getId() + "_interfaceManager_getCellForeground");
     this.getHeaderForeground  = eval( this.getId() + "_interfaceManager_getHeaderForeground");
   }

   this.getCellId           = table_getCellId;
   this.getCellJs           = table_getCellJs;
   this.getHeaderId         = table_getHeaderId;
   this.getHeaderJs         = table_getHeaderJs;
   this.convertRowValue     = table_convertRowValue;
   this.convertColumnValue  = table_convertColumnValue;
   this.setCellColor        = table_setCellColor;
   this.setHeaderColor      = table_setHeaderColor;

   this.cell_focus          = table_cell_focus;
   this.cell_blur           = table_cell_blur;
   this.header_focus        = table_header_focus;
   this.header_blur         = table_header_blur;

   this.edit_changed        = table_edit_changed;
   this.edit_focus          = table_edit_focus;
   this.edit_blur           = table_edit_blur;
   this.setEditMode         = table_setEditMode;

   this.pageUp              = table_pageUp;
   this.pageDown            = table_pageDown;
   this.pageStart           = table_pageStart;
   this.pageEnd             = table_pageEnd;
   this.goToPage             = table_goToPage;
   this.changePageSize             = table_changePageSize;


   this.columnSelection     = table_columnSelection;
   this.rowSelection        = table_rowSelection;
  }

  function table_getColumnsCount()
  {
   return this.fColumnsCount;
  }

  function table_getFirstRowIndex()
  {
   return this.fFirstRowIndex;
  }

  function table_getLastRowIndex()
  {
   return this.fLastRowIndex;
  }

  function table_getRowsCount()
  {
   return this.fLastRowIndex - this.fFirstRowIndex;
  }

  function table_addChangeRequest(aParam, aValue)
  {

   if (aParam != null)
   {
    var result = true;
    if (aParam == "rselect" || aParam == "cselect")
    {
     result = this.optimizeSelect(aParam, aValue);
    }
    else
     if (aParam == "change")
     {
      this.optimizeChange(aValue);
     }

    if (result)
    {
     this.fFormId[ aParam ].value += aValue;
     this.fFormId[ aParam ].value += ";";
    }
   }
  }

  function table_optimizeSelect(aParam, aValue)
  {
   var value = new String(aValue);

   if ( value.charAt(0) == '-' )
   {
    value = value.substring(1, value.length);
   }
   else
    {
     value = "-" + value;
    }

   var field = this.fFormId[ aParam ];
   var ind = field.value.indexOf( value );
   if (ind >= 0 )
   {
    var oldValue  = field.value;
    var separator = oldValue.indexOf(';', ind);

    field.value = oldValue.substring(0, ind);
    if (separator >= 0)
    {
      field.value += oldValue.substring(separator + 1, oldValue.length)
    }
    return false;
   }

   return true;
  }

  function table_optimizeChange(aValue)
  {
   var value = new String(aValue)
   var index = value.substring( 0, value.lastIndexOf("^"));

   var field = this.fFormId[ 'change' ];
   var ind   = field.value.indexOf( index );
   if (ind >= 0 )
   {
    var oldValue  = field.value;
    var separator = oldValue.indexOf(';', ind);

    field.value = oldValue.substring(0, ind);
    if (separator >= 0)
    {
     field.value += oldValue.substring(separator + 1, oldValue.length)
    }
   }
  }

  function table_refresh()
  {
   var form = this.fFormId;
   for (var i = 0; i < form.all.length; i++)
   {
    var field = form.all[i];
    if (field.value == "")
    {
     field.name = "";
    }
   }
   this.fFormId.submit();
  }

  function table_isRowVisible( aRow )
  {
   return (aRow >= this.fFirstRowIndex && aRow <= this.fLastRowIndex);
  }

  function table_isHeaderVisisble()
  {
   return this.fHeaderVisisble;
  }

  function table_initVisisbleColumns()
  {
    var slength = this.initVisisbleColumns.arguments.length;
    for (var i = 0; i < slength; i++)
    {
     this.fColumnsArray[ this.fColumnsArray.length ] = this.initVisisbleColumns.arguments[i];
    }
  }

  function table_initEditModeCells()
  {
    var slength = this.initEditModeCells.arguments.length;
    for (var i = 0; i < slength; i += 2)
    {
     var cell = new Array( this.initEditModeCells.arguments[i],
                           this.initEditModeCells.arguments[i + 1] );

     this.fEditModeArray[ this.fEditModeArray.length ] = cell;
    }
  }

  function table_addEditModeCell(aRow, aColumn)
  {
    var ind = this.fEditModeArray.length;
    var slength = ind;
    for (var i = 0; i < slength; i++)
    {
      if ( this.fEditModeArray[i] == null)
      {
        ind = i;
    break;
      }
    }
    var cell = new Array( aRow, aColumn);
    this.fEditModeArray[ ind ] = cell;
  }

  function table_removeEditModeCell(aRow, aColumn)
  {
    var slength = this.fEditModeArray.length;
    for (var i = 0; i < slength; i++)
    {
     var cell = this.fEditModeArray[i];
     if (cell != null && cell[0] == aRow && cell[1] == aColumn)
     {
      this.fEditModeArray[i] = null;
     }
    }
  }

  function table_isColumnVisible( aColumn )
  {
   var slength = this.fColumnsArray.length;
   for (var i = 0; i < slength; i++)
   {
    if ( this.fColumnsArray[i] == aColumn)
    {
     return true;
    }
   }
   return false;
  }

  function table_isCellVisible( aRow, aColumn )
  {
   return this.isRowVisible( aRow ) && this.isColumnVisible( aColumn );
  }

  function table_isCellSelected( aRow, aColumn )
  {
   if ( this.fRowSelectionAllowed || this.fColumnSelectionAllowed ) 
   {
    return this.rowSelectionModel.isSelected( aRow ) ||
           this.columnSelectionModel.isSelected( aColumn );
   }
   return false; 
  }

  function table_isCellFocused( aRow, aColumn )
  {
   return aRow == this.fFocusedRow && aColumn == this.fFocusedColumn;
  }

  function table_isCellEditMode(aRow, aColumn )
  {
   var slength = this.fEditModeArray.length;
   for (var i = 0; i < slength; i++)
   {
     var cell = this.fEditModeArray[i];
     if (cell != null && cell[0] == aRow && cell[1] == aColumn)
     {
      return true;
     }
   }
   return false;
  }

  function table_isCellEditable(aRow, aColumn )
  {
   return aRow == this.fEditedRow && aColumn == this.fEditedColumn;
  }

  function table_isEditInplaceMode()
  {
   return this.fInplaceEditMode;
  }

  function table_isCellChanged(aRow, aColumn )
  {
   var field = this.fFormId[ 'change' ];
   var index = aRow + "^" + aColumn;

   return ( field.value.indexOf( index ) >= 0 );
  }

  function table_isHeaderFocused( aColumn )
  {
   return aColumn == this.fFocusedHeader;
  }

  function table_getColumSortedKey()
  {
   return this.fSortedColumn;
  }

  function table_isSortColumn( aColumn )
  {
   return aColumn == this.getColumSortedKey();
  }

  function table_changeSortColumn( aColumn )
  {
   var sortedColumn = this.getColumSortedKey();

   if (this.isSortColumn( aColumn ) && this.fSortedAsc)
   {
    this.addChangeRequest("sort", "-" + aColumn);
   }
   else
    {
     this.addChangeRequest("sort", aColumn );
    }
   this.refresh();
  }

  function table_getCurrentPage()
  {
   return this.fCurrentPage;
  }

  function table_getCountPages()
  {
   return this.fCountPages - 1;
  }

  function table_pageUp()
  {
   if ( this.getCurrentPage() < this.getCountPages() )
   {
    this.addChangeRequest("page", "forward");
    this.refresh();
   }
  }

  function table_changePageSize(pageSize)
  {
      paramValue = "page_size:" + pageSize;

      //alert("VALUE : " + paramValue);

      this.addChangeRequest("page", paramValue);
      this.refresh();
  }

  function table_goToPage(pageNumber)
  {
    this.addChangeRequest("page", pageNumber);
    this.refresh();
  }

  function table_pageDown()
  {
   if ( this.getCurrentPage() != 0 )
   {
    this.addChangeRequest("page", "backward");
    this.refresh();
   }
  }

  function table_pageStart()
  {
   if ( this.getCurrentPage() != 0 )
   {
    this.addChangeRequest("page", "start");
    this.refresh();
   }
  }

  function table_pageEnd()
  {
   if ( this.getCurrentPage() < this.getCountPages() )
   {
    this.addChangeRequest("page", "end");
    this.refresh();
   }
  }

//**************************************************

 function table_convertRowValue( aRow )
 {
   var row = new Number(aRow) + this.getFirstRowIndex();
   return ( row > this.getLastRowIndex() ) ?  -1 : row;
 }

 function table_convertColumnValue( aColumn )
 {
   if (aColumn >= 0 && aColumn < this.fColumnsArray.length)
   {
    return this.fColumnsArray[ aColumn ];
   }
   return -1;
 }

 function table_getCellId(aRow, aColumn)
 {
  return this.getId() + "_" + aRow + "_" + aColumn;
 }

 function table_getCellJs( aRow, aColumn )
 {
  var object = "cell_" + this.getCellId(aRow, aColumn);
  return object + ( this.isCellEditMode(aRow, aColumn) ? "_e" : "_c" );
 }

 function table_getHeaderId( aColumn )
 {
  return this.getId() + "_" + aColumn;
 }

 function table_getHeaderJs( aColumn )
 {
  return "header_" + this.getHeaderId( aColumn ) + "_c";
 }

 function table_setCellColor(aSelected, aFocused, aEdited, aRow, aColumn)
 {
   var background = this.getCellBackground(aSelected, aFocused, aEdited, aRow, aColumn);
   var object = eval( this.getCellId( aRow, aColumn) );
   object.style.background = background;

   var slength = object.all.length;
   for (var i = 0; i < slength; i++)
   {
    var style = object.all[i].style;
    if (style.backgroundColor != "transparent")
    {
     style.backgroundColor = background;
    }
   }

   if ( !this.fSimpleViewMode )
   {
     var foreground = this.getCellForeground(aSelected, aFocused, aEdited, aRow, aColumn);
     eval( this.getCellJs( aRow, aColumn) + ".setColor('" + foreground + "')");
   }
 }

 function table_setHeaderColor(aSelected, aSorted, aFocused, aColumn)
 {
   var background = this.getHeaderBackground(aSelected, aSorted, aFocused,  aColumn);
   eval( this.getHeaderId( aColumn) + ".style.background='" + background +"'");

   if ( !this.fSimpleViewMode )
   {
     var foreground = this.getHeaderForeground(aSelected, aSorted, aFocused,  aColumn);
     eval( this.getHeaderJs( aColumn) + ".setColor('" + foreground + "')");
   }
 }

 function table_edit_changed( aRow, aColumn, aValue )
 {
   if ( !this.isCellVisible(aRow, aColumn) )
   {
     alert("Cell " + aRow + " x " + aColumn + " is not present on client side.");
     return false;
   }
   if ( !this.dataModel.isCellEditable(aRow, aColumn) )
   {
     alert("Cell " + aRow + " x " + aColumn + " is not editable.");
     return false;
   }
   this.addChangeRequest( "change", aRow + "^" + aColumn + "^" + aValue);
   return true;
 }

 function table_cell_focus(aRow, aColumn )
 {
  if (window.event != null &&  window.event.fromElement == null)
  {
    var object = window.event.toElement;
    if ( object != null && object.options != null)
    {
     return;
    }
  }

  if ( !this.fRunning )
  {
   this.fRunning = true;
   var selected  = this.isCellSelected( aRow, aColumn );
   var edited    = this.isCellEditable( aRow, aColumn );

   this.setCellColor( selected, true, edited, aRow, aColumn );
   this.fFocusedColumn = aColumn;
   this.fFocusedRow    = aRow;
   this.fRunning       = false;
  }
 }


 function table_cell_blur( aRow, aColumn )
 {
  if (window.event != null && window.event.toElement == null)
  {
    var object = window.event.fromElement;
    if ( object != null && object.options != null)
    {
     return;
    }
  }

  if ( !this.fRunning )
  {
   this.fRunning = true;
   var selected  = this.isCellSelected( aRow, aColumn );
   var edited    = this.isCellEditable( aRow, aColumn );

   this.setCellColor( selected, false, edited, aRow, aColumn );
   this.fFocusedColumn = -1;
   this.fFocusedRow    = -1;
   this.fRunning       = false;
  }
 }

 function table_header_focus( aColumn )
 {
  if ( !this.fRunning )
  {
   this.fRunning = true;
   var sorted    = this.isSortColumn( aColumn );
   var selected  = ( this.fColumnSelectionAllowed ) ? this.columnSelectionModel.isSelected( aColumn ) : false;

   this.setHeaderColor( selected, sorted, true, aColumn );
   this.fFocusedHeader = aColumn;
   this.fRunning       = false;
  }
 }

 function table_header_blur( aColumn )
 {
  if ( !this.fRunning )
  {
   this.fRunning = true;
   var sorted    = this.isSortColumn( aColumn );
   var selected  = ( this.fColumnSelectionAllowed ) ? this.columnSelectionModel.isSelected( aColumn ) : false;

   this.setHeaderColor( selected, sorted, false, aColumn );
   this.fFocusedHeader = -1;
   this.fRunning       = false;
  }
 }

 function table_edit_focus(aRow, aColumn)
 {
   this.fEditedColumn = aColumn;
   this.fEditedRow    = aRow;
   this.cell_focus(aRow, aColumn);
 }

 function table_edit_blur( aRow, aColumn )
 {
   this.fEditedColumn = -1;
   this.fEditedRow    = -1;

   if ( this.isEditInplaceMode() && !this.isCellChanged(aRow, aColumn) )
   {
    var cellId = this.getCellId(aRow, aColumn);

    eval( cellId + "_hide.style.display='none'");
    eval( cellId + "_view.style.display='block'");
    this.removeEditModeCell(aRow, aColumn);

    var selected = this.isCellSelected( aRow, aColumn );
    this.setCellColor( selected, false, false, aRow, aColumn );
    this.cell_blur( aRow, aColumn )
   }
 }

 function table_setEditMode( aRow, aColumn )
 {
  if (!this.isCellEditMode(aRow, aColumn))
  {
    var cellId  = this.getCellId(aRow, aColumn);
    var editCmp = eval( cellId + "_hide");

    editCmp.style.width  = eval( cellId ).clientWidth  - 2 * this.fObj.cellPadding;
    editCmp.style.height = eval( cellId ).clientHeight - 2 * this.fObj.cellPadding;
    editCmp.style.display="block";
    eval( cellId + "_view.style.display='none'" );

    this.addEditModeCell(aRow, aColumn);

    if (this.fEditedRow > 0 && this.fEditedColumn > 0)
    {
     this.edit_blur(this.fEditedRow, this.fEditedColumn)
    }
    eval(this.getCellJs(aRow, aColumn) + ".setFocus()");
   }
 }

 function table_columnSelection( aColumn )
 {
  this.columnSelectionModel.changeSelection( aColumn );
 }

 function table_rowSelection( aRow )
 {
  this.rowSelectionModel.changeSelection( aRow );
 }

//***************************************************