// CoreCombo.cpp : implementation file
//

#include "stdafx.h"
#include "cutecontrols.h"
#include "CoreCombo.h"
#include "CuteBar.h"
#include "Combo.h"
#include "ReturnLong.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCoreCombo
IMPLEMENT_DYNAMIC(CCoreCombo,CComboBox)

CCoreCombo::CCoreCombo(CICombo* pHolder)
{
    ASSERT(pHolder);
    m_pHolder = pHolder;
}

CCoreCombo::~CCoreCombo()
{
}

BEGIN_MESSAGE_MAP(CCoreCombo, CComboBox)
	//{{AFX_MSG_MAP(CCoreCombo)
	ON_CONTROL_REFLECT(CBN_SETFOCUS, OnSetfocus)
	ON_CONTROL_REFLECT(CBN_KILLFOCUS, OnKillfocus)
	ON_CONTROL_REFLECT(CBN_SELCHANGE, OnSelchange)
	ON_CONTROL_REFLECT(CBN_DROPDOWN, OnDropdown)
	ON_CONTROL_REFLECT(CBN_EDITCHANGE, OnEditchange)
	ON_CONTROL_REFLECT(CBN_CLOSEUP, OnCloseup)
	ON_WM_PARENTNOTIFY()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCoreCombo message handlers

void CCoreCombo::OnSetfocus() 
{
    ASSERT(m_pHolder);
    ASSERT(m_pHolder->m_pMainControl);

	CComPtr<IItem> pItem;
    HRESULT hr = m_pHolder->QueryInterface(IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
        m_pHolder->m_pMainControl->Fire_ItemGotFocus(pItem);
}

void CCoreCombo::OnKillfocus() 
{
    ASSERT(m_pHolder);
	ASSERT(m_pHolder->m_pMainControl);

    CComPtr<IItem> pItem;
    HRESULT hr = m_pHolder->QueryInterface(IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
	    m_pHolder->m_pMainControl->Fire_ItemLostFocus(pItem);	
}

void CCoreCombo::OnSelchange() 
{
    ASSERT(m_pHolder);
	ASSERT(m_pHolder->m_pMainControl);

    CComPtr<IItem> pItem;
    HRESULT hr = m_pHolder->QueryInterface(IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
	    m_pHolder->m_pMainControl->Fire_ComboSelChange(pItem);	
}

void CCoreCombo::OnDropdown() 
{
    ASSERT(m_pHolder);
	ASSERT(m_pHolder->m_pMainControl);

    CComPtr<IItem> pIItem;
    HRESULT hr = m_pHolder->QueryInterface(IID_IUnknown,(void**)&pIItem);
    CComPtr<IItem> pItem;
    hr = pIItem->QueryInterface(IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
    {
        m_pHolder->m_pMainControl->Fire_ComboDrop(pItem);
    }
}

void CCoreCombo::OnCloseup() 
{
    ASSERT(m_pHolder);
	ASSERT(m_pHolder->m_pMainControl);

    CComPtr<IItem> pItem;
    HRESULT hr = m_pHolder->QueryInterface(IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
	    m_pHolder->m_pMainControl->Fire_ComboClose(pItem);			
}

void CCoreCombo::OnEditchange() 
{
    ASSERT(m_pHolder);
	ASSERT(m_pHolder->m_pMainControl);

    CComPtr<IItem> pItem;
    HRESULT hr = m_pHolder->QueryInterface(IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
	    m_pHolder->m_pMainControl->Fire_TextChanged(pItem);				
}

void CCoreCombo::OnParentNotify(UINT message, LPARAM lParam) 
{
	CComboBox::OnParentNotify(message, lParam);	

    if ( LOWORD(message) == WM_CREATE)
    {
        //find Edit-window by classname compare next
        HWND hWnd = (HWND)lParam;
        static const TCHAR szEdit[] = _T("edit");

        TCHAR szCompare[sizeof(szEdit)/sizeof(szEdit[0])+1];
        ::GetClassName(hWnd, szCompare,
                       sizeof(szCompare)/sizeof(szCompare[0]) );
        BOOL bMatch = lstrcmpi(szCompare, szEdit) == 0;
        if (bMatch)
          m_Hook.Install(this,hWnd);
    }
    else if ( LOWORD(message) == WM_DESTROY && m_Hook.IsHooked())
    {
        m_Hook.Install(this,(HWND)NULL); // unhook
    }

}
void CCoreCombo::OnComboKeyDown( UINT nChar)
{
    ASSERT(m_pHolder);
    ASSERT(m_pHolder->m_pMainControl);
    CComPtr<IItem> pItem;
    HRESULT hr = m_pHolder->QueryInterface(IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
	    m_pHolder->m_pMainControl->Fire_ItemKeyDown(pItem, nChar, _ShiftState());	
}

void CCoreCombo::OnComboKeyUp( UINT nChar)
{
    ASSERT(m_pHolder);
	ASSERT(m_pHolder->m_pMainControl);
    CComPtr<IItem> pItem;
    HRESULT hr = m_pHolder->QueryInterface(IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
	    m_pHolder->m_pMainControl->Fire_ItemKeyUp(pItem, nChar, _ShiftState());	
}

void CCoreCombo::OnComboKeyPress( UINT& nChar)
{
    ASSERT(m_pHolder);

    CComObject<CReturnLong>* pObj;
    CComPtr<IReturnLong> pIRetlong;
    CComPtr<IReturnLong> pVal;

    CComObject<CReturnLong>::CreateInstance(&pObj);
    pObj->QueryInterface(&pIRetlong);
    pIRetlong.p->QueryInterface(IID_IDispatch,(void**)&pVal);

    pObj->m_lValue =(long)nChar;
	ASSERT(m_pHolder->m_pMainControl);

    CComPtr<IItem> pItem;
    HRESULT hr = m_pHolder->QueryInterface(IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
    	m_pHolder->m_pMainControl->Fire_ItemKeyPress(pItem, pVal);

    nChar = (UINT)pObj->m_lValue;
}


void CCoreCombo::OnDestroy() 
{
    ASSERT(m_pHolder);
//    GetWindowText(m_pHolder->m_WndText);
    CComboBox::OnDestroy();	
	// TODO: Add your message handler code here	
}
