////////////////////////////////////////////////////////////////
// Copyright 1999-2001 Dmitri Sviridov, ActiveXStore.com
// 
//
// Edit.h : Declaration of the CICEdit

#ifndef __EDIT_H_
#define __EDIT_H_

#include "resource.h"       // main symbols

class CIItem;
class CICuteBar;

extern short  _ShiftState();

/////////////////////////////////////////////////////////////////////////////
// CICEdit
class ATL_NO_VTABLE CICEdit : public CEdit,
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CICEdit, &CLSID_Edit>,
	public IDispatchImpl<IEdit, &IID_IEdit, &LIBID_CuteControlsLib>
{
public:
	CICEdit();
	~CICEdit();

    CICuteBar * m_pMainControl; 
    
public:
    BOOL Create(DWORD dwStyle, const RECT &rect, CWnd *pParentWnd, UINT nID);
    virtual void Serialize(CArchive &ar);
    void SetFocus();
    void Update();
    void SetMainControl(CICuteBar *pControl){ m_pMainControl = pControl;}
    void SetHolder(CIItem* pHolder);

DECLARE_REGISTRY_RESOURCEID(IDR_EDIT)

DECLARE_NOT_AGGREGATABLE(CICEdit)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CICEdit)
	COM_INTERFACE_ENTRY(IEdit)
	COM_INTERFACE_ENTRY(IDispatch)
END_COM_MAP()

// IEdit
public:
	CWnd* GetControl();
	STDMETHOD(get_Border)(/*[out, retval]*/ VARIANT_BOOL *pVal);
	STDMETHOD(put_Border)(/*[in]*/ VARIANT_BOOL newVal);
	STDMETHOD(get_PasswordChar)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_PasswordChar)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_Text)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Text)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_MaxLength)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_MaxLength)(/*[in]*/ long newVal);
	STDMETHOD(get_ReadOnly)(/*[out, retval]*/ VARIANT_BOOL *pVal);
	STDMETHOD(put_ReadOnly)(/*[in]*/ VARIANT_BOOL newVal);
//    CBarEditButton* m_pEditButton;
protected:
    CString   m_String;     // Edit string for Serialization
    TCHAR m_PasswordCh;     //Password char
    int   m_TextLimit;
    BOOL  m_bReadOnly;
    BOOL  m_bBorder;
    DWORD m_dwStyle;

	CIItem* m_pHolder;

	// Generated message map functions
protected:
	//{{AFX_MSG(CICEdit)
	afx_msg void OnChange();
	afx_msg void OnKillfocus();
	afx_msg void OnSetfocus();
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

#endif //__EDIT_H_
