unit FR_E_PDF;
interface
uses PDF, FR_Class, Classes, windows, sysutils;

type
  TfrPDFExport = class(TfrExportFilter)
  private
    FPDF: TPDFDocument;
    FP: Boolean;
    CurPage: Integer;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure OnBeginPage; override;
    procedure OnBeginDoc; override;
    procedure OnEndDoc; override;
    procedure OnData(x, y: Integer; View: TfrView); override;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('llPDFLib', [TfrPDFExport]);
end;


{ TfrPDFExport }

constructor TfrPDFExport.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FPDF := TPDFDocument.Create(Self);
  if ClassName = 'TfrPDFExport' then
    frRegisterExportFilter(Self, 'Adobe Acrobat Documents (*.pdf)', '*.pdf');
end;

destructor TfrPDFExport.Destroy;
begin
  frUnRegisterExportFilter(Self);
  FPDF.Free;
  inherited;
end;

procedure TfrPDFExport.OnBeginDoc;
var
  DC: HDC;
begin
  inherited;
  FPDF.FileName := FileName;
  FPDF.OutputStream := Stream;
  FPDF.Compression:=ctFlate;
  DC := GetDC(0);
  FPDF.Resolution := GetDeviceCaps(dc, LOGPIXELSX);
  ReleaseDC(0, DC);
  FPDF.BeginDoc;
  FP := True;
  CurPage := -1;
end;
procedure TfrPDFExport.OnBeginPage;
begin
  Inc(CurPage);
  if CurPage <>0 then FPDF.NewPage;
  FPDF.CurrentPage.Width := CurReport.EMFPages[CurPage].R.Right-CurReport.EMFPages[CurPage].R.Left;
  FPDF.CurrentPage.Height := CurReport.EMFPages[CurPage].R.Bottom-CurReport.EMFPages[CurPage].R.Top;
end;

procedure TfrPDFExport.OnData(x, y: Integer; View: TfrView);
begin
  View.Draw(FPDF.Canvas);
end;

procedure TfrPDFExport.OnEndDoc;
begin
  try
    FPDF.EndDoc;
  except
    on Exception do
    begin
      FPDF.Abort;
      raise;
    end;
  end;
end;

end.

