{
For CCITT compression need use external converter. 
Here we use TIFCCITT.PAS from ImageEn library http://www.hicomponents.com
}
program ImageCompression;
{$APPTYPE CONSOLE}
uses
  SysUtils,windows,
  PDF,classes,
  Graphics, tifccitt;
Type
  TCCITTPDF=class(TPDFDocument)
  procedure SaveBMPtoCCITT(BM: TBitmap; AStream: TStream; CCITTClass: TCCITTClass);
  end;

var
  MyPDF: TCCITTPDF;
  I: Integer;
{ TCCITTPDF }

resourcestring
  SBitmapNotMonochrome = 'Cannot compress not monochrome image via CCITT';
procedure InvertBitmap(Bitmap: TBitmap);
var
  x, y, dx: integer;
  w: pword;
begin
  dx := abs(integer(bitmap.scanline[1]) - integer(bitmap.scanline[0])) div 2;
  for y := 0 to bitmap.Height - 1 do begin
    w := bitmap.scanline[y];
    for x := 0 to dx - 1 do begin
      w^ := not w^;
      inc(w);
    end;
  end;
end;

procedure TCCITTPDF.SaveBMPtoCCITT(BM: TBitmap; AStream: TStream; CCITTClass: TCCITTClass);
var
  bwr: Byte;
  bwrl: Integer;
  predline: PByte;
  row: Integer;
  B: TBitmap;
  a:Boolean;
begin
  if BM = nil then Exit;
  if BM.PixelFormat <> pf1bit then
    raise TPDFException.Create(SBitmapNotMonochrome);
  B := TBitmap.Create;
  try
    B.Assign(BM);
    InvertBitmap(B);
    bwrl := 0;
    predline := nil;
    for row := 0 to BM.Height - 1 do
      case CCITTClass of
        CCITT31D: CCITTHuffmanPutLineG3(pbyte(B.Scanline[row]), B.Width, AStream, bwr, bwrl,a);
        CCITT32D: CCITTHuffmanPutLineG32D(pbyte(B.Scanline[row]), B.Width, AStream, bwr, bwrl, predline,a);
        CCITT42D: CCITTHuffmanPutLineG4(pbyte(B.Scanline[row]), B.Width, AStream, bwr, bwrl, predline,a);
      end;
  finally
    B.Free;
  end;
  case CCITTClass of
    CCITT31D: CCITTHuffmanPutLineG3(nil, 0, AStream, bwr, bwrl,a);
    CCITT32D: CCITTHuffmanPutLineG32D(nil, 0, AStream, bwr, bwrl, predline,a);
    CCITT42D: CCITTHuffmanPutLineG4(nil, 0, AStream, bwr, bwrl, predline,a);
  end;

end;

begin
  try
    MyPDF := TCCITTPDF.Create(nil);
    try
      MyPDF.AutoLaunch := false;
      MyPDF.OnCCITTProcedure:=MyPDF.SaveBMPtoCCITT;
      MyPDF.Compression := ctFlate;
      MyPDF.FileName := 'Data\PDFFiles\Flate.pdf';
      MyPDF.DocumentInfo.Title := 'llPDFLib 2 Demo [Flate]';
      MyPDF.BeginDoc;
      I:=MyPDF.AddImage('Data\Images\logo.bmp',itcFlate);
      MyPDF.CurrentPage.Width:=310;
      MyPDF.CurrentPage.Height:=310;
      MyPDF.CurrentPage.ShowImage(I,5,5,300,300,0);
      try
        MyPDF.EndDoc;
      except
        on Exception do
        begin
          MyPDF.Abort;
          raise;
        end;
      end;
      MyPDF.FileName := 'Data\PDFFiles\CCITT3.pdf';
      MyPDF.DocumentInfo.Title := 'llPDFLib 2 Demo [CCITT3]';
      MyPDF.BeginDoc;
      I:=MyPDF.AddImage('Data\Images\logo.bmp',itcCCITT3);
      MyPDF.CurrentPage.Width:=310;
      MyPDF.CurrentPage.Height:=310;
      MyPDF.CurrentPage.ShowImage(I,5,5,300,300,0);
      try
        MyPDF.EndDoc;
      except
        on Exception do
        begin
          MyPDF.Abort;
          raise;
        end;
      end;
      MyPDF.FileName := 'Data\PDFFiles\CCITT3(2D).pdf';
      MyPDF.DocumentInfo.Title := 'llPDFLib 2 Demo [CCITT3(2D)]';
      MyPDF.BeginDoc;
      I:=MyPDF.AddImage('Data\Images\logo.bmp',itcCCITT32d);
      MyPDF.CurrentPage.Width:=310;
      MyPDF.CurrentPage.Height:=310;
      MyPDF.CurrentPage.ShowImage(I,5,5,300,300,0);
      try
        MyPDF.EndDoc;
      except
        on Exception do
        begin
          MyPDF.Abort;
          raise;
        end;
      end;
      MyPDF.FileName := 'Data\PDFFiles\CCITT4D.pdf';
      MyPDF.DocumentInfo.Title := 'llPDFLib 2 Demo [CCITT4]';
      MyPDF.BeginDoc;
      I:=MyPDF.AddImage('Data\Images\logo.bmp',itcCCITT4);
      MyPDF.CurrentPage.Width:=310;
      MyPDF.CurrentPage.Height:=310;
      MyPDF.CurrentPage.ShowImage(I,5,5,300,300,0);
      try
        MyPDF.EndDoc;
      except
        on Exception do
        begin
          MyPDF.Abort;
          raise;
        end;
      end;
      MyPDF.FileName := 'Data\PDFFiles\Jpeg.pdf';
      MyPDF.DocumentInfo.Title := 'llPDFLib 2 Demo [Jpeg]';
      MyPDF.BeginDoc;
      I:=MyPDF.AddImage('Data\Images\logo.bmp',itcJpeg);
      MyPDF.CurrentPage.Width:=310;
      MyPDF.CurrentPage.Height:=310;
      MyPDF.CurrentPage.ShowImage(I,5,5,300,300,0);
      try
        MyPDF.EndDoc;
      except
        on Exception do
        begin
          MyPDF.Abort;
          raise;
        end;
      end;

    finally
      MyPDF.Free;
    end;
  except
    on E: Exception do
      Writeln(E.message);
  end;
end.

