program korean;
{$APPTYPE CONSOLE}
uses
  SysUtils, PDF, Graphics;

var
  MyPDF: TPDFDocument;
begin
  try
    MyPDF := TPDFDocument.Create(nil);
    try
      MyPDF.FileName := 'Data\PDFFiles\Korean.pdf';
      MyPDF.DocumentInfo.Title := 'llPDFLib 2 Demo [Korean Charset]';
      MyPDF.AutoLaunch := True;
      MyPDF.Compression := ctFlate;
      MyPDF.BeginDoc;
      with MyPDF.CurrentPage do
      begin
        SetRGBColorFill(0.5, 0.5, 0.5);
        BeginText;
        SetActiveFont('', [], 14, 129);
        TextOut(10, 40, 0, '̱ ѱ 95 Ʈе󿡼');
        TextOut(10, 60, 0, 'ۼ Դϴ. ̷ ѱۿ Ͽ');
        TextOut(10, 80, 0, 'Ű ּż մϴ.');
        TextOut(10, 80, 0, 'Ȳ  ');
        EndText;
      end;
      try
        MyPDF.EndDoc;
      except
        on Exception do
        begin
          MyPDF.Abort;
          raise;
        end;
      end;
    finally
      MyPDF.Free;
    end;
  except
    on E: Exception do
      Writeln(E.message);
  end;
end.

