program metafile;
{$APPTYPE CONSOLE}
uses
  SysUtils, PDF, Graphics;

var
  MF: TMetafile;
  MyPDF: TPDFDocument;
begin
  try
    MyPDF := TPDFDocument.Create(nil);
    try
      MyPDF.FileName:='Data\PDFFiles\Metafile.pdf';
      MyPDF.DocumentInfo.Title:='llPDFLib 2 Demo [Work with metafiles]';
      MyPDF.AutoLaunch:=True;
      MyPDF.PageLayout:=plOneColumn;
      MyPDF.Compression:=ctFlate;
      MF := TMetafile.Create;
      try
        MyPDF.BeginDoc;
        MyPDF.CurrentPage.Width:=376;
        MyPDF.CurrentPage.Height:=373;
        MF.LoadFromFile('Data\Images\logo.emf');
        MyPDF.CurrentPage.PlayMetaFile(MF);
        try
          MyPDF.EndDoc;
        except
          on Exception do
          begin
            MyPDF.Abort;
            raise;
          end;
        end;
      finally
        MF.Free;
      end;
    finally
      MyPDF.Free;
    end;
  except
    on E: Exception do
      Writeln(E.message);
  end;
end.


