/*
 * Decompiled with CFR 0.152.
 */
package stec.ss;

import java.util.Stack;
import stec.ss.ssException;
import stec.ss.ssLoopState;
import stec.ss.ssState;

final class ssLoopHandler {
    ssState state;
    private Stack loopStack;

    protected ssLoopHandler(ssState _state) {
        this.state = _state;
        this.loopStack = new Stack();
    }

    protected final void pushState(int _offset) throws Exception {
        this.loopStack.push(new ssLoopState(this.state.gCurrentLineNumber, _offset, this.state.gLevel, this.state.gInStatement));
    }

    protected final void pushState() throws Exception {
        this.loopStack.push(new ssLoopState(this.state.gCurrentLineNumber, this.state.gCurrentProgram.getObject().getIndex(), this.state.gLevel, this.state.gInStatement));
    }

    protected final void popState() throws Exception {
        if (this.loopStack.empty()) {
            throw new ssException(4, "loop/next", "do/for");
        }
        ssLoopState loopState = (ssLoopState)this.loopStack.pop();
        if (loopState.endingProgramOffset != -1) {
            this.state.gCurrentLineNumber = loopState.endingLineNumber;
            this.state.gCurrentProgram.getObject().setIndex(loopState.endingProgramOffset);
        }
    }

    protected final ssLoopState peekAtState() throws Exception {
        if (this.loopStack.empty()) {
            if (this.state.gContinue) {
                throw new ssException(4, "continue", "do/for");
            }
            throw new ssException(4, "break", "do/for");
        }
        return (ssLoopState)this.loopStack.peek();
    }

    protected final void repeatState() throws Exception {
        if (this.loopStack.empty()) {
            throw new ssException(4, "loop/next", "do/for");
        }
        ssLoopState loopState = (ssLoopState)this.loopStack.peek();
        loopState.endingLineNumber = this.state.gCurrentLineNumber;
        loopState.endingProgramOffset = this.state.gCurrentProgram.getObject().getIndex();
        this.state.gInStatement = loopState.inStatement;
        this.state.gCurrentLineNumber = loopState.startingLineNumber;
        this.state.gCurrentProgram.getObject().setIndex(loopState.startingProgramOffset);
        this.state.gRepeatLoop = true;
    }

    protected final boolean inLoop() {
        return !this.loopStack.empty();
    }
}

