/*
 * Decompiled with CFR 0.152.
 */
package stec.ss;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Date;
import java.util.Stack;
import stec.ss.ssException;
import stec.ss.ssLoopHandler;
import stec.ss.ssProgram;
import stec.ss.ssState;
import stec.ss.ssValue;
import stec.ss.ssVariable;
import stec.ss.ssVariableTable;

final class ssSystem
extends ssState {
    private static final String COPYRIGHT = "Copyright (C) 1998-2005 Servertec. All rights reserved.";
    private static final String COMPANY_NAME = "Servertec";
    private static final String PRODUCT_NAME = "iScript";
    private static final String ALT_PRODUCT_NAME;
    private static final String VERSION_NUMBER = "1.2.1";
    private static final String REVISION;
    private static final String RELEASE_DATE = "09/04/2005";
    private static final String RELEASE = "Open Source Release";
    public static boolean logo_displayed;

    ssSystem() {
    }

    private static final void displayLogo(int which) {
        if (!logo_displayed) {
            logo_displayed = true;
            System.err.print(COMPANY_NAME);
            System.err.print(" (R) ");
            if (ALT_PRODUCT_NAME == null) {
                System.err.print(PRODUCT_NAME);
            } else {
                System.err.print(ALT_PRODUCT_NAME);
            }
            switch (which) {
                case 1: {
                    System.err.print(" Server Pages");
                    break;
                }
                case 3: {
                    System.err.print(" Executable");
                    break;
                }
                case 2: {
                    System.err.print(" Preprocessor");
                    break;
                }
                case 4: {
                    System.err.print(" Servlet");
                }
            }
            System.err.print(" Version ");
            System.err.print(VERSION_NUMBER);
            if (REVISION != null) {
                System.err.print(REVISION);
            }
            System.err.print(' ');
            System.err.print(RELEASE_DATE);
            System.err.print(' ');
            System.err.println(RELEASE);
            System.err.println(COPYRIGHT);
            System.err.println();
        }
    }

    protected static final void init(int which) {
        ssSystem.displayLogo(which);
    }

    protected final void genOutput(String output) throws Exception {
        if (this.gSkipLevel == 0 && output.length() > 0) {
            if (this.gProcessor == 1 || this.gProcessor == 4) {
                this.gResponse.print(output);
            } else {
                this.writeLine(output);
            }
        }
    }

    protected final void writeLine(String outputLine) throws Exception {
        if (this.gFileOutputStream == null) {
            System.out.println(outputLine);
        } else {
            this.gFileOutputStream.write(outputLine.getBytes());
        }
    }

    protected final int processParameters(String[] args) throws Exception {
        int paramOffset;
        for (paramOffset = 0; paramOffset < args.length && args[paramOffset].charAt(0) == '-'; ++paramOffset) {
            if (args[paramOffset].equalsIgnoreCase("-nologo")) {
                logo_displayed = true;
                continue;
            }
            if (args[paramOffset].equalsIgnoreCase("-help") || args[paramOffset].equalsIgnoreCase("-h")) {
                logo_displayed = false;
                this.gDisplayHelpOption = true;
                return -1;
            }
            if (args[paramOffset].equalsIgnoreCase("-list") || args[paramOffset].equalsIgnoreCase("-l")) {
                this.gListOption = true;
                continue;
            }
            if (args[paramOffset].equalsIgnoreCase("-verbose") || args[paramOffset].equalsIgnoreCase("-v")) {
                this.gVerboseOption = true;
                continue;
            }
            if (args[paramOffset].equalsIgnoreCase("-compile") || args[paramOffset].equalsIgnoreCase("-c")) {
                this.gCompileOnlyOption = true;
                continue;
            }
            if (this.gProcessor == 1 || !args[paramOffset].equalsIgnoreCase("-file") && !args[paramOffset].equalsIgnoreCase("-f")) continue;
            if (++paramOffset + 1 < args.length) {
                throw new ssException(11, "end of arguements", "file name");
            }
            this.gMakeFile = args[paramOffset];
            this.gFileOption = true;
        }
        if (args.length == paramOffset) {
            this.gDisplayHelpOption = true;
            logo_displayed = false;
        }
        return paramOffset;
    }

    protected final void processMake(String inputFileName) throws Exception {
        int offset = inputFileName.lastIndexOf(46);
        String outputFileName = offset != -1 ? String.valueOf(String.valueOf(inputFileName.substring(0, offset))).concat(".out") : String.valueOf(String.valueOf(inputFileName)).concat(".out");
        this.processMake(inputFileName, outputFileName);
    }

    protected final void processMake(String inputFileName, String outputFileName) throws Exception {
        if (outputFileName.startsWith("*")) {
            int offset = inputFileName.lastIndexOf(46);
            outputFileName = offset != -1 ? String.valueOf(String.valueOf(inputFileName.substring(0, offset))).concat(String.valueOf(String.valueOf(outputFileName.substring(1)))) : String.valueOf(String.valueOf(inputFileName)).concat(String.valueOf(String.valueOf(outputFileName.substring(1))));
        }
        FileOutputStream fileOutputStream = new FileOutputStream(outputFileName);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        boolean currentExit = this.gExit;
        int currentProcessor = this.gProcessor;
        int currentLineNumber = this.gCurrentLineNumber;
        String currentInputFile = this.gCurrentInputFile;
        String currentOutputFile = this.gCurrentOutputFile;
        BufferedOutputStream currentFileOutputStream = this.gFileOutputStream;
        ssLoopHandler loopHandler = this.gLoopHandler;
        int level = this.gLevel;
        int skipLevel = this.gSkipLevel;
        int parenLevel = this.gParenLevel;
        Stack ifTrueStack = this.gIfTrueStack;
        boolean inStatement = this.gInStatement;
        ssProgram program = this.gCurrentProgram;
        this.gExit = false;
        this.gProcessor = 2;
        this.gCurrentInputFile = inputFileName;
        this.gCurrentOutputFile = outputFileName;
        this.gFileOutputStream = bufferedOutputStream;
        this.gLoopHandler = new ssLoopHandler(this);
        this.gLevel = 0;
        this.gSkipLevel = 0;
        this.gParenLevel = 0;
        this.gIfTrueStack = new Stack();
        this.gInStatement = false;
        this.gCurrentLineNumber = 0;
        this.processSource(inputFileName);
        bufferedOutputStream.close();
        this.gExit = currentExit;
        this.gProcessor = currentProcessor;
        this.gCurrentLineNumber = currentLineNumber;
        this.gCurrentInputFile = currentInputFile;
        this.gCurrentOutputFile = currentOutputFile;
        this.gFileOutputStream = currentFileOutputStream;
        this.gLoopHandler = loopHandler;
        this.gLevel = level;
        this.gSkipLevel = skipLevel;
        this.gParenLevel = parenLevel;
        this.gIfTrueStack = ifTrueStack;
        this.gInStatement = inStatement;
        this.gCurrentProgram = program;
    }

    protected final void processInclude(String inputFileName) throws Exception {
        int currentLineNumber = this.gCurrentLineNumber;
        String currentInputFile = this.gCurrentInputFile;
        ssLoopHandler loopHandler = this.gLoopHandler;
        int level = this.gLevel;
        int skipLevel = this.gSkipLevel;
        int parenLevel = this.gParenLevel;
        boolean inStatement = this.gInStatement;
        ssProgram program = this.gCurrentProgram;
        this.gCurrentLineNumber = 0;
        this.gCurrentInputFile = inputFileName;
        this.gLoopHandler = new ssLoopHandler(this);
        this.gLevel = 0;
        this.gSkipLevel = 0;
        this.gParenLevel = 0;
        if (this.gProcessor != 3) {
            this.gInStatement = false;
        }
        this.processSource(inputFileName);
        this.gCurrentLineNumber = currentLineNumber;
        this.gCurrentInputFile = currentInputFile;
        this.gLoopHandler = loopHandler;
        this.gLevel = level;
        this.gSkipLevel = skipLevel;
        this.gParenLevel = parenLevel;
        this.gInStatement = inStatement;
        this.gCurrentProgram = program;
    }

    protected final ssValue processCall(String inputFileName) throws Exception {
        int currentProcessor = this.gProcessor;
        ssValue currentReturnValue = this.gReturnValue;
        int currentLineNumber = this.gCurrentLineNumber;
        String currentInputFile = this.gCurrentInputFile;
        ssLoopHandler loopHandler = this.gLoopHandler;
        int level = this.gLevel;
        int skipLevel = this.gSkipLevel;
        int parenLevel = this.gParenLevel;
        boolean inStatement = this.gInStatement;
        ssProgram program = this.gCurrentProgram;
        this.gProcessor = 3;
        ++this.gScopeLevel;
        this.gReturnValue = null;
        this.gCurrentLineNumber = 0;
        this.gCurrentInputFile = inputFileName;
        this.gLoopHandler = new ssLoopHandler(this);
        this.gLevel = 0;
        this.gSkipLevel = 0;
        this.gParenLevel = 0;
        this.gInStatement = true;
        this.processSource(inputFileName);
        ssValue returnValue = this.gReturnValue;
        this.gVariableTable.removeLevel(this.gScopeLevel);
        this.gProcessor = currentProcessor;
        --this.gScopeLevel;
        this.gReturnValue = currentReturnValue;
        this.gCurrentLineNumber = currentLineNumber;
        this.gCurrentInputFile = currentInputFile;
        this.gLoopHandler = loopHandler;
        this.gLevel = level;
        this.gSkipLevel = skipLevel;
        this.gParenLevel = parenLevel;
        this.gInStatement = inStatement;
        this.gCurrentProgram = program;
        return returnValue;
    }

    protected final long lastModified() {
        File file = new File(this.gInputFile);
        return file.lastModified();
    }

    protected final String path() throws Exception {
        File file = new File(this.gInputFile);
        String path = file.getAbsolutePath();
        if (path == null) {
            return null;
        }
        int offset = path.lastIndexOf(File.separatorChar);
        if (offset != -1) {
            path = path.substring(0, offset);
        }
        return path;
    }

    protected final void processFile(String inputFileName) throws Exception, ssException {
        this.gCurrentLineNumber = 0;
        this.gInputFile = inputFileName;
        this.gCurrentInputFile = inputFileName;
        this.gInStatement = this.gProcessor == 3;
        this.gScopeLevel = 0;
        this.gReturnValue = null;
        this.gVariableTable = new ssVariableTable();
        this.gVariableTable.add("null", new ssVariable(this.gScopeLevel, new ssValue((Object)null), true, true));
        this.gVariableTable.add("true", new ssVariable(this.gScopeLevel, new ssValue(true), true, true));
        this.gVariableTable.add("false", new ssVariable(this.gScopeLevel, new ssValue(false), true, true));
        this.gLoopHandler = new ssLoopHandler(this);
        this.gLevel = 0;
        this.gSkipLevel = 0;
        this.gParenLevel = 0;
        this.gIfTrueStack = new Stack();
        this.processSource(inputFileName);
    }

    protected final void processSource(String inputFileName) throws Exception, ssException {
        File srcFile = new File(inputFileName);
        File objFile = new File(String.valueOf(String.valueOf(inputFileName)).concat(String.valueOf(String.valueOf(this.objectExtension()))));
        if (objFile.exists() && !this.gCompileOnlyOption) {
            if (srcFile.exists()) {
                if (objFile.lastModified() > srcFile.lastModified()) {
                    this.gCurrentProgram = new ssProgram(this);
                    this.gCurrentProgram.load(inputFileName);
                    this.gCurrentProgram.run();
                } else {
                    this.gCurrentProgram = new ssProgram(this, srcFile);
                    this.gCurrentProgram.save(inputFileName);
                    this.gCurrentProgram.run();
                }
            } else {
                this.gCurrentProgram = new ssProgram(this);
                this.gCurrentProgram.load(inputFileName);
                this.gCurrentProgram.run();
            }
        } else if (srcFile.exists()) {
            this.gCurrentProgram = new ssProgram(this, srcFile);
            this.gCurrentProgram.save(inputFileName);
            if (!this.gCompileOnlyOption) {
                this.gCurrentProgram.run();
            }
        } else {
            throw new ssException(String.valueOf(String.valueOf(new StringBuffer("File [").append(inputFileName).append("] does not exist."))));
        }
    }

    protected final String objectExtension() throws ssException {
        switch (this.gProcessor) {
            case 1: 
            case 2: 
            case 4: {
                return ".isp";
            }
            case 3: {
                return ".ise";
            }
        }
        throw new ssException(8, "processor", String.valueOf(this.gProcessor));
    }

    protected final void log(String msg) throws Exception {
        if (this.gLogOutputStream == null) {
            FileOutputStream logOutputStream;
            String logFile = String.valueOf(String.valueOf(System.getProperty("user.dir", "."))).concat(String.valueOf(String.valueOf(File.separator)));
            if (this.gProcessor == 3) {
                if (this.gInputFile == null) {
                    logFile = String.valueOf(String.valueOf(logFile)).concat("ss.log");
                    logOutputStream = new FileOutputStream(logFile, true);
                } else {
                    logFile = String.valueOf(String.valueOf(logFile)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.gInputFile)).concat(".err"))));
                    logOutputStream = new FileOutputStream(logFile);
                }
            } else {
                logFile = String.valueOf(String.valueOf(logFile)).concat("ss.log");
                logOutputStream = new FileOutputStream(logFile, true);
            }
            this.gLogOutputStream = new BufferedOutputStream(logOutputStream);
        }
        String sValue = new Date(System.currentTimeMillis()).toString();
        this.gLogOutputStream.write(sValue.getBytes());
        this.gLogOutputStream.write(58);
        this.gLogOutputStream.write(32);
        if (this.gCurrentInputFile != null) {
            this.gLogOutputStream.write(this.gCurrentInputFile.getBytes());
            this.gLogOutputStream.write(58);
            this.gLogOutputStream.write(32);
        }
        this.gLogOutputStream.write(msg.getBytes());
        this.gLogOutputStream.write(10);
        this.gLogOutputStream.flush();
    }

    protected void display(String msg) {
        System.out.println(msg);
    }

    protected final void flush() throws Exception {
        this.gResponse.setStatus(200);
        this.gResponse.setCharset(null);
        this.gResponse.setContentType("text/html");
        this.gResponse.sendHeader();
        this.gResponse.setIsBuffered(false);
    }

    static {
        COPYRIGHT = COPYRIGHT;
        COMPANY_NAME = COMPANY_NAME;
        PRODUCT_NAME = PRODUCT_NAME;
        ALT_PRODUCT_NAME = null;
        VERSION_NUMBER = VERSION_NUMBER;
        REVISION = null;
        RELEASE_DATE = RELEASE_DATE;
        RELEASE = RELEASE;
        logo_displayed = false;
    }
}

