// sendvw.cpp : implementation file
//

#include "stdafx.h"
#include "socktest.h"

#include "doc.h"
#include "view.h"
#include "sendview.h"
#include "mainfrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSendView

IMPLEMENT_DYNCREATE(CSendView, CEditView)

BEGIN_MESSAGE_MAP(CSendView, CEditView)
	//{{AFX_MSG_MAP(CSendView)
	ON_WM_CHAR()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSendView construction/destruction

CSendView::CSendView()
{
}

CSendView::~CSendView()
{
}

/////////////////////////////////////////////////////////////////////////////
// CSendView drawing

void CSendView::OnDraw(CDC* pDC)
{
}

/////////////////////////////////////////////////////////////////////////////
// CSendView diagnostics

#ifdef _DEBUG
void CSendView::AssertValid() const
{
	CEditView::AssertValid();
}

void CSendView::Dump(CDumpContext& dc) const
{
	CEditView::Dump(dc);
}

CSocktestDoc* CSendView::GetDocument() // non-debug version is inline
{
	return STATIC_DOWNCAST(CSocktestDoc, m_pDocument);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSendView message handlers

/////////////////////////////////////////////////////////////////////////////
BOOL CSendView::PreCreateWindow(CREATESTRUCT& cs) 
{
	BOOL ret = CEditView::PreCreateWindow(cs);
	cs.style = AFX_WS_DEFAULT_VIEW | WS_VSCROLL | WS_HSCROLL | ES_AUTOHSCROLL |
		ES_AUTOVSCROLL | ES_MULTILINE | ES_NOHIDESEL;
	return ret;
}

/////////////////////////////////////////////////////////////////////////////
void CSendView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if ((nChar != VK_RETURN) || (nRepCnt!=1))
	{
		CEditView::OnChar(nChar, nRepCnt, nFlags);
		return;
	}
	else
	{
		CMainFrame * pFWnd = (CMainFrame * )AfxGetMainWnd();
		ASSERT( pFWnd != NULL);

		// only do if object valid (i.e. there is still a connection to send to)
		if(pFWnd->m_pWinsock != NULL)
		{

			CString strText;
			GetEditCtrl().GetWindowText(strText);
			if( strText.GetLength() != 0)
			{
				int ret = pFWnd->m_pWinsock->Send((const char *)strText, strText.GetLength(), 0);
				ASSERT( ret == strText.GetLength());
			}
			pFWnd->m_pWinsock->Send("\r\n",2,0);


			CSocktestView * p = (CSocktestView *)(pFWnd->m_wndSplitter.GetPane(0,0));
			CString sPreface = "SockTest Echo>";
			sPreface += strText;
			p->Log((const char *)sPreface);
			p->Log("\r\n");
		}
		else
		{
			::MessageBeep(MB_OK);
		}
		// clear the user input edit box
		GetEditCtrl().SetWindowText("");
	}
}









