VERSION 5.00
Object = "{C0A58BC3-1600-4C2C-8DDB-2DD7FDE5CA63}#1.0#0"; "vbalIml200_75B4A91C.ocx"
Object = "{23F895D7-45A6-4886-931B-89D88C2857ED}#2.0#0"; "iGrid250_75B4A91C.ocx"
Begin VB.Form frmCustomTree 
   Caption         =   "CustomTreeView Demo"
   ClientHeight    =   4890
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   6540
   Icon            =   "CustomTree.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   4890
   ScaleWidth      =   6540
   StartUpPosition =   3  'Windows Default
   Begin vbalIml200_75B4A91C.vbalImageList vbalImageList1 
      Left            =   5940
      Top             =   1140
      _ExtentX        =   953
      _ExtentY        =   953
      IconSizeX       =   11
      IconSizeY       =   11
      ColourDepth     =   24
      Size            =   3528
      Images          =   "CustomTree.frx":0442
      Version         =   131072
      KeyCount        =   6
      Keys            =   ""
   End
   Begin iGrid250_75B4A91C.iGrid iGrid1 
      Height          =   3495
      Left            =   120
      TabIndex        =   0
      Top             =   1320
      Width           =   6315
      _ExtentX        =   11139
      _ExtentY        =   6165
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   204
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.Label Label1 
      Caption         =   $"CustomTree.frx":122A
      Height          =   855
      Index           =   1
      Left            =   120
      TabIndex        =   2
      Top             =   420
      Width           =   6315
   End
   Begin VB.Label Label1 
      Caption         =   "This demo shows how you can implement treeview in iGrid."
      Height          =   255
      Index           =   0
      Left            =   120
      TabIndex        =   1
      Top             =   120
      Width           =   6315
   End
End
Attribute VB_Name = "frmCustomTree"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const LEVEL_INDENT = 11 ' in pixels

' Indices in the attached ImageList:
Private Const PLUS_ICO = 0
Private Const MINUS_ICO = 1

Private Sub Form_Load()
   Dim i As Long
   Dim oFont As StdFont

   With iGrid1
      .Redraw = False
      
      ' --- the grid settings
      .ImageList = vbalImageList1
      .RowMode = True
      .ShowControlsInAllCells = True
      
      With .Combos.Add("info3")
         .AddItem sItemText:="First", vItemValue:=1
         .AddItem sItemText:="Second", vItemValue:=2
         .AddItem sItemText:="Third", vItemValue:=3
         .AddItem sItemText:="Fourth", vItemValue:=4
         .AddItem sItemText:="Fifth", vItemValue:=5
         .AddItem sItemText:="Sixth", vItemValue:=6
         .AutoAdjustWidth
      End With
      
      ' --- defining the structure
      .AddCol sKey:="tree", sHeader:="TreeView", lWidth:=128
      .AddCol sKey:="info1", sHeader:="Info1"
      With .AddCol(sKey:="info2", sHeader:="Info2")
         .eType = igCellCheck
         .eTypeFlags = igCheckBoxFlat Or igCheckBox3State
      End With
      With .AddCol(sKey:="info3", sHeader:="Info3")
         .eType = igCellCombo
         .eTypeFlags = igComboBtnFlat
         .sCtrlKey = "info3"
      End With
      ' housekeeping columns:
      .AddCol sKey:="level", bVisible:=False ' nesting level (from zero)
      .AddCol sKey:="loaded", bVisible:=False ' child items have already loaded
      .AddCol sKey:="visible", bVisible:=False ' visibility of collapsed rows
      
      ' --- initial populating
      For i = 1 To 3
         .AddRow
         .CellValue(i, "tree") = "Item " & i
         .CellExtraIcon(i, "tree") = PLUS_ICO ' cell extra icon shows the plus or minus button
         .CellValue(i, "level") = 0
         .CellValue(i, "loaded") = False
         .CellValue(i, "visible") = True
         pSetItemInfo i
      Next
      
      .Redraw = True
   End With
End Sub

Private Sub pSetItemInfo(ByVal plRow As Long)
   With iGrid1
      .CellIcon(plRow, "tree") = .CellValue(plRow, "level") + 2
      .CellValue(plRow, "info1") = .CellValue(plRow, "tree") & ", info1"
      .CellValue(plRow, "info2") = Round(Rnd() * 3)
      .CellValue(plRow, "info3") = Int(Rnd() * 6 + 1)
   End With
End Sub

Private Sub Form_Resize()
   On Error Resume Next
   iGrid1.Move 120, iGrid1.Top, Me.ScaleWidth - 240, Me.ScaleHeight - iGrid1.Top - 120
End Sub

Private Sub iGrid1_ColHeaderBeginDrag(ByVal lCol As Long, bCancel As Boolean)
   If lCol = 1 Then
      MsgBox "You can not move this column!"
      bCancel = True
   End If
End Sub

Private Sub iGrid1_ColHeaderClick(ByVal lCol As Long, bDoDefault As Boolean, ByVal Shift As Integer, ByVal x As Long, ByVal y As Long)
   bDoDefault = False ' we can not sort the grid because it has the tree...
End Sub

Private Sub iGrid1_ColHeaderEndDrag(ByVal lCol As Long, ByVal lColBefore As Long, bCancel As Boolean)
   If lColBefore = 1 Then
      MsgBox "You can not move this column at the first position!"
      bCancel = True
   End If
End Sub

Private Sub iGrid1_DblClick(ByVal lRow As Long, ByVal lCol As Long, bRequestEdit As Boolean)
   If lRow = 0 Or lCol <> 1 Then Exit Sub
   
   Select Case iGrid1.CellExtraIcon(lRow, "tree")
   Case PLUS_ICO
      pExpandRow lRow
   Case MINUS_ICO
      pCollapseRow lRow
   End Select
End Sub

Private Sub iGrid1_MouseDown(ByVal Button As Integer, Shift As Integer, ByVal x As Single, ByVal y As Single, ByVal lRow As Long, ByVal lCol As Long, bDoDefault As Boolean, ByVal bUnderControl As Boolean)
   Dim lLevel As Long
   
   If lRow = 0 Or lCol <> 1 Then Exit Sub ' treating only the first ("tree") column
   
   lLevel = iGrid1.CellValue(lRow, "level")
   If x >= lLevel * LEVEL_INDENT And x < (lLevel + 1) * LEVEL_INDENT Then ' the user clicks the plus or minus button
      Select Case iGrid1.CellExtraIcon(lRow, "tree")
      Case PLUS_ICO
         pExpandRow lRow
      Case MINUS_ICO
         pCollapseRow lRow
      End Select
   End If
End Sub

Private Sub pCollapseRow(ByVal plRow As Long)
   Dim lRow As Long
   Dim lCurLevel As Long
   
   lRow = plRow
   lCurLevel = iGrid1.CellValue(plRow, "level")
   
   iGrid1.Redraw = False
   
   Do
      lRow = lRow + 1
      If lRow > iGrid1.RowCount Then Exit Do
      If iGrid1.CellValue(lRow, "level") <= lCurLevel Then Exit Do
      iGrid1.CellValue(lRow, "visible") = iGrid1.RowVisible(lRow)
      iGrid1.RowVisible(lRow) = False
   Loop
   
   iGrid1.CellExtraIcon(plRow, "tree") = PLUS_ICO
   
   iGrid1.Redraw = True
End Sub

Private Sub pExpandRow(ByVal plRow As Long)
   Dim lRow As Long
   Dim lCurLevel As Long
   
   If fbLoadChildItems(plRow) Then ' we load child items and show them,
                                       ' thus we don't need to expand this row
      
      iGrid1.CellExtraIcon(plRow, "tree") = MINUS_ICO
      
   Else
      ' expanding the row
      
      lRow = plRow
      lCurLevel = iGrid1.CellValue(plRow, "level")
      
      iGrid1.Redraw = False
      
      Do
         lRow = lRow + 1
         If lRow > iGrid1.RowCount Then Exit Do
         If iGrid1.CellValue(lRow, "level") <= lCurLevel Then Exit Do
         If iGrid1.CellValue(lRow, "level") = lCurLevel + 1 Then
            iGrid1.RowVisible(lRow) = True ' the first nesting level is always expanded
         Else
            iGrid1.RowVisible(lRow) = iGrid1.CellValue(lRow, "visible")
         End If
      Loop
      
      iGrid1.CellExtraIcon(plRow, "tree") = MINUS_ICO
      
      iGrid1.Redraw = True
   End If
End Sub

Private Function fbLoadChildItems(ByVal plRow As Long) As Boolean
   Dim i As Long
   Dim lItemCount As Long
   Dim lCurRow As Long
   Dim sParentItemCap As String
   Dim lNewLevel As Long
   Dim bAddRowToEnd As Boolean
   
   If Not iGrid1.CellValue(plRow, "loaded") Then
      ' loading child items
      lItemCount = Rnd() * 5 + 1
      sParentItemCap = iGrid1.CellValue(plRow, "tree")
      lNewLevel = iGrid1.CellValue(plRow, "level") + 1
      bAddRowToEnd = plRow = iGrid1.RowCount
      iGrid1.Redraw = False
      For i = 1 To lItemCount
         lCurRow = plRow + i
         If bAddRowToEnd Then
            iGrid1.AddRow
         Else
            iGrid1.AddRow vRowBefore:=lCurRow
         End If
         ' setting the tree item info
         iGrid1.CellValue(lCurRow, "tree") = sParentItemCap & "-" & i
         iGrid1.CellValue(lCurRow, "level") = lNewLevel
         If lNewLevel <= 2 Then ' in this sample we use up to 4 levels
            iGrid1.CellExtraIcon(lCurRow, "tree") = PLUS_ICO
            iGrid1.CellIndent(lCurRow, "tree") = lNewLevel * LEVEL_INDENT
         Else
            ' we need to add additional 2+2 pixels to align cell icon
            ' because iGrid inserts in 2 pixels between cell icon and extra icon and
            ' between cell icon and cell text
            iGrid1.CellIndent(lCurRow, "tree") = (lNewLevel + 1) * LEVEL_INDENT + 4
         End If
         iGrid1.CellValue(lCurRow, "loaded") = False
         iGrid1.CellValue(lCurRow, "visible") = True
         pSetItemInfo lCurRow
      Next
      iGrid1.CellValue(plRow, "loaded") = True
      iGrid1.Redraw = True
      
      fbLoadChildItems = True
   End If
End Function

Private Sub iGrid1_RequestEdit(ByVal lRow As Long, ByVal lCol As Long, ByVal iKeyAscii As Integer, bCancel As Boolean, sText As String, lMaxLength As Long, eTextEditOpt As iGrid250_75B4A91C.ETextEditFlags)
   bCancel = lCol = 1 ' to prevent the first column from editing when the user doubleclicks it
End Sub
