VERSION 5.00
Object = "{23F895D7-45A6-4886-931B-89D88C2857ED}#1.0#0"; "iGrid250_75B4A91C.ocx"
Begin VB.Form frmOLEDnD2Xl 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "OLE Drag-n-drop: Dragging iGrid cells to MS Excel"
   ClientHeight    =   5625
   ClientLeft      =   3045
   ClientTop       =   435
   ClientWidth     =   7905
   Icon            =   "OLEDnD2Xl.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5625
   ScaleWidth      =   7905
   Begin VB.CommandButton cmdSelExmpl 
      Caption         =   "Selection Example"
      Height          =   615
      Left            =   6540
      TabIndex        =   1
      Top             =   1080
      Width           =   1215
   End
   Begin iGrid250_75B4A91C.iGrid iGrid1 
      Height          =   4335
      Left            =   120
      TabIndex        =   0
      Top             =   1080
      Width           =   6255
      _ExtentX        =   11033
      _ExtentY        =   7646
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   204
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.Label Label2 
      Caption         =   "The Selection Example button demonstrates that you can drag into Excel not only rectangular blocks of cells."
      Height          =   255
      Left            =   120
      TabIndex        =   3
      Top             =   600
      Width           =   7695
   End
   Begin VB.Label Label1 
      Caption         =   $"OLEDnD2Xl.frx":0442
      Height          =   375
      Left            =   120
      TabIndex        =   2
      Top             =   120
      Width           =   7695
   End
End
Attribute VB_Name = "frmOLEDnD2Xl"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private m_lFirstSelRow As Long
Private m_lLastSelRow As Long
Private m_lFirstSelCol As Long
Private m_lLastSelCol As Long


Private Sub cmdSelExmpl_Click()
   Dim iRow As Long
   Dim iCol As Long

   With iGrid1
      .Redraw = False
      
      ' Scroll the grid so the user will see the first row
      .VScrollBar.Value = 0
      
      ' clearing existing selection
      For iRow = 1 To .RowCount
         For iCol = 1 To .ColCount
            .CellSelected(iRow, iCol) = False
         Next
      Next
      
      ' generating our own selection
      For iRow = 2 To 3
         For iCol = 2 To 8
            .CellSelected(iRow, iCol) = True
         Next
      Next
      For iRow = 4 To 8
         .CellSelected(iRow, 2) = True
         .CellSelected(iRow, 3) = True
         .CellSelected(iRow, 7) = True
         .CellSelected(iRow, 8) = True
      Next
      For iRow = 9 To 10
         For iCol = 2 To 8
            .CellSelected(iRow, iCol) = True
         Next
      Next
      .CellSelected(12, 7) = True
      .CellSelected(12, 8) = True
      .CellSelected(12, 9) = True
      .CellSelected(13, 7) = True
      
      .Redraw = True
   End With
   
   iGrid1.SetFocus
End Sub

Private Sub Form_Load()
   Dim iRow As Long
   Dim iCol As Long
   
   With iGrid1
      .Redraw = False
      
      .MultiSelect = True
      
      For iCol = 1 To 9
         .AddCol sHeader:="Col " & iCol, lWidth:=42
      Next
      
      .RowCount = 50
      
      For iRow = 1 To .RowCount
         For iCol = 1 To .ColCount
            .CellValue(iRow, iCol) = "R" & iRow & "C" & iCol
         Next
      Next
      
      .Redraw = True
   End With
End Sub

Private Sub iGrid1_StartCellDrag(ByVal Button As Integer, ByVal Shift As Integer, ByVal x As Single, ByVal y As Single, ByVal lRow As Long, ByVal lCol As Long)
   Dim iRow As Long
   Dim iCol As Long
   
   m_lFirstSelRow = iGrid1.RowCount + 1
   m_lLastSelRow = 0
   m_lFirstSelCol = iGrid1.ColCount + 1
   m_lLastSelCol = 0

   For iRow = 1 To iGrid1.RowCount
      For iCol = 1 To iGrid1.ColCount
         If iGrid1.CellSelected(iRow, iCol) Then
            If iRow < m_lFirstSelRow Then
               m_lFirstSelRow = iRow
            End If
            If iCol < m_lFirstSelCol Then
               m_lFirstSelCol = iCol
            End If
            If iRow > m_lLastSelRow Then
               m_lLastSelRow = iRow
            End If
            If iCol > m_lLastSelCol Then
               m_lLastSelCol = iCol
            End If
         End If
      Next
   Next
   
   If m_lLastSelRow = 0 Then ' nothing to drag
      Exit Sub
   End If
   
   ' start OLE Drag-n-drop
   iGrid1.OLEDrag
   
   ' see the OLEStartDrag event for further details
End Sub

Private Sub iGrid1_OLEStartDrag(Data As DataObject, AllowedEffects As Long)
   Dim iRow As Long
   Dim iCol As Long
   Dim strDrag As String
   
   ' Creating a string that represents a rectangular block of data.
   ' MS Excel accepts only rectangular sets of cells and we replace
   ' all non-selected cells with empty strings.
   ' Cell values must be separated by the TAB character (Chr(9)) and
   ' each row of cells must be ended with Chr(13)+Chr(10)
   
   For iRow = m_lFirstSelRow To m_lLastSelRow
      For iCol = m_lFirstSelCol To m_lLastSelCol
         With iGrid1
            strDrag = strDrag & _
               IIf(.CellSelected(iRow, iCol), .CellValue(iRow, iCol), "") & _
               IIf(iCol < m_lLastSelCol, vbTab, "")
         End With
      Next
      strDrag = strDrag & vbCrLf
   Next
   
   Data.SetData strDrag, vbCFText
   AllowedEffects = vbDropEffectCopy
End Sub
