// vecim.h : Declaration of the Cvecim

#ifndef __VECIM_H_
#define __VECIM_H_

#include "resource.h"       // main symbols

/////////////////////////////////////////////////////////////////////////////
// Cvecim
class ATL_NO_VTABLE Cvecim : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<Cvecim, &CLSID_vecim>,
	public IDispatchImpl<Ivecim, &IID_Ivecim, &LIBID_VECOMLib>
{
public:
	Cvecim()
	{
		m_bstrCurOperation = NULL;
		m_curOperChanged = FALSE;
		m_curOper = "";
	}

	~Cvecim()
	{
//		if (m_bstrCurOperation)
//			SysFreeString(m_bstrCurOperation);
	}

DECLARE_REGISTRY_RESOURCEID(IDR_VECIM)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(Cvecim)
	COM_INTERFACE_ENTRY(Ivecim)
	COM_INTERFACE_ENTRY(IDispatch)
END_COM_MAP()
 
// Ivecim
public: 
	HRESULT _stdcall Test1( );
	HRESULT _stdcall OpenRaster(BSTR fname ,
		long* pPixelperMeter, long* retval);
	HRESULT _stdcall DelObject( long hBmp);
	HRESULT _stdcall SaveRaster(BSTR fname, long hBmp, 
		 long pixelPerMeter, BOOL* retval);
	HRESULT _stdcall RotateByLine(long hBmp,long pixelPerMeter, 
		long xBeg, long yBeg, long xEnd, long yEnd, long* retval);
	HRESULT _stdcall MirrorVertically(long hBmp,BOOL* retval);
	HRESULT _stdcall RotateLeft(long hBmp,long pixelPerMeter, 
		long* retval);
	HRESULT _stdcall RotateRight(long hBmp,long pixelPerMeter,
		long* retval);
	HRESULT _stdcall Negate(long hBmp, BOOL* retval);
	HRESULT _stdcall Crop(long hBmp,long pixelPerMeter,long xTopLeft,long yTopLeft, 
		long xBottomRight, long yBottomRight, long* retval);
	HRESULT _stdcall FillSmallHoles(long hBmp, BOOL* retval);
	HRESULT _stdcall FillHoles(long hBmp, BOOL* retval);
	HRESULT _stdcall Connect(long hBmp, BOOL* retval);
	HRESULT _stdcall Clean(long hBmp, BOOL* retval);
	HRESULT _stdcall Thin(long hBmp, BOOL* retval);
	HRESULT _stdcall Thicken(long hBmp, BOOL* retval);

	HRESULT _stdcall Vectorize(long hBmp,long pixelPerMeter, 
		BSTR parameters, long progrCallback, BOOL* retval );

	HRESULT _stdcall Stop();
	HRESULT _stdcall GetProgress(long* prog, BSTR* retval);	
	HRESULT _stdcall IsVectorizationTerminated(BOOL* retval);
 
	HRESULT _stdcall Request(long* retval);
	HRESULT _stdcall Reply( long reply);

	HRESULT _stdcall ClearSettings( );
	HRESULT _stdcall AddSettingLine(BSTR line );
	HRESULT _stdcall VectorizeGS(long hBmp,long pixelPerMeter, 
		long progrCallback, BOOL* retval );

	HRESULT _stdcall GetProgress( long* retval );
	HRESULT _stdcall IsCurOperChanged( BOOL* retval );
	HRESULT _stdcall GetCuOper( BSTR* retval );

	HRESULT _stdcall SetScCallBack( long val);


	CString m_curOper;
	BOOL m_curOperChanged;
	BSTR m_bstrCurOperation;
};

#endif //__VECIM_H_
