/*
 * Decompiled with CFR 0.152.
 */
package com.others;

import com.others.GIFImageDecoder;
import com.others.ImageCodec;
import com.others.ImageDecodeParam;
import com.others.ImageDecoder;
import com.others.ImageEncodeParam;
import com.others.ImageEncoder;
import com.others.SeekableStream;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class GIFCodec
extends ImageCodec {
    public String getFormatName() {
        return "gif";
    }

    public Class getEncodeParamClass() {
        return Class.forName("java.lang.Object");
    }

    public Class getDecodeParamClass() {
        return Class.forName("java.lang.Object");
    }

    public boolean canEncodeImage(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        return false;
    }

    protected ImageEncoder createImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        return null;
    }

    protected ImageDecoder createImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        return new GIFImageDecoder(inputStream, imageDecodeParam);
    }

    protected ImageDecoder createImageDecoder(File file, ImageDecodeParam imageDecodeParam) throws IOException {
        return new GIFImageDecoder(new FileInputStream(file), null);
    }

    protected ImageDecoder createImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        return new GIFImageDecoder((InputStream)seekableStream, imageDecodeParam);
    }

    public int getNumHeaderBytes() {
        return 4;
    }

    public boolean isFormatRecognized(byte[] byArray) {
        return byArray[0] == 71 && byArray[1] == 73 && byArray[2] == 70 && byArray[3] == 56;
    }
}

