<% response.setContentType("text/plain"); // make saving the doc easier on some browsers.  %><% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ 

PageUtils.jspStart(request); 

// Added this after finding an apparent bug in Tomcat: the page was cutting itself off after
// exactly 8K of output; this is the default buffer, so I increase the buffer here (this should
// absolutely not be necessary, but it does seem to fix the problem):
%><%@ page import="java.util.*" %><%@ page import="com.workroll.app.filesystem.*" %><%@ page import="com.workroll.app.entity.*" %><%@ page import="com.workroll.app.db.*" %><%@ page import="com.workroll.app.util.*" %><% 

 

PageUtils.setRequiredLoginStatus("user",request);
PageUtils.setPathToAppRoot("../",request);
PageUtils.setSection(WorkRollConstants.SECTION_ISSUES,request);
PageUtils.setSubsection(WorkRollConstants.SUBSECTION_ISSUES_EXPORT,request); 

%><%@ include file="../global/topInclude.jsp" %><%

String exportType=controller.getParam("exportType");
boolean isActiveIssues=(exportType.equals("active") || exportType.equals("all"));

 
HashMap sortNamesToColumnNamesMap=new HashMap();
sortNamesToColumnNamesMap.put("idSort","ID");
sortNamesToColumnNamesMap.put("assignedByUserFullnameSort","By");
sortNamesToColumnNamesMap.put("assignedToUserFullnameSort","To");
sortNamesToColumnNamesMap.put("statusSort","Status");
sortNamesToColumnNamesMap.put("prioritySort","Priority");
sortNamesToColumnNamesMap.put("projectNameSort","Project");
sortNamesToColumnNamesMap.put("instanceNameSort","Instance");
sortNamesToColumnNamesMap.put("openDateSort","Opened");
sortNamesToColumnNamesMap.put("dueDateSort","Due");
sortNamesToColumnNamesMap.put("descriptionSort","Description");


IssueFilter filter=controller.getSessionInfo().getCurrentFilter();

// No matter how user has filtered for status (possibly having set the filter on a different list), we want to determine how statuses are handled:
if (exportType.equals("active"))
{
	if (filter!=null && filter.getStatuses()==IssueFilter.CLOSED_ONLY)
	{
		filter=(IssueFilter)filter.clone();
		filter.setStatuses(IssueFilter.OPEN_AND_RESOLVED);
	}
}
else if (exportType.equals("closed"))
{
	if (filter!=null && filter.getStatuses()!=IssueFilter.CLOSED_ONLY)
	{
		filter=(IssueFilter)filter.clone();
		filter.setStatuses(IssueFilter.CLOSED_ONLY);
	}
}
else
{
	if (filter!=null)
	{
		filter=(IssueFilter)filter.clone();
		filter.setStatuses(IssueFilter.ALL);
	}

}

// Following arrays for use by staticList.jsp:
String[] headerNames={"ID","By","To","Status","Priority","Project","Instance","Opened","Due","Description",""};
ArrayList issuesForPreview=null;
int[] colWidths={0,0,0,0,0,0,0,0,0,0,0};

boolean isActiveListFooter=false;
String filterTableWidth="642";

// Include expects these vars (constant defined in include itself):
int listType=LIST_TYPE_EXPORT;

String staticListSortName=controller.getParam("sortBy","openDateSort");
boolean staticListSortAscending=controller.getParamAsBoolean("sortAscending",true);
boolean staticListDoFilterIfFound=controller.getParamAsBoolean("useCurrentFilter");

%><%@ include file="includes/staticListTop.jsp" %><%@ include file="includes/staticList.jsp" %><%@ include file="../global/bottomInclude.jsp" %><%
if (pageException!=null)
{
	%><%@ include file="../global/jspErrorDialogLaunch.jsp" %><%
}
%><% PageUtils.jspEnd(request); %>