<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>
  
 
<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>     
 
<%@ page import="java.util.*" %>
 
<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>
<%@ page import="com.workroll.app.session.*" %>

<% PageUtils.setSkipTrialPeriodExpireCheck(true,request); %>
<% PageUtils.setSkipMaxUsersExceededCheck(true,request); %>

<% PageUtils.setRequiredLoginStatus("none",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_LOGIN,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%!

%> 

<%

boolean error=controller.getParamAsBoolean("error");

InstallationConfig installationConfig=controller.getCurrentInstallationConfig();
SessionInfo sessionInfo=controller.getSessionInfo();

User user=Manager.selectUserByUsername(controller.getParam("username"));

boolean isRecognizedUser=(user!=null);
boolean secretQuestionOnFile=false;

int secretQuestion=0;

String questionText="";

if (isRecognizedUser)
{
	secretQuestion=user.getSecretQuestion();
	if (secretQuestion>0)
	{
		secretQuestionOnFile=true;
		for (int i=0; i<WorkRollConstants.SECRET_QUESTION_LABELS.length; i++)
		{
			if (secretQuestion==WorkRollConstants.SECRET_QUESTION_VALUES[i])
			{
				questionText=WorkRollConstants.SECRET_QUESTION_LABELS[i];
				break;
			}
		}
	}
}

String adminName=PageUtils.nonNull(installationConfig.getAdminName()).trim();
String adminEmail=PageUtils.nonNull(installationConfig.getAdminEmail()).trim();
boolean showAdminLink=(adminName.length()>0 && adminEmail.length()>0);


%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
 
<%@ include file="../global/headInclude.jsp" %>
<%@ include file="../global/validationJs.jsp" %>


<script language="JavaScript">

// this page may load in a frame (e.g. on the "list" page), so don't allow that:

if (top.frames.length>0)
{
	top.location.replace(""+location.href)
}

function isValidForm(formObj)
{
	var els=formObj.elements

	if (trim(els["secretAnswer"].value).length==0)
	{
		errorAlert("You have not entered an answer.  Please enter one and try again.",els["secretAnswer"])
		return false
	}
	hidePageAndShowPleaseWait()
	return true
}

</script>

<style type="text/css">
 
</style>
</head>

<%@ include file="../global/bodyOpen.jsp" %>

<div id=<%=isPopup?"popupMainDiv":"mainDiv"%>>
<span class=standardTextBlockWidth>

<%
if (error)
{	
	%>
	<div class=errorDiv><font class=bodyFont>
	The answer that you gave to your secret question was not the same answer you entered when you originally entered your answer.  Please try again, making sure that you've typed exactly what you typed before.
	</font></div><BR>
	<%
}
%>


	<%
	if (!isRecognizedUser)
	{
		%>
		<form action=# onsubmit="return false">
		<font class=bodyFont>    
		<span class=firstSentenceFont>Hmmm...</span>  "<%=controller.getParam("username")%>" is not a recognized username.  Please click "back" and try again.<BR><BR>

		<input  class=formButton type=button value="back" onclick="history.go(-1)"><BR>

		</font>


		</form>
		<%
	}
	else if (!secretQuestionOnFile)
	{
		%>
		<form action=# onsubmit="return false">
		<font class=bodyFont>    
		<span class=firstSentenceFont>Hmmm...</span>  WorkRoll does not have a secret question/answer combination on file for user "<%=controller.getParam("username")%>". Please contact <a href="mailto:<%=adminEmail%>"><%=adminEmail%></a> or another administrator and have him or her change your password.<BR><BR>

		<input  class=formButton type=button value="back" onclick="history.go(-1)"><BR>

		</font>


		</form>
		<%
	}
	else
	{
		%>
		<form action=processSecretQuestion.jsp?isPopup=<%=isPopup%> method=post onsubmit="return isValidForm(this)">
		<input type=hidden name=username id=username value="<%=controller.getParam("username")%>">
		<font class=bodyFont>    
		<span class=firstSentenceFont>Your secret question is </span>  "<%=questionText%>"  Please type your answer below, then click "submit"; you must type the answer exactly as you did when you originally answered this question:<BR><BR>
		<span class=boldishFont>Answer to secret question</span><BR>
		<input type=text class=inputText name=secretAnswer id=secretAnswer size=26><%=HtmlUtils.doubleLB(request)%><BR>
		<input  class=formButton type=submit value="submit"><BR>
		<BR><BR>

		

		</font>


		</form>
		<%
	}
	%>

      
      
      
  </span>

</div>

<%@ include file="../global/bodyClose.jsp" %>

</html>


<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

