/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;
import org.apache.xpath.patterns.StepPattern;

public class ContextMatchStepPattern
extends StepPattern {
    public ContextMatchStepPattern(int axis, int paxis) {
        super(-1, axis, paxis);
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        if (xctxt.getIteratorRoot() == xctxt.getCurrentNode()) {
            return this.getStaticScore();
        }
        return NodeTest.SCORE_NONE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XObject executeRelativePathPattern(XPathContext xctxt, StepPattern prevStep) throws TransformerException {
        XObject score = NodeTest.SCORE_NONE;
        int context = xctxt.getCurrentNode();
        DTM dtm = xctxt.getDTM(context);
        if (dtm != null) {
            boolean iterRootIsAttr;
            int predContext = xctxt.getCurrentNode();
            int axis = this.m_axis;
            boolean needToTraverseAttrs = WalkerFactory.isDownwardAxisOfMany(axis);
            boolean bl = iterRootIsAttr = dtm.getNodeType(xctxt.getIteratorRoot()) == 2;
            if (axis == 11 && iterRootIsAttr) {
                axis = 15;
            }
            DTMAxisTraverser traverser = dtm.getAxisTraverser(axis);
            int relative = traverser.first(context);
            while (relative != -1) {
                Object var14_12;
                block12: {
                    XObject xObject;
                    block14: {
                        try {
                            xctxt.pushCurrentNode(relative);
                            score = this.execute(xctxt);
                            if (score != NodeTest.SCORE_NONE) {
                                if (this.executePredicates(xctxt, dtm, context)) {
                                    XObject xObject2 = score;
                                    var14_12 = null;
                                    xctxt.popCurrentNode();
                                    return xObject2;
                                }
                                score = NodeTest.SCORE_NONE;
                            }
                            if (!needToTraverseAttrs || !iterRootIsAttr || dtm.getNodeType(relative) != 1) break block12;
                            int xaxis = 2;
                            int i = 0;
                            block5: while (i < 2) {
                                DTMAxisTraverser atraverser = dtm.getAxisTraverser(xaxis);
                                int arelative = atraverser.first(relative);
                                while (true) {
                                    Object var20_17;
                                    block13: {
                                        if (arelative == -1) {
                                            xaxis = 9;
                                            ++i;
                                            continue block5;
                                        }
                                        try {
                                            xctxt.pushCurrentNode(arelative);
                                            score = this.execute(xctxt);
                                            if (score == NodeTest.SCORE_NONE || score == NodeTest.SCORE_NONE) break block13;
                                            xObject = score;
                                            var20_17 = null;
                                            xctxt.popCurrentNode();
                                            break block14;
                                        }
                                        catch (Throwable throwable) {
                                            var20_17 = null;
                                            xctxt.popCurrentNode();
                                            throw throwable;
                                        }
                                    }
                                    var20_17 = null;
                                    xctxt.popCurrentNode();
                                    arelative = atraverser.next(relative, arelative);
                                }
                            }
                            break block12;
                        }
                        catch (Throwable throwable) {
                            var14_12 = null;
                            xctxt.popCurrentNode();
                            throw throwable;
                        }
                    }
                    var14_12 = null;
                    xctxt.popCurrentNode();
                    return xObject;
                }
                var14_12 = null;
                xctxt.popCurrentNode();
                relative = traverser.next(context, relative);
            }
        }
        return score;
    }
}

